/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.NONE)
public class ShowFeedback
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWFEEDBACK = new String[]{"feedback", "feedbac", "feedba", "feedb", "feed"};

    @Override
    public String[] getShowAliases() {
        return SHOWFEEDBACK;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doFeedback(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    public boolean doFeedback(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        int feedback = ctx.getFeedback();
        String message = "";
        if (feedback == -1) {
            message = MessageFormat.format(Messages.getString("FEEDBACKONFORN"), "FEEDBACK ON", 1);
        } else if (feedback == -3) {
            message = "feedback ONLY\n";
        } else if (feedback == -2) {
            message = "feedback OFF\n";
        } else if (feedback == 0) {
            ctx.setFeedback(-2);
            message = "feedback OFF\n";
        } else {
            message = MessageFormat.format(Messages.getString("FEEDBACKONFORN"), "FEEDBACK ON", feedback);
        }
        message = MessageFormat.format("{0} SQL_ID {1}\n", message.replaceAll("\\n", ""), ctx.getFeedbackSQLID() ? "ON" : "OFF");
        ctx.write(message);
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        int feedback = ctx.getFeedback();
        if (feedback == -1) {
            return StoreRegistry.getCommand("feedback", "1");
        }
        if (feedback == -2) {
            return StoreRegistry.getCommand("feedback", "OFF");
        }
        if (feedback == 0) {
            return StoreRegistry.getCommand("feedback", "OFF");
        }
        return StoreRegistry.getCommand("feedback", String.valueOf(feedback));
    }
}

