/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.model;

import oracle.dbtools.data.common.NullOrEmpty;
import oracle.dbtools.rest.RestMessages;

public class RestHandlerParameter {
    public static final String ACCESS_METHOD_IN = "IN";
    public static final String ACCESS_METHOD_INOUT = "INOUT";
    public static final String ACCESS_METHOD_OUT = "OUT";
    public static final String SOURCE_TYPE_HEADER = "header";
    public static final String SOURCE_TYPE_URI = "uri";
    public static final String SOURCE_TYPE_RESPONSE = "response";
    public static final String DATA_TYPE_STRING = "String";
    public static final String DATA_TYPE_INTEGER = "Integer";
    public static final String DATA_TYPE_INT = "Int";
    public static final String DATA_TYPE_LONG = "Long";
    public static final String DATA_TYPE_DOUBLE = "Double";
    public static final String DATA_TYPE_BOOLEAN = "Boolean";
    public static final String DATA_TYPE_TIMESTAMP = "Timestamp";
    public static final String DATA_TYPE_RESULTSET = "Resultset";
    private String _name;
    private String _bindVariable;
    private ACCESS_METHOD_TYPE _accessMethod;
    private SOURCE_TYPE _sourceType;
    private DATA_TYPE _dataType;
    private String _comments;

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getBindVariable() {
        return this._bindVariable;
    }

    public void setBindVariable(String bindVariable) {
        this._bindVariable = bindVariable;
    }

    public DATA_TYPE getDataType() {
        return this._dataType;
    }

    public void setDataType(DATA_TYPE dataType) {
        this._dataType = dataType;
    }

    public void setDataType(String dataType) {
        if (!NullOrEmpty.nullOrEmpty(dataType)) {
            this._dataType = dataType.equalsIgnoreCase(DATA_TYPE_STRING) ? DATA_TYPE.STRING : (dataType.equalsIgnoreCase(DATA_TYPE_INTEGER) || dataType.equalsIgnoreCase(DATA_TYPE_INT) ? DATA_TYPE.INT : (dataType.equalsIgnoreCase(DATA_TYPE_LONG) ? DATA_TYPE.LONG : (dataType.equalsIgnoreCase(DATA_TYPE_DOUBLE) ? DATA_TYPE.DOUBLE : (dataType.equalsIgnoreCase(DATA_TYPE_BOOLEAN) ? DATA_TYPE.BOOLEAN : (dataType.equalsIgnoreCase(DATA_TYPE_TIMESTAMP) ? DATA_TYPE.TIMESTAMP : (dataType.equalsIgnoreCase(DATA_TYPE_RESULTSET) ? DATA_TYPE.RESULTSET : DATA_TYPE.STRING))))));
        }
    }

    public ACCESS_METHOD_TYPE getAccessMethod() {
        return this._accessMethod;
    }

    public void setAccessMethod(ACCESS_METHOD_TYPE accessMethod) {
        this._accessMethod = accessMethod;
    }

    public void setAccessMethod(String p_accessMethod) {
        if (!NullOrEmpty.nullOrEmpty(p_accessMethod)) {
            String accessMethod;
            switch (accessMethod = p_accessMethod.trim().toUpperCase()) {
                case "IN": {
                    this._accessMethod = ACCESS_METHOD_TYPE.IN;
                    break;
                }
                case "INOUT": {
                    this._accessMethod = ACCESS_METHOD_TYPE.IN_OUT;
                    break;
                }
                case "OUT": {
                    this._accessMethod = ACCESS_METHOD_TYPE.OUT;
                    break;
                }
                default: {
                    this._accessMethod = ACCESS_METHOD_TYPE.IN;
                }
            }
        }
    }

    public SOURCE_TYPE getSourceType() {
        return this._sourceType;
    }

    public void setSourceType(SOURCE_TYPE sourceType) {
        this._sourceType = sourceType;
    }

    public void setSourceType(String p_sourceType) {
        if (!NullOrEmpty.nullOrEmpty(p_sourceType)) {
            String sourceType;
            switch (sourceType = p_sourceType.trim().toLowerCase()) {
                case "header": {
                    this._sourceType = SOURCE_TYPE.HTTP_HEADER;
                    break;
                }
                case "response": {
                    this._sourceType = SOURCE_TYPE.RESPONSE;
                    break;
                }
                case "uri": {
                    this._sourceType = SOURCE_TYPE.URI_TEMPLATE;
                    break;
                }
                default: {
                    this._sourceType = SOURCE_TYPE.HTTP_HEADER;
                }
            }
        }
    }

    public String getComments() {
        return this._comments;
    }

    public void setComments(String comments) {
        this._comments = comments;
    }

    public static enum DATA_TYPE {
        STRING("String", RestMessages.getString("DATA_TYPE_STRING")),
        INTEGER("Integer", RestMessages.getString("DATA_TYPE_INTEGER")),
        INT("Int", RestMessages.getString("DATA_TYPE_INTEGER")),
        LONG("Long", RestMessages.getString("DATA_TYPE_LONG")),
        DOUBLE("Double", RestMessages.getString("DATA_TYPE_DOUBLE")),
        BOOLEAN("Boolean", RestMessages.getString("DATA_TYPE_BOOLEAN")),
        TIMESTAMP("Timestamp", RestMessages.getString("DATA_TYPE_TIMESTAMP")),
        RESULTSET("Resultset", RestMessages.getString("DATA_TYPE_RESULTSET"));

        private String type;
        private String nlsName;

        private DATA_TYPE(String type, String nlsName) {
            this.type = type;
            this.nlsName = nlsName;
        }

        public String getType() {
            return this.type;
        }

        public String getNLS() {
            return this.nlsName;
        }
    }

    public static enum SOURCE_TYPE {
        HTTP_HEADER("header", RestMessages.getString("SOURCE_TYPE_HEADER")),
        URI_TEMPLATE("uri", RestMessages.getString("SOURCE_TYPE_URI")),
        RESPONSE("response", RestMessages.getString("SOURCE_TYPE_RESPONSE"));

        private String type;
        private String nlsName;

        private SOURCE_TYPE(String type, String nlsName) {
            this.type = type;
            this.nlsName = nlsName;
        }

        public String getType() {
            return this.type;
        }

        public String getNLS() {
            return this.nlsName;
        }
    }

    public static enum ACCESS_METHOD_TYPE {
        IN("IN", RestMessages.getString("ACCESS_METHOD_IN")),
        OUT("OUT", RestMessages.getString("ACCESS_METHOD_OUT")),
        IN_OUT("INOUT", RestMessages.getString("ACCESS_METHOD_INOUT"));

        private String type;
        private String nlsName;

        private ACCESS_METHOD_TYPE(String type, String nlsName) {
            this.type = type;
            this.nlsName = nlsName;
        }

        public String getType() {
            return this.type;
        }

        public String getNLS() {
            return this.nlsName;
        }
    }
}

