/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogHandler
extends Handler {
    File _logFile;
    private OutputStream _fout;
    private BufferedOutputStream _bout;
    protected Writer _logWriter;
    private long _lastMills = 0L;
    private static final Logger BASE_LOGGER = Logger.getLogger("oracle.dbtools");
    private static final Formatter FORMATTER = new Formatter(){

        @Override
        public String format(LogRecord record) {
            Throwable thrown;
            Object msg = this.formatMessage(record);
            if ((null == msg || ((String)msg).isEmpty() || "null".equals(msg)) && (thrown = record.getThrown()) != null) {
                msg = thrown.getMessage() + " - " + thrown.getStackTrace()[0].toString();
            }
            return msg;
        }
    };

    public LogHandler() {
        Logger root = LogManager.getLogManager().getLogger("");
        root.addHandler(this);
    }

    public void setLogFile() throws IOException {
        this._logWriter = new PrintWriter(System.out);
    }

    public void setLogFile(OutputStream outputStream) throws IOException {
        this._bout = new BufferedOutputStream(outputStream);
        this._logWriter = new OutputStreamWriter(this._bout);
    }

    public void setLogFile(String log) throws IOException {
        if (log.equalsIgnoreCase("STDERR") || log.equalsIgnoreCase("STDOUT")) {
            this._logWriter = new PrintWriter(System.out);
        } else {
            this._logFile = new File(log);
            this._fout = new FileOutputStream(this._logFile.getPath());
            this._bout = new BufferedOutputStream(this._fout);
            this._logWriter = new OutputStreamWriter(this._bout);
        }
    }

    @Override
    public void close() throws SecurityException {
        if (this._logWriter != null) {
            try {
                this._logWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger root = LogManager.getLogManager().getLogger("");
            root.removeHandler(this);
        }
    }

    @Override
    public void flush() {
        if (this._logWriter != null) {
            try {
                this._logWriter.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void publish(LogRecord rec) {
        assert (rec != null);
        if (BASE_LOGGER.isLoggable(rec.getLevel()) && this._logWriter != null) {
            try {
                this.logMsg(rec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void logMsg(Object msg) {
        if (msg instanceof LogRecord) {
            LogRecord rec = (LogRecord)msg;
            Object[] row = new Object[5];
            row[0] = "" + rec.getLevel();
            row[1] = rec.getSequenceNumber();
            row[2] = this._lastMills == 0L ? 0L : rec.getMillis() - this._lastMills;
            String src = rec.getSourceClassName();
            if (null == src || src.isEmpty()) {
                src = rec.getLoggerName();
            }
            if (src.startsWith("oracle.dbtools")) {
                row[3] = src;
                row[4] = FORMATTER.format(rec);
                this._lastMills = rec.getMillis();
                try {
                    this._logWriter.write((String)row[0] + ": " + (String)row[4] + "\n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

