/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.xml.actions.ActionFolderElement;
import oracle.dbtools.xml.actions.ActionsXmlElements;
import oracle.dbtools.xml.actions.ItemElement;
import oracle.dbtools.xml.actions.ItemsElement;
import oracle.dbtools.xml.actions.TypedElement;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public class ActionFile
implements ActionsXmlElements {
    private final List<ItemElement> items = new ArrayList<ItemElement>();
    private final Map<String, List<TypedElement>> typeMap = new TreeMap<String, List<TypedElement>>();
    private final List<ActionFolderElement> folders = new ArrayList<ActionFolderElement>();

    public static ActionFile createDescriptor(XMLDocument doc) {
        ActionFile desc = null;
        XMLNode navNode = (XMLNode)XMLHelper.getChildNode((Node)doc, "items");
        if (navNode != null) {
            desc = new ActionFile(navNode);
        }
        return desc;
    }

    private ActionFile(XMLNode node) {
        ItemsElement itemsElement = new ItemsElement(node);
        itemsElement.getItems().forEach(item -> {
            this.items.add((ItemElement)item);
            String type = item.getType();
            if (type == null || type.trim().length() == 0) {
                return;
            }
            List<TypedElement> typedElements = this.typeMap.get(type = type.trim());
            if (typedElements == null) {
                typedElements = new ArrayList<TypedElement>();
                this.typeMap.put(type, typedElements);
            }
            typedElements.add((TypedElement)item);
        });
        itemsElement.getFolders().forEach(folder -> {
            this.folders.add((ActionFolderElement)folder);
            String type = folder.getType();
            if (type == null || type.trim().length() == 0) {
                return;
            }
            List<TypedElement> typedElements = this.typeMap.get(type = type.trim());
            if (typedElements == null) {
                typedElements = new ArrayList<TypedElement>();
                this.typeMap.put(type, typedElements);
            }
            typedElements.add((TypedElement)folder);
        });
    }

    public Map<String, List<TypedElement>> getTypeMap() {
        return Collections.unmodifiableMap(this.typeMap);
    }

    public List<ItemElement> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public List<ActionFolderElement> getFolders() {
        return Collections.unmodifiableList(this.folders);
    }
}

