/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.connections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.xml.connections.AttributeElement;
import oracle.dbtools.xml.connections.ConnectionXmlElements;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public class ConnectionElement
implements ConnectionXmlElements {
    private final String id;
    private final String label;
    private final List<AttributeElement> attributes = new ArrayList<AttributeElement>();
    private final Map<String, AttributeElement> idAttributeMap = new LinkedHashMap<String, AttributeElement>();

    public ConnectionElement(XMLNode node) {
        this.id = XMLHelper.getAttributeNode((Node)node, "id");
        this.label = XMLHelper.getNodeValue((Node)node, "label");
        XMLNode[] attributesElements = XMLHelper.getChildNodes((Node)node, "attribute");
        if (attributesElements != null) {
            for (XMLNode attributeElement : attributesElements) {
                this.attributes.add(new AttributeElement(attributeElement));
            }
            this.attributes.forEach(attr -> {
                String id = attr.getId();
                if (id == null || id.trim().length() == 0) {
                    return;
                }
                id = id.trim();
                this.idAttributeMap.put(id, (AttributeElement)attr);
            });
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public List<AttributeElement> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public Map<String, AttributeElement> getIdAttributeMap() {
        return Collections.unmodifiableMap(this.idAttributeMap);
    }
}

