/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.performance;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import oracle.ide.performance.PerformanceLogRecord;

final class PerformanceFormatter
extends Formatter {
    private static final int TIME_DIGITS = 7;

    PerformanceFormatter() {
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer result = new StringBuffer();
        result.append("Timing:");
        if (record instanceof PerformanceLogRecord) {
            PerformanceLogRecord plr = (PerformanceLogRecord)record;
            String elapsedString = String.valueOf(plr.getElapsedTime() / 1000000L);
            int spaces = 7 - elapsedString.length();
            for (int i = 0; i < spaces; ++i) {
                result.append(' ');
            }
            result.append('[');
            result.append(elapsedString);
            result.append("ms] ");
            int depth = plr.getDepth();
            int indentSpaces = depth * 2;
            for (int i = 0; i < indentSpaces; ++i) {
                result.append(' ');
            }
            if (!"no-id".equals(plr.getId())) {
                result.append(plr.getId());
                if (plr.getMessage() != null && plr.getMessage().length() > 0) {
                    result.append(": ");
                }
            }
            result.append(plr.getMessage());
            result.append('\n');
        } else {
            result.append(record.getMessage());
            result.append('\n');
        }
        return result.toString();
    }
}

