/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MultiMap<K, V> {
    private final HashMap<K, ArrayList<V>> _map;

    public MultiMap() {
        this._map = new HashMap();
    }

    public MultiMap(MultiMap<K, V> other) {
        this._map = new HashMap(other._map.size());
        Set<Map.Entry<K, ArrayList<V>>> entries = other._map.entrySet();
        for (Map.Entry<K, ArrayList<V>> entry : entries) {
            this.addAll(entry.getKey(), (Collection)entry.getValue());
        }
    }

    public MultiMap(int size) {
        this._map = new HashMap(size);
    }

    public void add(K key, V value) {
        ArrayList<Object> arrayList = this._map.get(key);
        if (arrayList == null) {
            arrayList = new ArrayList(2);
            this._map.put(key, arrayList);
        }
        arrayList.add(value);
    }

    public void addAll(K key, Collection<? extends V> values) {
        ArrayList<Object> arrayList = this._map.get(key);
        if (arrayList == null) {
            arrayList = new ArrayList(2);
            this._map.put(key, arrayList);
        }
        arrayList.addAll(values);
    }

    public List<V> get(K key) {
        return this._map.get(key);
    }

    public List<V> getOrCreate(K key) {
        List<V> list = this.get(key);
        if (list == null) {
            ArrayList<V> arrayList = new ArrayList<V>(2);
            this._map.put(key, arrayList);
            list = arrayList;
        }
        return list;
    }

    public List<V> remove(K key) {
        return this._map.remove(key);
    }

    public boolean remove(K key, V value) {
        List<V> list = this.get(key);
        return list.remove(value);
    }

    public Set<K> keySet() {
        return this._map.keySet();
    }
}

