/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickHasType;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.internal.compiler.ClassObj;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassBodySym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.InterfacesSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectBinding;
import oracle.javatools.parser.java.v2.internal.symbol.SuperClauseSym;
import oracle.javatools.parser.java.v2.internal.symbol.SuperclassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.util.Conversions;
import oracle.javatools.parser.java.v2.util.SourceVisitor;

public final class ClassSym
extends MemberSym
implements SourceClass {
    private int anonymousClassIndex;
    private int localClassIndex;
    public TypeSym tySuper;
    private JavaType qualifyingType;

    @Override
    public void clearCompiledInfo() {
    }

    @Override
    public int getTypeKind() {
        return ClassSym.access2ty(this.symAccess);
    }

    @Override
    public void setTypeKind(int tyk) {
        char access = this.symAccess;
        access = (char)(access & 0xFFFF9DFF);
        access = (char)(access | ClassSym.ty2access((byte)tyk));
        this.setAccess(access);
    }

    @Override
    public boolean isClass() {
        return !this.isInterface();
    }

    @Override
    public boolean isInterface() {
        return (this.symAccess & 0x200) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.symAccess & 0x4000) != 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.symAccess & 0x2000) != 0;
    }

    @Override
    public boolean isExported() {
        Sym parentSym = this.getParentSym();
        if (parentSym != null) {
            switch (parentSym.symKind) {
                case 4: 
                case 11: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isMemberClass() {
        Sym parentSym = this.getParentSym();
        if (parentSym != null) {
            return parentSym.symKind == 4;
        }
        return false;
    }

    public final boolean flag_anonymous() {
        return this.testSymFlag((byte)-128);
    }

    @Override
    public boolean isAnonymous() {
        return this.flag_anonymous();
    }

    @Override
    public boolean isAnonymousClass() {
        return this.flag_anonymous();
    }

    @Override
    public boolean isLocalClass() {
        if (this.isAnonymous()) {
            return false;
        }
        JavaElement element = this.getOwner();
        return element != null && element.getElementKind() == 8;
    }

    @Override
    public String getUnqualifiedName() {
        return this.getName();
    }

    @Override
    public String getQualifiedName() {
        return this.getRawOrQualifiedName(false);
    }

    private String getRawOrQualifiedName(boolean isRaw) {
        String packageName;
        if (this.isAnonymousClass()) {
            return "";
        }
        if (this.isLocalClass()) {
            return this.getName();
        }
        String thisName = this.getName();
        ClassSym owningClass = this.getOwningClassSym();
        if (owningClass != null) {
            String ownerName;
            String string = ownerName = isRaw ? owningClass.getRawName() : owningClass.getQualifiedName();
            if (ownerName.length() > 0) {
                return ownerName + '.' + thisName;
            }
        }
        if ((packageName = this.getPackageName()).length() == 0) {
            return thisName;
        }
        return packageName + '.' + thisName;
    }

    @Override
    public String getVMName() {
        String ownerVMName;
        int length;
        String thisName;
        ClassSym classSym;
        if (this.isAnonymousClass()) {
            if (this.anonymousClassIndex == 0 && (classSym = this.getOwningClassSym()) != null) {
                classSym.assignAnonymousClassIndices();
            }
            thisName = "" + this.anonymousClassIndex;
        } else if (this.isLocalClass()) {
            if (this.localClassIndex == 0 && (classSym = this.getOwningClassSym()) != null) {
                classSym.assignLocalClassIndices();
            }
            thisName = "" + this.localClassIndex + this.getName();
        } else {
            thisName = this.getName();
        }
        ClassSym owningClass = this.getOwningClassSym();
        if (owningClass != null && (length = (ownerVMName = owningClass.getVMName()).length()) > 0) {
            return ownerVMName + '$' + thisName;
        }
        String packageName = this.getPackageName();
        if (packageName.length() == 0) {
            return thisName;
        }
        return packageName.replace('.', '/') + '/' + thisName;
    }

    private void assignAnonymousClassIndices() {
        ClassBodySym bodySym = this.getBodySym();
        if (bodySym != null) {
            SourceVisitor visitor = new SourceVisitor(){
                private int anonymousClassCount;

                @Override
                public void whenEnterClass(SourceClass sourceClass) {
                    if (sourceClass.isAnonymousClass()) {
                        ((ClassSym)sourceClass).anonymousClassIndex = ++this.anonymousClassCount;
                    }
                    this.cancelSubtree();
                }
            };
            visitor.visit(bodySym);
        }
    }

    private void assignLocalClassIndices() {
        ClassBodySym bodySym = this.getBodySym();
        if (bodySym != null) {
            SourceVisitor visitor = new SourceVisitor(){
                private Map<String, Integer> localClassNames = new HashMap<String, Integer>();

                @Override
                public void whenEnterClass(SourceClass sourceClass) {
                    if (sourceClass.isLocalClass()) {
                        String sourceClassName = sourceClass.getName();
                        Integer copies = this.localClassNames.get(sourceClassName);
                        int localClassIndex = copies == null ? 1 : copies + 1;
                        this.localClassNames.put(sourceClassName, localClassIndex);
                        ((ClassSym)sourceClass).localClassIndex = localClassIndex;
                    }
                    this.cancelSubtree();
                }
            };
            visitor.visit(bodySym);
        }
    }

    @Override
    public String getRawName() {
        return this.getRawOrQualifiedName(true);
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getTypeSignature() {
        return CommonUtilities.getTypeSignature(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public SourceClass getSourceElement() {
        if (this.symFile.isLightSourceFile) {
            JavaProvider provider = this.symFile.getProvider();
            if (provider != null) {
                return provider.getSourceClass(this.getRawName());
            }
            return null;
        }
        return this;
    }

    @Override
    public SourcePackage getSourcePackage() {
        return this.symFile.getSourcePackage();
    }

    @Override
    public String getPackageName() {
        return this.symFile.getPackageName();
    }

    @Override
    public SourceTypeReference getSourceSuperclass() {
        SuperclassSym superSym = this.getSuperclassSym();
        if (superSym != null) {
            return superSym.getSourceSuperclass();
        }
        return null;
    }

    @Override
    public void setSourceSuperclass(SourceTypeReference type) {
        this.getSuperclassSym().setSourceSuperclass(type);
    }

    @Override
    public List<SourceTypeReference> getSourceInterfaces() {
        return this.getInterfacesSym().getSourceInterfaces();
    }

    @Override
    public List<SourceMember> getSourceMembers() {
        return this.getBodySym().getSourceMembers();
    }

    @Override
    public Collection<SourceMemberVariable> getSourceMemberVariables() {
        return this.getBodySym().getSourceMemberVariables();
    }

    @Override
    public SourceMemberVariable getSourceMemberVariable(String name) {
        return this.getBodySym().getSourceMemberVariable(name);
    }

    @Override
    public List<SourceEnumConstant> getSourceEnumConstants() {
        return this.getBodySym().getSourceEnumConstants();
    }

    @Override
    public List<SourceFieldDeclaration> getSourceFieldDeclarations() {
        return this.getBodySym().getSourceFieldDeclarations();
    }

    @Override
    public Collection<SourceFieldVariable> getSourceFieldVariables() {
        return this.getBodySym().getSourceFieldVariables();
    }

    @Override
    public SourceFieldVariable getSourceFieldVariable(String name) {
        return this.getBodySym().getSourceFieldVariable(name);
    }

    @Override
    public List<SourceMethod> getSourceMethods() {
        return this.getBodySym().getSourceMethods();
    }

    @Override
    public Collection<SourceMethod> getSourceMethods(String name) {
        return this.getBodySym().getSourceMethods(name);
    }

    @Override
    public SourceMethod getSourceMethod(String name, JavaType[] targetTypes) {
        JavaMethod target = this.getDeclaredMethod(name, targetTypes);
        if (target != null) {
            return target.getSourceElement();
        }
        return null;
    }

    @Override
    public List<SourceMethod> getSourceConstructors() {
        return this.getBodySym().getSourceConstructors();
    }

    @Override
    public SourceMethod getSourceConstructor(JavaType[] targetTypes) {
        JavaMethod target = this.getDeclaredConstructor(targetTypes);
        if (target != null) {
            return target.getSourceElement();
        }
        return null;
    }

    @Override
    public List<SourceClass> getSourceClasses() {
        return this.getBodySym().getSourceClasses();
    }

    @Override
    public SourceClass getSourceClass(String name) {
        return this.getBodySym().getSourceClass(name);
    }

    @Override
    public List<SourceClass> getSourceAnonymousClasses() {
        return this.getBodySym().getSourceAnonymousClasses();
    }

    @Override
    public List<SourceClass> getSourceLocalClasses() {
        return this.getBodySym().getSourceLocalClasses();
    }

    @Override
    public List<SourceClassInitializer> getSourceInitializers() {
        return this.getBodySym().getSourceInitializers();
    }

    @Override
    public SourceClassBody getSourceBody() {
        return this.getBodySym();
    }

    public SourceClassBody getBody() {
        return this.getSourceBody();
    }

    public ClassBodySym getBodySym() {
        return (ClassBodySym)this.getChild((byte)4);
    }

    @Override
    public SourceSuperclassClause getSuperclassClause() {
        return this.getSuperclassSym();
    }

    @Override
    public SourceInterfacesClause getInterfacesClause() {
        return this.getInterfacesSym();
    }

    public SuperclassSym getSuperclassSym() {
        return (SuperclassSym)this.getChildOrCreateSkeleton((byte)22);
    }

    public boolean hasSuperClass() {
        return this.getChild((byte)22) != null;
    }

    public InterfacesSym getInterfacesSym() {
        return (InterfacesSym)this.getChildOrCreateSkeleton((byte)15);
    }

    public boolean hasInterfaces() {
        InterfacesSym child = (InterfacesSym)this.getChild((byte)15);
        if (child == null) {
            return false;
        }
        return child.getSourceInterfaces().size() > 0;
    }

    public SuperClauseSym getSuperSym() {
        String message = "Deprecated. Get the superclass or the interfaces clause instead!";
        throw new UnsupportedOperationException("Deprecated. Get the superclass or the interfaces clause instead!");
    }

    @Override
    public int getElementKind() {
        return 3;
    }

    @Override
    public URL getURL() {
        return this.symFile.getURL();
    }

    @Override
    public String getName() {
        if (this.isAnonymousClass()) {
            return "";
        }
        return super.getName();
    }

    @Override
    @Deprecated
    public final JavaClass getClosestClass() {
        return this.getTypeErasure();
    }

    @Override
    public final JavaClass getTypeErasure() {
        return this;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public JavaType getComponentType() {
        return null;
    }

    @Override
    public int getArrayDimensions() {
        return 0;
    }

    @Override
    public JavaType getBaseComponentType() {
        return null;
    }

    @Override
    public SourceMember getOwningMember() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym.isFilter((byte)98)) {
                return (SourceMember)((Object)sym);
            }
            sym = sym.symParent;
        }
        return null;
    }

    @Override
    public JavaPackage getPackage() {
        return this.symFile.getPackage();
    }

    @Override
    public JavaType getResolvedType() {
        return this;
    }

    @Override
    public UnresolvedType getUnresolvedType() {
        return QuickUnresolvedType.createUnresolvedType(this);
    }

    @Override
    public JavaType getSuperclass() {
        ClassObj obj = this.getClassObj();
        if (!obj.isResolved()) {
            this.resolve();
        }
        return obj.getSuperclass();
    }

    @Override
    public UnresolvedType getUnresolvedSuperclass() {
        SourceTypeReference ref = this.getSourceSuperclass();
        if (ref != null) {
            return ref.getUnresolvedType();
        }
        if (this.isInterface() && !this.isAnnotation()) {
            return null;
        }
        if ("java.lang.Object".equals(this.getRawName())) {
            return null;
        }
        return QuickUnresolvedType.createUnresolvedType("java.lang.Object");
    }

    @Override
    public Collection<JavaType> getInterfaces() {
        JavaType resolved;
        if (this.tySuper != null && (resolved = this.tySuper.getResolvedType()) != null && resolved.getElementKind() == 3 && resolved.isInterface()) {
            return Arrays.asList(resolved);
        }
        if (this.isAnnotation()) {
            JavaType annotationType = QuickHasType.createHasTypeByVMName(this.symFile, "java/lang/annotation/Annotation").getResolvedType();
            ArrayList<JavaType> list = new ArrayList<JavaType>();
            if (annotationType != null) {
                list.add(annotationType);
            }
            return list;
        }
        InterfacesSym interfacesSym = this.getInterfacesSym();
        return interfacesSym.getInterfaces();
    }

    @Override
    public Set<JavaType> getHierarchy() {
        return this.getClassObj().getHierarchy();
    }

    @Override
    public boolean isAssignableFrom(JavaType subject) {
        return Conversions.applyAssignmentConversion(subject, this, false, null);
    }

    @Override
    public boolean isSubtypeOf(JavaType supertype) {
        return Conversions.isSubtypeOf(this, supertype);
    }

    @Override
    public Collection<JavaField> getDeclaredFields() {
        ObjectBinding declaredFieldsBinding = (ObjectBinding)this.getInternalBinding(20);
        if (declaredFieldsBinding != null) {
            return ((Map)declaredFieldsBinding.getObject()).values();
        }
        return this.cacheDeclaredFields().values();
    }

    @Override
    public JavaField getDeclaredField(String name) {
        ObjectBinding declaredFieldsBinding = (ObjectBinding)this.getInternalBinding(20);
        if (declaredFieldsBinding != null) {
            return (JavaField)((Map)declaredFieldsBinding.getObject()).get(name);
        }
        return this.cacheDeclaredFields().get(name);
    }

    private Map<String, JavaField> cacheDeclaredFields() {
        Collection<SourceMemberVariable> fields = this.getBodySym().getSourceMemberVariables();
        LinkedHashMap<String, JavaField> fieldsByName = new LinkedHashMap<String, JavaField>(fields.size());
        for (JavaField javaField : fields) {
            fieldsByName.put(javaField.getName(), javaField);
        }
        this.setInternalBinding(new ObjectBinding(20, fieldsByName));
        return fieldsByName;
    }

    @Override
    public Collection<JavaMethod> getDeclaredMethods() {
        ObjectBinding declaredMethodBinding = (ObjectBinding)this.getInternalBinding(18);
        if (declaredMethodBinding != null) {
            return (Collection)declaredMethodBinding.getObject();
        }
        Collection<JavaMethod> declaredMethods = this.getBodySym().getDeclaredMethods();
        this.setInternalBinding(new ObjectBinding<Collection<JavaMethod>>(18, declaredMethods));
        return declaredMethods;
    }

    @Override
    public Collection<JavaMethod> getDeclaredMethods(String name) {
        ObjectBinding binding = (ObjectBinding)this.getInternalBinding(19);
        if (binding != null) {
            List<JavaMethod> methods = (List<JavaMethod>)((Map)binding.getObject()).get(name);
            return methods != null ? methods : Collections.emptyList();
        }
        Collection<JavaMethod> declaredMethods = this.getDeclaredMethods();
        HashMap<String, ArrayList<JavaMethod>> methodsByName = new HashMap<String, ArrayList<JavaMethod>>(declaredMethods.size());
        for (JavaMethod javaMethod : declaredMethods) {
            String methodName = javaMethod.getName();
            ArrayList<JavaMethod> methodList = (ArrayList<JavaMethod>)methodsByName.get(methodName);
            if (methodList == null) {
                methodList = new ArrayList<JavaMethod>();
                methodsByName.put(methodName, methodList);
            }
            methodList.add(javaMethod);
        }
        binding = new ObjectBinding(19, methodsByName);
        this.setInternalBinding(binding);
        List<JavaMethod> methods = (List<JavaMethod>)methodsByName.get(name);
        return methods != null ? methods : Collections.emptyList();
    }

    @Override
    public JavaMethod getDeclaredMethod(String name, JavaType[] targetTypes) {
        return CommonUtilities.getDeclaredMethod(this, name, targetTypes);
    }

    @Override
    public Collection<JavaMethod> getDeclaredConstructors() {
        return this.getBodySym().getDeclaredConstructors();
    }

    @Override
    public JavaMethod getDeclaredConstructor(JavaType[] targetTypes) {
        return CommonUtilities.getDeclaredConstructor(this, targetTypes);
    }

    @Override
    public JavaMethod getClinitMethod() {
        ClassObj obj = this.getClassObj();
        if (!obj.isResolved()) {
            this.resolve();
        }
        return obj.getClinitMethod();
    }

    @Override
    public JavaClass getDeclaredClass(String name) {
        ObjectBinding declaredClassesBinding = (ObjectBinding)this.getInternalBinding(21);
        if (declaredClassesBinding != null) {
            return (JavaClass)((Map)declaredClassesBinding.getObject()).get(name);
        }
        return this.cacheDeclaredClasses().get(name);
    }

    @Override
    public Collection<JavaClass> getDeclaredClasses() {
        ObjectBinding declaredClassesBinding = (ObjectBinding)this.getInternalBinding(21);
        if (declaredClassesBinding != null) {
            return ((Map)declaredClassesBinding.getObject()).values();
        }
        return this.cacheDeclaredClasses().values();
    }

    private Map<String, JavaClass> cacheDeclaredClasses() {
        Collection classes = this.getBodySym().getDeclaredClasses();
        LinkedHashMap<String, JavaClass> classesByName = new LinkedHashMap<String, JavaClass>(classes.size());
        for (JavaClass javaClass : classes) {
            classesByName.put(javaClass.getName(), javaClass);
        }
        this.setInternalBinding(new ObjectBinding(21, classesByName));
        return classesByName;
    }

    @Override
    public Collection<JavaClass> getDeclaredAnonymousClasses() {
        return this.getBodySym().getDeclaredAnonymousClasses();
    }

    @Override
    public Collection<JavaClass> getDeclaredLocalClasses() {
        return this.getBodySym().getDeclaredLocalClasses();
    }

    @Override
    public final JavaTypeVariable getTypeParameter(String name) {
        return CommonUtilities.getTypeParameter(this, name);
    }

    @Override
    public Collection<JavaField> getFields() {
        return CommonUtilities.getFields(this);
    }

    @Override
    public JavaField getField(String name) {
        return CommonUtilities.getField(this, name);
    }

    @Override
    public Collection<JavaMethod> getMethods() {
        return CommonUtilities.getMethods(this);
    }

    @Override
    public Collection<JavaMethod> getMethods(String name) {
        return CommonUtilities.getMethods(this, name);
    }

    @Override
    public JavaMethod getMethod(String name, JavaType[] targetTypes) {
        return CommonUtilities.getMethod(this, name, targetTypes);
    }

    @Override
    public Collection<JavaClass> getClasses() {
        return CommonUtilities.getClasses(this);
    }

    @Override
    public JavaClass getClass(String name) {
        return CommonUtilities.getClass(this, name);
    }

    @Override
    public final Collection<JavaAnnotation> getAnnotations() {
        return CommonUtilities.getAnnotations(this);
    }

    @Override
    public final JavaAnnotation getAnnotation(JavaType annotationType) {
        return CommonUtilities.getAnnotation(this, annotationType);
    }

    @Override
    public CompiledTmpVariable getThisValue() {
        return this.getClassObj().getThisValue();
    }

    public JavaVariable getThisVariable() {
        return this.getClassObj().getThisVariable();
    }

    public JavaVariable getSuperVariable() {
        return this.getClassObj().getSuperVariable();
    }

    public boolean equals(Object o) {
        if (o instanceof JavaType) {
            return CommonUtilities.equals(this, (JavaType)o);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    @Override
    public String printCompiledInfo() {
        return super.printCompiledInfo() + this.getDescriptor();
    }

    @Override
    protected void add(Sym child, byte filter) {
        ClassBodySym body;
        if (!this.isValidChild(child, filter) && (body = this.getBodySym()).isValidChild(child, filter)) {
            body.add(child, filter);
            return;
        }
        super.add(child, filter);
    }

    @Override
    protected Sym createSkeleton(byte symKind) {
        Sym sym = super.createSkeleton(symKind);
        if (symKind == 4) {
            sym.symFlags = (byte)(sym.symFlags & 0xFFFFFFFB);
        }
        return sym;
    }

    @Override
    protected void setupSkeleton() {
        Sym bodySym = this.getChildOrCreateSkeleton((byte)4);
        bodySym.buildSelf();
        this.getSuperclassClause();
        this.getInterfacesClause();
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 20: {
                int typeParameterIndex = this.indexOf((byte)26);
                if (typeParameterIndex != -1) {
                    return typeParameterIndex;
                }
            }
            case 26: {
                int superIndex = this.indexOf((byte)22);
                if (superIndex != -1) {
                    return superIndex;
                }
            }
            case 22: {
                int interfacesIndex = this.indexOf((byte)15);
                if (interfacesIndex != -1) {
                    return interfacesIndex;
                }
            }
            case 15: {
                int bodyIndex = this.indexOf((byte)4);
                if (bodyIndex == -1) break;
                return bodyIndex;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 4: 
            case 15: 
            case 20: 
            case 22: 
            case 26: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected boolean isValidAccess(char access) {
        if (this.isAnonymousClass()) {
            return access == '\u0000';
        }
        int allowed = 10241;
        allowed = (access & 0x200) != 0 ? (int)((char)(allowed | 0x608)) : ((access & 0x4000) != 0 ? (int)((char)(allowed | 0x4018)) : (int)((char)(allowed | 0x418)));
        ClassSym owningSym = this.getOwningClassSym();
        if (owningSym != null) {
            if (!owningSym.isInterface()) {
                allowed = (char)(allowed | 6);
            }
            if (owningSym.getOwningClassSym() != null && !owningSym.isStatic()) {
                allowed = (char)(allowed & 0xFFFFFFF7);
            }
        } else {
            allowed = (char)(allowed & 0xFFFFFFF7);
        }
        return super.isValidAccess((char)(access & ~allowed));
    }

    @Override
    protected void setAccess(char access) {
        char oldAccess = this.symAccess;
        if (access == oldAccess) {
            return;
        }
        byte savedTyk = ClassSym.access2ty(oldAccess);
        byte newTyk = ClassSym.access2ty(access);
        this.setAccessImpl(access);
        if (savedTyk != newTyk) {
            switch (newTyk) {
                case 0: {
                    this.objectImplicit = '\u0000';
                    break;
                }
                case 3: {
                    this.objectImplicit = (char)9728;
                    break;
                }
                case 2: {
                    this.objectImplicit = (char)16384;
                    break;
                }
                case 1: {
                    this.objectImplicit = (char)1536;
                }
            }
        }
        this.setAccessTrigger(oldAccess);
    }

    @Override
    protected void setModifiersImpl(char modifiers) {
        char access = modifiers;
        access = (char)(access & 0xFFFF9DFF);
        char typeKind = (char)(this.symAccess & 0x6200);
        access = (char)(access | typeKind);
        super.setModifiersImpl(access);
    }

    @Override
    protected void setNameTrigger(String newValue) {
        super.setNameTrigger(newValue);
        for (SourceMethod method : this.getSourceConstructors()) {
            if (!method.isConstructor()) continue;
            method.setName(newValue);
        }
    }

    @Override
    protected void linkChildTrigger(Sym added, byte filter) {
        super.linkChildTrigger(added, filter);
        if (added.symKind == 4) {
            this.buildSelf();
        }
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        ClassSym sym = (ClassSym)super.cloneSelf(targetFile);
        if (this.tySuper != null) {
            sym.tySuper = (TypeSym)this.tySuper.cloneSelf(targetFile);
        }
        return sym;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        if (!compiler.skipCompilations()) {
            compiler.startClassFlowAnalysis(this);
        }
        try {
            this.resolveImpl(compiler);
            for (Sym sym : this.getSourceClasses()) {
                sym.resolve(compiler);
            }
            JavaElement javaElement = super.compileImpl(compiler);
            if (!compiler.skipCompilations()) {
                this.checkAccessModifiers(compiler);
                this.checkAnnotations(compiler);
                compiler.compile(this);
            }
            JavaElement javaElement2 = javaElement;
            return javaElement2;
        }
        finally {
            if (!compiler.skipCompilations()) {
                compiler.endClassFlowAnalysis(this);
            }
        }
    }

    @Override
    public JavaElement resolveImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    public ClassObj getClassObj() {
        ClassObj binding = (ClassObj)this.getInternalBinding(5);
        if (binding != null) {
            return binding;
        }
        binding = new ClassObj();
        binding.objSym = this;
        this.setInternalBinding(binding);
        return binding;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int argument) {
        switch (argument) {
            default: {
                this.print(out);
                return;
            }
            case 2: {
                this.print_annotations(out);
                this.print_modifiers(out);
                out.print(TY_words[ClassSym.access2ty(this.symAccess)]);
                out.print(' ');
            }
            case 1: 
            case 3: 
        }
        ClassSym.print(this.getNameSym(), out);
        switch (argument) {
            case 1: {
                this.print_ty_parameters(out, 1);
                break;
            }
            case 2: 
            case 3: {
                this.print_ty_parameters(out);
            }
        }
    }

    @Override
    public Collection<UnresolvedType> getUnresolvedInterfaces() {
        ArrayList list = new ArrayList();
        List<SourceTypeReference> sourceInterfaces = this.getSourceInterfaces();
        for (SourceTypeReference ref : sourceInterfaces) {
            list.add(ref.getUnresolvedType());
        }
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    @Override
    public Collection<JavaAnnotation> getTypeAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public boolean isErasedType() {
        return false;
    }

    @Override
    public JavaProvider getProvider() {
        SourceFile file = this.getOwningSourceFile();
        if (file != null) {
            return file.getProvider();
        }
        return null;
    }

    @Override
    public JavaType getQualifyingType() {
        if (this.qualifyingType != null) {
            return this.qualifyingType;
        }
        return this.getOwningClass();
    }

    @Override
    public void setQualifyingType(JavaType qualifyingType) {
        this.qualifyingType = qualifyingType;
    }

    @Override
    public JavaClass getCompiledObject() {
        return this;
    }

    @Override
    public JavaType getAnonymousClassSuperType() {
        return this.isAnonymousClass() ? (this.tySuper != null ? this.tySuper.getResolvedType() : null) : null;
    }

    @Override
    public JavaType getNonParameterizedType() {
        return this;
    }
}

