/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.List;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.GuardedTextBuffer;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetRegion;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareUtils;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.internal.format.DamageCalculation;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymTransaction;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.util.DocCommentHelper;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.internal.util.ImportHelper;
import oracle.javatools.parser.java.v2.internal.util.TokenMap;
import oracle.javatools.parser.java.v2.scanner.TokenArray;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;

public final class SymSavepoint
extends TreeSym
implements SourceSavepoint {
    protected UndoableEdit undoableEdit;
    protected SymTransaction.TextEdit lastIncludedEdit;

    protected SymSavepoint(SymTransaction parent) {
        this.symKind = (byte)96;
        this.symParent = parent;
        this.symFile = parent.symFile;
    }

    public void undoSelf() {
        int count = this.treeChildren.length;
        for (int i = count - 1; i >= 0; --i) {
            SymOperation op = (SymOperation)this.treeChildren[i];
            op.undoSelf();
        }
        if (this.undoableEdit != null) {
            this.undoableEdit.undo();
        }
        this.symFile.adjustOffsets();
    }

    @Override
    public void buildSelf() {
        SyntaxData data = this.symData;
        super.buildSelf();
        data.kidCount = 0;
    }

    public void preprocessSelf() {
        ImportHelper importHelper = new ImportHelper(this.symFile);
        importHelper.process();
        DocCommentHelper docCommentHelper = new DocCommentHelper(this.symFile);
        docCommentHelper.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSelf() {
        if (this.treeChildren.length == 0) {
            SymSavepoint.panic();
        }
        int count = this.treeChildren.length;
        SymOperation[] ops = new SymOperation[count];
        System.arraycopy(this.treeChildren, 0, ops, 0, count);
        DamageCalculation.preprocess(ops);
        Emitter emitter = Emitter.createSavedTextEmitter();
        FileSym formattedFile = SymSavepoint.getFormattedFile(this.symFile, emitter);
        this.symFile.mapSelf(formattedFile);
        TokenMap tokenMap = new TokenMap(this.symFile, formattedFile);
        TextBuffer textBuffer = this.symFile.getTextBuffer();
        textBuffer.beginEdit();
        try {
            FormatRegion[] regions = DamageCalculation.process(ops, tokenMap);
            int regionCount = regions.length;
            for (int i = regionCount - 1; i >= 0; --i) {
                FormatRegion region = regions[i];
                this.performRegionReplace(tokenMap, region, this.symFile, formattedFile);
            }
        }
        finally {
            this.undoableEdit = textBuffer.endEdit();
        }
        this.symFile.adjustOffsets();
        this.symFile.clearFormatInfo();
    }

    private static FileSym getFormattedFile(FileSym fileSym, Emitter emitter) {
        FormatDriver formatter = new FormatDriver(fileSym, emitter);
        formatter.init(fileSym);
        try {
            fileSym.print(formatter);
        }
        finally {
            formatter.fini(fileSym);
        }
        TextBuffer formattedBuffer = emitter.getOutputBuffer();
        FileSym formattedFile = (FileSym)JavaParser.parse((ReadTextBuffer)formattedBuffer, fileSym.getJdkVersion());
        formattedFile.setTextBuffer(formattedBuffer);
        return formattedFile;
    }

    private void performRegionReplace(TokenMap tokenMap, FormatRegion region, FileSym fileSym, FileSym formattedFile) {
        boolean isGuardedTextBuffer;
        int targetLength;
        int targetEndOffset;
        int dirtyEndOffset;
        int targetStartOffset;
        int dirtyStartOffset;
        int dirtyStartIndex = region.fromIndices.getStartOffset();
        int targetStartIndex = region.toIndices.getStartOffset();
        TokenArray tokenArray = fileSym.getTokenArray();
        TokenArray formattedTokenArray = formattedFile.getTokenArray();
        if (dirtyStartIndex == 0 && targetStartIndex == 0) {
            dirtyStartOffset = 0;
            targetStartOffset = 0;
        } else {
            dirtyStartOffset = tokenArray.tokenStarts[dirtyStartIndex];
            targetStartOffset = formattedTokenArray.tokenStarts[targetStartIndex];
        }
        TextBuffer formattedBuffer = formattedFile.getTextBuffer();
        TextBuffer textBuffer = fileSym.getTextBuffer();
        int dirtyEndIndex = region.fromIndices.getEndOffset();
        int targetEndIndex = region.toIndices.getEndOffset();
        if (dirtyEndIndex >= tokenArray.tokenCount - 2 && targetEndIndex >= formattedTokenArray.tokenCount - 2) {
            dirtyEndOffset = textBuffer.getLength();
            targetEndOffset = formattedBuffer.getLength();
        } else {
            dirtyEndOffset = tokenArray.tokenEnds[dirtyEndIndex];
            targetEndOffset = formattedTokenArray.tokenEnds[targetEndIndex];
        }
        int dirtyLength = dirtyEndOffset - dirtyStartOffset;
        if (dirtyLength < 0) {
            SymSavepoint.panic();
        }
        if ((targetLength = targetEndOffset - targetStartOffset) < 0) {
            SymSavepoint.panic();
        }
        boolean bl = isGuardedTextBuffer = textBuffer instanceof GuardedTextBuffer && ((GuardedTextBuffer)textBuffer).isGuardActive() && !((GuardedTextBuffer)textBuffer).getRegions().isEmpty();
        if (isGuardedTextBuffer) {
            GuardedTextBuffer guardedBuffer = (GuardedTextBuffer)textBuffer;
            List<OffsetRegion> guardedRegions = guardedBuffer.getRegions();
            assert (!guardedRegions.isEmpty());
            int tokenArrayDiff = 0;
            int previousGuardedEndOffset = -1;
            for (int x = 0; x < guardedRegions.size(); ++x) {
                int formattedEndIndex;
                int formattedEndOffset;
                int nextGuardedStartOffset;
                char[] targetText;
                char c;
                int dirtyPointer;
                int targetPointer;
                int formattedStartIndex;
                OffsetRegion guardedRegion = guardedRegions.get(x);
                int guardedStartOffset = guardedRegion.getStartOffset();
                int guardedEndOffset = guardedRegion.getEndOffset();
                if (guardedStartOffset >= dirtyEndOffset || guardedEndOffset < dirtyStartOffset) {
                    previousGuardedEndOffset = guardedEndOffset;
                    continue;
                }
                int guardedStartIndex = tokenArray.findTokenIndexAtOffset(guardedStartOffset - tokenArrayDiff);
                if (guardedStartIndex < 0) {
                    guardedStartIndex = -(guardedStartIndex + 1);
                }
                if ((formattedStartIndex = tokenMap.mapForward(guardedStartIndex)) >= 0) {
                    char c2;
                    for (targetPointer = formattedTokenArray.tokenStarts[formattedStartIndex]; targetPointer > targetStartOffset && Character.isWhitespace(c2 = formattedBuffer.getChar(targetPointer - 1)); --targetPointer) {
                    }
                } else {
                    while (guardedStartIndex > 0 && formattedStartIndex < 0) {
                        formattedStartIndex = tokenMap.mapForward(--guardedStartIndex);
                    }
                    if (formattedStartIndex < 0) {
                        formattedStartIndex = 0;
                    }
                    targetPointer = formattedTokenArray.tokenEnds[formattedStartIndex];
                }
                for (dirtyPointer = guardedStartOffset; dirtyPointer > 0 && dirtyPointer > previousGuardedEndOffset + 1 && Character.isWhitespace(c = guardedBuffer.getChar(dirtyPointer - 1)); --dirtyPointer) {
                }
                if (dirtyPointer < dirtyStartOffset) {
                    dirtyStartOffset = dirtyPointer;
                }
                char[] cArray = targetText = targetPointer > targetStartOffset ? formattedBuffer.getChars(targetStartOffset, targetPointer - targetStartOffset) : new char[]{};
                if (dirtyPointer > dirtyStartOffset || targetText.length > 0 && targetText.toString().trim().length() > 0) {
                    dirtyLength = dirtyPointer - dirtyStartOffset;
                    CompareUtils.replaceText(textBuffer, dirtyStartOffset, dirtyLength, targetText);
                    guardedRegion = guardedRegions.get(x);
                    int localDiff = guardedRegion.getEndOffset() - guardedEndOffset;
                    dirtyPointer += localDiff;
                    dirtyEndOffset += localDiff;
                    tokenArrayDiff += localDiff;
                    guardedEndOffset = guardedRegion.getEndOffset();
                }
                int n = nextGuardedStartOffset = x < guardedRegions.size() - 1 ? guardedRegions.get(x + 1).getStartOffset() : Integer.MAX_VALUE;
                if (dirtyPointer < dirtyEndOffset && dirtyPointer < nextGuardedStartOffset) {
                    char c3;
                    for (dirtyPointer = guardedEndOffset + 1; dirtyPointer < dirtyEndOffset && dirtyPointer < nextGuardedStartOffset && Character.isWhitespace(c3 = guardedBuffer.getChar(dirtyPointer)); ++dirtyPointer) {
                    }
                    if (dirtyPointer >= dirtyEndOffset || dirtyPointer >= nextGuardedStartOffset) {
                        --dirtyPointer;
                    }
                }
                LineMap lineMap = guardedBuffer.getLineMap();
                int line = lineMap.getLineFromOffset(dirtyPointer);
                dirtyPointer = lineMap.getLineStartOffset(line);
                int guardedEndIndex = tokenArray.findTokenIndexAtOffset(guardedEndOffset - tokenArrayDiff);
                if (guardedEndIndex < 0) {
                    guardedEndIndex = -(guardedEndIndex + 1) - 1;
                }
                if ((targetPointer = (formattedEndOffset = formattedTokenArray.tokenEnds[formattedEndIndex = tokenMap.mapForward(guardedEndIndex)])) < targetEndOffset) {
                    char c4;
                    while (targetPointer < targetEndOffset && Character.isWhitespace(c4 = formattedBuffer.getChar(targetPointer))) {
                        ++targetPointer;
                    }
                    if (targetPointer >= targetEndOffset) {
                        --targetPointer;
                    }
                }
                lineMap = formattedBuffer.getLineMap();
                line = lineMap.getLineFromOffset(targetPointer);
                targetStartOffset = targetPointer = lineMap.getLineStartOffset(line);
                dirtyStartOffset = dirtyPointer;
                previousGuardedEndOffset = guardedEndOffset;
            }
            dirtyLength = dirtyEndOffset - dirtyStartOffset;
            if (dirtyLength <= 0) {
                return;
            }
            targetLength = targetEndOffset - targetStartOffset;
        }
        char[] targetText = formattedBuffer.getChars(targetStartOffset, targetLength);
        if (((SymTransaction)this.symParent).symBeingFormatted != null || ((SymTransaction)this.symParent).regionBeingFormatted != null) {
            this.replaceFormattedText(textBuffer, dirtyStartOffset, dirtyLength, targetText);
        } else {
            CompareUtils.replaceText(textBuffer, dirtyStartOffset, dirtyLength, targetText);
        }
    }

    private void replaceFormattedText(TextBuffer dest, int destStart, int destLength, char[] source) {
        int destPtr = destStart + destLength - 1;
        int sourcePtr = source.length - 1;
        while (destPtr >= destStart && sourcePtr >= 0) {
            int sourcePtr2;
            int destPtr2;
            char sourceChar;
            char destChar = dest.getChar(destPtr);
            if (destChar == (sourceChar = source[sourcePtr])) {
                --destPtr;
                --sourcePtr;
                continue;
            }
            for (destPtr2 = destPtr; destPtr2 >= destStart && Character.isWhitespace(dest.getChar(destPtr2)); --destPtr2) {
            }
            if (++destPtr2 <= destPtr) {
                dest.remove(destPtr2, destPtr - destPtr2 + 1);
            }
            for (sourcePtr2 = sourcePtr; sourcePtr2 >= 0 && Character.isWhitespace(source[sourcePtr2]); --sourcePtr2) {
            }
            if (++sourcePtr2 <= sourcePtr) {
                this.insertSource(dest, destPtr2, source, sourcePtr2, sourcePtr);
            }
            destPtr = destPtr2 - 1;
            sourcePtr = sourcePtr2 - 1;
            if (destPtr < 0 || sourcePtr < 0 || dest.getChar(destPtr) == source[sourcePtr]) continue;
            dest.remove(destStart, destPtr - destStart + 1);
            this.insertSource(dest, destStart, source, 0, sourcePtr);
            return;
        }
        if (destPtr >= destStart) {
            dest.remove(destStart, destPtr - destStart + 1);
        }
        if (sourcePtr >= 0) {
            this.insertSource(dest, destStart, source, 0, sourcePtr);
        }
    }

    private void insertSource(TextBuffer dest, int destPtr, char[] source, int beginInc, int endInc) {
        int len = endInc - beginInc + 1;
        char[] tmp = new char[len];
        System.arraycopy(source, beginInc, tmp, 0, len);
        dest.insert(destPtr, tmp);
    }
}

