/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori.DB2;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SqlEarley;

public class HarvestDoc {
    private static String urlPrefix = "https://www.ibm.com/support/knowledgecenter/SSEPGG_11.1.0/com.ibm.db2.luw.sql.ref.doc/doc/";
    private static Set<String> processed = new HashSet<String>();
    static Map<String, ParseNode> allStatements = new HashMap<String, ParseNode>();

    public static void main(String[] stringArray) throws Exception {
        HarvestDoc.crawlDocWebsite();
        System.out.println("Total Statements = " + allStatements.size());
        int n = 0;
        for (String string : allStatements.keySet()) {
            if (HarvestDoc.allStatements.get((Object)string).topLevel != null || 0 >= allStatements.get(string).children().size()) continue;
            ++n;
        }
        System.out.println("Parsed = " + n);
    }

    private static void crawlDocWebsite() {
        String string;
        block3: {
            processed = new HashSet<String>();
            string = null;
            try {
                string = HarvestDoc.readURL(urlPrefix + "r0011049.html?view=embed");
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("\nFileNotFoundException " + fileNotFoundException.getMessage());
                System.exit(0);
            }
            catch (Exception exception) {
                if (!exception.getClass().getPackage().getName().contains("java.net")) break block3;
                System.err.println("Failed to connect to " + exception.getMessage());
                System.exit(0);
            }
        }
        HarvestDoc.processReferences(string);
    }

    private static void processReferences(String string) {
        Object object;
        int n;
        String string2 = "<a class=\"xref\" href=\"";
        String string3 = "\" title=\"";
        int n2 = string.indexOf(string2);
        while (n2 > 0 && (n = string.indexOf(string3, n2 + string2.length())) >= 0) {
            if (n2 + string2.length() + 20 >= n) {
                object = string.substring(n2 + string2.length(), n);
                if (((String)object).startsWith("../doc/")) {
                    object = ((String)object).substring("../doc/".length());
                }
                if (!((String)object).contains("/")) {
                    try {
                        if ("r0061970.html".equals(object)) {
                            object = (String)object;
                        }
                        HarvestDoc.processDoc((String)object);
                    }
                    catch (Exception exception) {
                        System.err.println((String)object + " " + exception.getMessage() + " ");
                    }
                }
            }
            n2 = string.indexOf(string2, n2 + string2.length());
        }
        string2 = "<a class=\"link\" href=\"";
        string3 = "\">";
        n2 = string.indexOf(string2);
        while (n2 > 0 && (n = string.indexOf(string3, n2 + string2.length())) >= 0) {
            if (n2 + string2.length() + 20 >= n) {
                object = string.substring(n2 + string2.length(), n);
                if (((String)object).startsWith("../doc/")) {
                    object = ((String)object).substring("../doc/".length());
                }
                if (!((String)object).contains("/")) {
                    try {
                        if ("r0061970.html".equals(object)) {
                            object = (String)object;
                        }
                        HarvestDoc.processDoc((String)object);
                    }
                    catch (Exception exception) {
                        System.err.println((String)object + " " + exception.getMessage() + " ");
                    }
                }
            }
            n2 = string.indexOf(string2, n2 + string2.length());
        }
    }

    private static void processDoc(String string) throws FileNotFoundException, IOException {
        Object object;
        String string2;
        block8: {
            string2 = null;
            try {
                object = urlPrefix + string + "?view=embed";
                if (processed.contains(object)) {
                    return;
                }
                processed.add((String)object);
                string2 = HarvestDoc.readURL((String)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("\nFileNotFoundException " + fileNotFoundException.getMessage());
            }
            catch (Exception exception) {
                if (!exception.getClass().getPackage().getName().contains("java.net")) break block8;
                System.err.println("URL=" + string);
                System.err.println("Failed to connect to " + exception.getMessage());
                System.exit(0);
            }
        }
        object = "<code>";
        String string3 = "</code>";
        int n = string2.indexOf((String)object);
        while (n > 0) {
            int n2 = string2.indexOf(string3, n + ((String)object).length());
            String string4 = string2.substring(n + ((String)object).length(), n2);
            string4 = string4.replace("&gt;", ">");
            string4 = string4.replace("&lt;", "<");
            string4 = string4.replace("<strong class=\"ph b\">", "");
            string4 = string4.replace("</strong>", "");
            string4 = string4.replace("<em class=\"ph i\">", "");
            if (!((string4 = string4.replace("</em>", "")).startsWith("<storage") || string4.startsWith("NAME") || string4.startsWith("123") || allStatements.containsKey(string4))) {
                List list = LexerToken.parse((String)string4);
                ParseNode parseNode = SqlEarley.getInstance().parse(list);
                allStatements.put(string4, parseNode);
                if (parseNode.topLevel != null || parseNode.children().size() == 0) {
                    System.err.println(string4);
                } else {
                    System.out.println(string4);
                }
                System.out.println("------------------------------");
            }
            n = string2.indexOf((String)object, n + ((String)object).length());
        }
        HarvestDoc.processReferences(string2);
    }

    static String readURL(String string) throws Exception {
        if (string.endsWith(".pdf") || string.endsWith(".mobi") || string.endsWith(".epub")) {
            return "";
        }
        byte[] byArray = new byte[4096];
        int n = 0;
        URL uRL = new URL(string);
        System.out.print("opening " + string + "...");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        System.out.println("done.");
        n = bufferedInputStream.read(byArray, 0, byArray.length);
        StringBuilder stringBuilder = new StringBuilder();
        while (n != -1) {
            stringBuilder.append(new String(byArray).substring(0, n));
            n = bufferedInputStream.read(byArray, 0, byArray.length);
        }
        bufferedInputStream.close();
        return stringBuilder.toString();
    }
}

