/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Clob;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.sql.DATE;

public class XLSXFormatter
extends ResultsFormatter {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final String TYPE = "EXCEL.XML";
    public static final String EXT = "excel2003.xml";
    public static final String KEY_REC_TERM = "EXPORT_XSLX_REC_TERM";
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?mso-application progid=\"Excel.Sheet\"?>\n<Workbook xmlns:c=\"urn:schemas-microsoft-com:office:component:spreadsheet\"            xmlns:html=\"http://www.w3.org/TR/REC-html40\" xmlns:o=\"urn:schemas-microsoft-com:office:office\"            xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"            xmlns:x2=\"http://schemas.microsoft.com/office/excel/2003/xml\" xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\"            xmlns:x=\"urn:schemas-microsoft-com:office:excel\">\n  <OfficeDocumentSettings xmlns=\"urn:schemas-microsoft-com:office:office\">\n    <Colors>\n      <Color>\n        <Index>3</Index>\n        <RGB>#c0c0c0</RGB>\n      </Color>\n      <Color>\n        <Index>4</Index>\n        <RGB>#ff0000</RGB>\n      </Color>\n    </Colors>\n  </OfficeDocumentSettings>\n  <ExcelWorkbook xmlns=\"urn:schemas-microsoft-com:office:excel\">\n    <WindowHeight>9000</WindowHeight>\n    <WindowWidth>13860</WindowWidth>\n    <WindowTopX>240</WindowTopX>\n    <WindowTopY>75</WindowTopY>\n    <ProtectStructure>False</ProtectStructure>\n    <ProtectWindows>False</ProtectWindows>\n  </ExcelWorkbook>\n  <Styles>\n    <Style ss:ID=\"Default\" ss:Name=\"Default\"/>\n    <Style ss:ID=\"Result\" ss:Name=\"Result\">\n      <Font ss:Bold=\"1\" ss:Italic=\"1\" ss:Underline=\"Single\"/>\n    </Style>\n    <Style ss:ID=\"Result2\" ss:Name=\"Result2\">\n      <Font ss:Bold=\"1\" ss:Italic=\"1\" ss:Underline=\"Single\"/>\n      <NumberFormat ss:Format=\"Currency\"/>\n    </Style>\n    <Style ss:ID=\"Heading\" ss:Name=\"Heading\">\n      <Font ss:Bold=\"1\" ss:Italic=\"1\" ss:Size=\"16\"/>\n    </Style>\n    <Style ss:ID=\"Heading1\" ss:Name=\"Heading1\">\n      <Font ss:Bold=\"1\" ss:Italic=\"1\" ss:Size=\"16\"/>\n    </Style>\n    <Style ss:ID=\"co1\"/>\n    <Style ss:ID=\"co2\"/>\n    <Style ss:ID=\"ta1\"/>\n    <Style ss:ID=\"ce1\">\n      <NumberFormat ss:Format=\"Short Date\"/>\n    </Style>\n    <Style ss:ID=\"ce2\">\n      <NumberFormat ss:Format=\"General Date\"/>\n    </Style>\n    <Style ss:ID=\"ce3\">\n      <NumberFormat ss:Format=\"General Date\"/>\n    </Style>\n    <Style ss:ID=\"ce4\">\n      <NumberFormat ss:Format=\"Long Time\"/>\n    </Style>  </Styles>  <ss:Worksheet ss:Name=\"Sheet 1 Name\">\n    <Table ss:StyleID=\"ta1\">\n";
    private boolean _result = true;

    public XLSXFormatter() {
        super(TYPE, Messages.getString((String)"XLSXFormatter.0"), EXT);
    }

    public void setResult(boolean bl) {
        this._result = bl;
    }

    public void start() throws IOException {
        this.write(HEADER + this.getLineTerminator());
        this.write(" <Row ss:Height=\"12.384\">");
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.write("<Cell>\n<Data ss:Type=\"String\">" + this.getColumnName(i) + "</Data>\n</Cell>\n");
        }
        this.write("      </Row>");
    }

    public void startRow() throws IOException {
        this.write("\t <Row>" + this.getLineTerminator());
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
        int n3 = 0;
        n3 = this.getDataType(n);
        switch (n3) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                this.write("<Cell>");
                if (object != null) {
                    this.write("<Data ss:Type=\"Number\">" + this.getValue(object).toString() + "</Data>");
                } else {
                    this.write("<Data ss:Type=\"Number\"></Data>");
                }
                this.write("</Cell>");
                break;
            }
            case 91: 
            case 93: {
                this.write("<Cell ss:StyleID=\"ce2\">\n");
                if (object != null) {
                    this.write("<Data  ss:Type=\"DateTime\">" + this.formatDate(object) + "</Data>\n");
                } else {
                    this.write("<Data ss:Type=\"DateTime\"></Data>");
                }
                this.write("</Cell>");
                break;
            }
            default: {
                this.write("<Cell>");
                if (object != null) {
                    this.write("<Data ss:Type=\"String\">");
                    this.write(this.getValue(object).toString());
                    this.write("</Data>");
                } else {
                    this.write("<Data ss:Type=\"String\"></Data>");
                }
                this.write("</Cell>");
            }
        }
    }

    private String formatDate(Object object) {
        Date date = null;
        if (object instanceof DATE) {
            date = ((DATE)object).dateValue();
        } else if (object instanceof Date) {
            date = (Date)object;
        } else {
            return object.toString();
        }
        return this.dateFormat.format(date);
    }

    public void endRow() throws IOException {
        this.write("\t</Row>" + this.getLineTerminator());
    }

    public void end() throws IOException {
        this.write("    </Table>\n    <x:WorksheetOptions/>\n  </ss:Worksheet></Workbook>");
    }

    public boolean allowsLobs() {
        return true;
    }

    public void setTableName(String string) {
    }

    public boolean isLineTerminatorSupported() {
        return true;
    }

    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    protected String getValue(Object object) {
        try {
            if (object instanceof Clob) {
                Clob clob = (Clob)object;
                Long l = clob.length();
                int n = 4000;
                String string = "";
                long l2 = 1L;
                while (l > 0L) {
                    string = clob.getSubString(l2, n);
                    this.write(string);
                    l = l - (long)string.length();
                    l2 += (long)string.length();
                }
                return "";
            }
            return super.getValue(object).toString();
        }
        catch (Exception exception) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }
}

