/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.TransientMarker;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.JProjectLibraries;

public class LibraryReference
extends HashStructureAdapter {
    private static final String DELIMITER = "###";
    public final String ID_PROPERTY = "id";
    public final String IS_JDK_PROPERTY = "isJDK";
    public final String JDK_VERSION = "jdkVersion";

    public LibraryReference() {
        this(HashStructure.newInstance());
    }

    public LibraryReference(HashStructure hash) {
        super(hash);
    }

    public Object getID() {
        return this._hash.getObject("id");
    }

    public void setID(Object id) {
        if (id instanceof URL) {
            this._hash.putURL("id", (URL)id);
        } else {
            this._hash.putString("id", id.toString());
        }
    }

    public String getVersion() {
        return this._hash.getString("jdkVersion");
    }

    public void setVersion(String version) {
        this._hash.putString("jdkVersion", version, true);
    }

    public boolean isJDK() {
        return this._hash.getBoolean("isJDK", false);
    }

    public boolean getIsJDK() {
        return this.isJDK();
    }

    public void setIsJDK(boolean isJDK) {
        this._hash.putBoolean("isJDK", isJDK);
    }

    public Library getLibrary() throws TransientMarker {
        return this.getLibrary(null);
    }

    public Library getLibrary(Project project) throws TransientMarker {
        JProjectLibraryList list;
        JLibrary found;
        boolean isJDK = this._hash.getBoolean("isJDK");
        Object id = this._hash.getObject("id");
        if (isJDK) {
            JProjectLibraryList list2;
            JDK found2;
            String str = this._hash.getString("jdkVersion");
            VersionNumber version = null;
            try {
                version = str != null ? new VersionNumber(str) : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (project != null && (found2 = (list2 = JProjectLibraries.getInstance((PropertyStorage)project).getProjectLibraryList()).findJDK(id)) != null) {
                return found2;
            }
            return JLibraryManager.findJDKMatch(id, version);
        }
        if (project != null && (found = (list = JProjectLibraries.getInstance((PropertyStorage)project).getProjectLibraryList()).findLibrary(id)) != null) {
            return found;
        }
        return JLibraryManager.findLibrary(id);
    }

    public void setLibrary(final Library lib) throws TransientMarker {
        this._hash.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                Object id;
                Object object = id = lib != null ? lib.getID() : null;
                if (id == null) {
                    LibraryReference.this._hash.remove("id");
                    LibraryReference.this._hash.remove("isJDK");
                    return;
                }
                if (id instanceof URL) {
                    LibraryReference.this._hash.putURL("id", (URL)id);
                } else {
                    LibraryReference.this._hash.putString("id", id.toString());
                }
                if (lib instanceof JDK) {
                    LibraryReference.this._hash.putBoolean("isJDK", true);
                    VersionNumber version = ((JDK)lib).getJavaVersion();
                    if (version != null) {
                        LibraryReference.this._hash.putString("jdkVersion", version.toString());
                    } else {
                        LibraryReference.this._hash.remove("jdkVersion");
                    }
                } else {
                    LibraryReference.this._hash.putBoolean("isJDK", false);
                    LibraryReference.this._hash.remove("jdkVersion");
                }
            }
        });
    }

    public static String toString(LibraryReference ref) {
        String version;
        Object id = ref.getID();
        if (id == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        boolean jdk = ref.isJDK();
        if (jdk && (version = ref.getVersion()) != null && version.length() > 0) {
            buffer.append(version);
        }
        buffer.append(DELIMITER);
        if (id instanceof URL) {
            buffer.append("URL");
            buffer.append(DELIMITER);
        } else {
            buffer.append("String");
            buffer.append(DELIMITER);
        }
        String idString = id.toString();
        buffer.append(idString);
        return buffer.toString();
    }

    public static LibraryReference parseReference(String text) throws IllegalArgumentException {
        try {
            int afterd1;
            int d2;
            int d1 = text.indexOf(DELIMITER);
            String version = null;
            if (d1 < 0) {
                throw new IllegalArgumentException("Missing 1st delimiter");
            }
            if (d1 > 0) {
                version = text.substring(0, d1);
            }
            if ((d2 = text.indexOf(DELIMITER, afterd1 = d1 + DELIMITER.length() + 1)) < 0) {
                throw new IllegalArgumentException("Missing 2nd delimiter");
            }
            String type = text.substring(afterd1, d2);
            int afterd2 = d2 + DELIMITER.length() + 2;
            String trailer = text.substring(afterd2);
            LibraryReference reference = new LibraryReference();
            Object id = trailer;
            if ("URL".equals(type)) {
                id = new URL(trailer);
            }
            reference.setID(id);
            if (version != null) {
                reference.setIsJDK(true);
                reference.setVersion(version);
            }
            return reference;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

