/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.vcs.VCSManager;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetException;
import oracle.jdeveloper.vcs.changeset.ChangeSetHandler;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdevimpl.vcs.svn.SVNExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNMessagePage;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.StatusMapping;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNChangelistHandler;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public final class SVNChangeSetAdapter
extends ChangeSetAdapter {
    private final VCSProfile _profile = VCSProfileRegistry.getInstance().getProfile(this.getSystemId());
    private SVNChangelistClient _client;
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNChangeSetAdapter.class.getName());

    public SVNChangeSetAdapter(String vcsId) {
        super(vcsId);
        this.setExpiryEnabled(true);
    }

    public boolean isChanged(VCSStatus status) {
        return status == StatusMapping.getVCSStatus(SVNStatusType.STATUS_MODIFIED) || status == StatusMapping.getVCSStatus(SVNStatusType.STATUS_ADDED) || status == StatusMapping.getVCSStatus(SVNStatusType.STATUS_DELETED) || status == StatusMapping.getVCSStatus(SVNStatusType.MERGED) || status == StatusMapping.getVCSStatus(SVNStatusType.CONFLICTED);
    }

    public IdeAction getCommitAction() {
        return IdeAction.find((int)Ide.findCmdID((String)"oracle.jdeveloper.subversion.commit"));
    }

    public synchronized URL[] getChangeSetURLs(final String name, URL[] contextUrls) throws ChangeSetException {
        URL contextUrl;
        if (contextUrls.length <= 0) {
            throw new IllegalStateException();
        }
        URL url = null;
        URL[] uRLArray = contextUrls;
        int n = uRLArray.length;
        for (int i = 0; i < n && (url = SVNUtil.resolveWorkingCopy(contextUrl = uRLArray[i])) == null; ++i) {
        }
        try {
            final ArrayList urls = new ArrayList();
            SVNUtil.getChangeClient().doGetChangeLists(this.convertURLToFile(url), null, SVNDepth.INFINITY, new ISVNChangelistHandler(){

                public final void handle(File path, String changelistName) {
                    if (changelistName == null) {
                        return;
                    }
                    if (name != null && !name.equals(changelistName)) {
                        return;
                    }
                    urls.add(URLFactory.newFileURL((File)path));
                }
            });
            return urls.toArray(new URL[urls.size()]);
        }
        catch (SVNException svne) {
            new SVNExceptionHandler().handleException((Exception)SVNExceptionWrapper.wrapSVNClientException((Exception)((Object)svne)));
            return new URL[0];
        }
    }

    public synchronized void addToChangeSet(URL[] urls, String name) throws ChangeSetException {
        try {
            urls = this.retainVersioned(urls);
            if (urls.length == 0) {
                return;
            }
            SVNUtil.getChangeClient().doAddToChangelist(this.convertURLsToFiles(urls), SVNDepth.EMPTY, name, null);
            this.logChangeSetMessage(urls, "LOG_MSG_ADD_CHANGESET", name);
        }
        catch (SVNException svne) {
            new SVNExceptionHandler().handleException((Exception)SVNExceptionWrapper.wrapSVNClientException((Exception)((Object)svne)));
        }
    }

    public synchronized void removeFromChangeSet(URL[] urls, String name) throws ChangeSetException {
        try {
            String[] stringArray;
            urls = this.retainVersioned(urls);
            if (urls.length == 0) {
                return;
            }
            SVNChangelistClient sVNChangelistClient = this.getClient();
            File[] fileArray = this.convertURLsToFiles(urls);
            if (name != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = name;
            } else {
                stringArray = null;
            }
            sVNChangelistClient.doRemoveFromChangelist(fileArray, SVNDepth.EMPTY, stringArray);
            this.logChangeSetMessage(urls, "LOG_MSG_REMOVE_CHANGESET", name);
        }
        catch (SVNException svne) {
            new SVNExceptionHandler().handleException((Exception)SVNExceptionWrapper.wrapSVNClientException((Exception)((Object)svne)));
        }
    }

    public void handleCommitted(URL[] urls) throws ChangeSetException {
        ArrayList<URL> urls0 = new ArrayList<URL>(Arrays.asList(urls));
        Iterator itr = urls0.iterator();
        while (itr.hasNext()) {
            URL url = (URL)itr.next();
            if (!URLFileSystem.isDirectoryPath((URL)url) || !VCSManager.getVCSManager().isVersioned(url)) continue;
            itr.remove();
        }
        this.removeFromChangeSet(urls0.toArray(new URL[urls0.size()]), null);
    }

    protected synchronized void getChangeSetsImpl(URL[] urls, final ChangeSetHandler handler, Depth depth) throws ChangeSetException {
        try {
            SVNDepth svnDepth = SVNDepth.EMPTY;
            if (depth == Depth.IMMEDIATES) {
                svnDepth = SVNDepth.IMMEDIATES;
            }
            if (depth == Depth.INFINITY) {
                svnDepth = SVNDepth.INFINITY;
            }
            for (URL url : urls = this.retainVersioned(urls)) {
                if (!SVNUtil.isWorkingCopy(URLFileSystem.isDirectoryPath((URL)url) ? url : URLFileSystem.getParent((URL)url)) || !URLFileSystem.exists((URL)url)) continue;
                File file = this.convertURLToFile(url);
                SVNUtil.getChangeClient().doGetChangeLists(this.convertURLToFile(url), null, svnDepth, new ISVNChangelistHandler(){

                    public final void handle(File path, String changelistName) {
                        if (changelistName == null) {
                            return;
                        }
                        handler.handle(URLFactory.newFileURL((File)path), changelistName);
                    }
                });
            }
        }
        catch (SVNException svne) {
            new SVNExceptionHandler().handleException((Exception)SVNExceptionWrapper.wrapSVNClientException((Exception)((Object)svne)));
        }
    }

    private void logChangeSetMessage(URL[] urls, String msg, String csname) {
        if (csname == null) {
            return;
        }
        for (URL url : urls) {
            this.logMessage(Resource.format(msg, URLFileSystem.getPlatformPathName((URL)url), csname));
            this.logMessage("\n");
        }
    }

    private final SVNChangelistClient getClient() {
        if (this._client == null) {
            SVNClientManager manager = SVNClientManager.newInstance();
            this._client = manager.getChangelistClient();
        }
        return this._client;
    }

    private final File[] convertURLsToFiles(URL[] urls) {
        File[] files = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            files[i] = this.convertURLToFile(urls[i]);
        }
        return files;
    }

    private final File convertURLToFile(URL url) {
        return new File(URLFileSystem.getPlatformPathName((URL)url));
    }

    private final URL[] retainVersioned(URL[] urls) throws ChangeSetException {
        try {
            ArrayList<URL> urls0 = new ArrayList<URL>();
            VCSStatus[] statuses = (VCSStatus[])this._profile.getPolicyStatusCache().get(urls);
            VCSStatusFilter filter = this._profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.MISSING");
            for (int i = 0; i < urls.length; ++i) {
                if (statuses[i] == null || !statuses[i].isVersioned() || filter.accept(statuses[i])) continue;
                urls0.add(urls[i]);
            }
            return urls0.toArray(new URL[urls0.size()]);
        }
        catch (Exception e) {
            throw new ChangeSetException(e);
        }
    }

    private void logMessage(String message) {
        if (IdeUtil.isHeadless() || message == null) {
            return;
        }
        SVNMessagePage page = null;
        try {
            page = SVNMessagePage.getInstance();
            page.log(message);
        }
        catch (Exception ex) {
            sLogger.warning(ex.getMessage());
        }
    }
}

