/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.jdeveloper.vcs.nav.ConnectionFilter;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFile;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFolder;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.util.browser.BrowserModelWorker;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNRemoteContainer
extends DefaultContainer
implements SVNRemoteNode {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNRemoteContainer.class.getName());
    protected SVNRemoteContainer _parent;
    private final SVNRepositoryNode _parentRepos;
    private final SVNUrl _svnUrl;
    private ConnectionFilter _filter;
    private final Lock _lock = new ReentrantLock();

    public SVNRemoteContainer(SVNRemoteContainer parent, SVNRepositoryNode parentRepos, SVNUrl url) {
        this._parentRepos = parentRepos;
        this._svnUrl = url;
        this._parent = parent;
        this.setURL(SVNNavURLFileSystemHelper.toNavigatorUrl(url));
    }

    void setFilter(ConnectionFilter filter) {
        this._filter = filter;
    }

    @Override
    public SVNRepositoryNode getParentRepository() {
        return this._parentRepos;
    }

    @Override
    public SVNUrl getSVNUrl() {
        return this._svnUrl;
    }

    @Override
    public SVNNodeKind getNodeKind() {
        return SVNNodeKind.DIR;
    }

    public String getToolTipText() {
        return this._svnUrl.toString();
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Object getData() {
        return this.getSVNUrl();
    }

    void requestCollapse() {
        UpdateMessage.fireObjectClosed((Subject)this);
        this.setOpen(false);
    }

    protected void postCloseImpl() {
        System.out.println("SVNRemoteContainer postCloseImpl ");
    }

    protected void openImpl() throws IOException {
        new BrowserModelWorker((Subject)this, this._children, this._lock){

            protected Collection getChildrenInBackground() {
                return SVNRemoteContainer.this.openContainer(this);
            }
        }.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection openContainer(BrowserModelWorker worker) {
        ArrayList<SVNRemoteNode> children = new ArrayList<SVNRemoteNode>();
        try {
            ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(this.getSVNUrl());
            SVNClientInteraction.getInstance().beginInteraction(svnClient, repoInfo);
            ISVNDirEntry[] entries = svnClient.getList(this.getSVNUrl(), SVNRevision.HEAD, false);
            for (int i = 0; i < entries.length; ++i) {
                SVNUrl sVNUrl = this.getSVNUrl().appendPath(entries[i].getPath());
                StringBuilder path = new StringBuilder();
                for (String segment : sVNUrl.getPathSegments()) {
                    path.append('/');
                    path.append(segment);
                }
                if (entries[i].getNodeKind().equals((Object)SVNNodeKind.DIR)) {
                    if (this._filter != null && !this._filter.accept(path.toString())) continue;
                    children.add(new SVNRemoteFolder(this, this.getParentRepository(), sVNUrl));
                    continue;
                }
                if (entries[i].getNodeKind().equals((Object)SVNNodeKind.FILE)) {
                    if (this._filter != null && !this._filter.accept(path.toString())) continue;
                    children.add(new SVNRemoteFile(this, this.getParentRepository(), sVNUrl, (SVNRevision)entries[i].getLastChangedRevision()));
                    continue;
                }
                sLogger.fine("browsed unknown node type: " + sVNUrl.toString() + ", " + entries[i].getNodeKind().toString());
            }
            for (Object e : children) {
                if (!(e instanceof SVNRemoteContainer)) continue;
                ((SVNRemoteContainer)e).setFilter(this._filter);
            }
        }
        catch (SVNClientException ce) {
            this.cleanup((Exception)((Object)ce), worker);
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
        return children;
    }

    private void cleanup(Exception e, BrowserModelWorker worker) {
        sLogger.log(Level.WARNING, "unable to list children of " + this.getSVNUrl().toString(), e);
        worker.fail(new Runnable(){

            @Override
            public final void run() {
                if (SVNRemoteContainer.this instanceof SVNRepositoryNode) {
                    SVNRemoteContainer.this.requestCollapse();
                } else {
                    SVNRemoteContainer.this.getParentRepository().requestCollapse();
                }
            }
        });
        new VCSExceptionHandler().handleException(SVNExceptionWrapper.wrapException(e));
    }

    @Override
    public SVNRemoteContainer getParent() {
        return this._parent;
    }
}

