/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNSwitchHandler {
    private Context _context;

    public SVNSwitchHandler(Context context) {
        this._context = context;
    }

    public void executeSwitching(File destFile, SVNUrl toUrl, SVNRevision toRevision, SVNRepositoryInfo repoInfo) {
        this.executeSwitching(destFile, toUrl, toRevision, true, repoInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSwitching(File destFile, SVNUrl toUrl, SVNRevision toRevision, boolean isRecursive, SVNRepositoryInfo repoInfo, IndeterminateProgressMonitor progressMon) {
        try {
            ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(svnClient, repoInfo, progressMon);
            svnClient.switchToUrl(destFile, toUrl, toRevision, isRecursive);
            this.refreshNodes();
            SVNOperationLogger.getInstance().successFinish(Resource.get("OP_SWITCH"));
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
    }

    private void refreshNodes() {
        this.refreshNodes(this._context.getElement());
    }

    private void refreshNodes(Element elem) {
        if (elem != null) {
            if (!elem.mayHaveChildren()) {
                if (elem instanceof Node && ((Node)elem).isOpen()) {
                    VCSBufferUtils.reloadBuffer((URL)((Node)elem).getURL());
                    return;
                }
            } else {
                Iterator it = elem.getChildren();
                while (it != null && it.hasNext()) {
                    this.refreshNodes((Element)it.next());
                }
            }
        }
    }
}

