/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.ArrayList;
import java.util.List;
import oracle.express.olapi.data.full.CursorInputParameter;
import oracle.express.olapi.data.full.CursorInputTemplateGenerator;
import oracle.express.olapi.data.full.CursorInputTemplateState;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.cursor.CursorInput;
import oracle.olapi.data.cursor.SourceType;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.DynamicDefinition;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.JoinDefinition;
import oracle.olapi.data.source.ParameterizedSourceDefinition;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.Template;
import oracle.olapi.transaction.BaseTransaction;
import oracle.olapi.transaction.Transaction;

public class CursorInputTemplate
extends Template {
    private DynamicDefinition m_Definition = null;
    private Source m_Base = null;

    public CursorInputTemplate(Source source, Source[] sourceArray, SourceType[] sourceTypeArray, Transaction transaction) {
        super(new CursorInputTemplateState(), source.getDataProvider(), transaction);
        CursorInputTemplateState cursorInputTemplateState = (CursorInputTemplateState)this.getCurrentStateForRead();
        cursorInputTemplateState.setInfo(sourceArray, sourceTypeArray, CursorInputTemplate.createParameters(source.getDataProvider(), sourceTypeArray));
        this.m_Base = source;
        CursorInputTemplateGenerator cursorInputTemplateGenerator = new CursorInputTemplateGenerator(this);
        this.m_Definition = this.createDynamicDefinition(cursorInputTemplateGenerator, transaction);
        this.m_Definition.forceCurrentGenerationForRead(transaction);
    }

    public final DynamicDefinition getDefinition() {
        return this.m_Definition;
    }

    public final Source getSource() {
        return this.m_Definition.getSource();
    }

    public final Source getBase() {
        return this.m_Base;
    }

    public final Source[] getInputSources() {
        CursorInputTemplateState cursorInputTemplateState = (CursorInputTemplateState)this.getCurrentState();
        return cursorInputTemplateState.getInputSources();
    }

    public final SourceType[] getInputSourceTypes() {
        CursorInputTemplateState cursorInputTemplateState = (CursorInputTemplateState)this.getCurrentState();
        return cursorInputTemplateState.getInputSourceTypes();
    }

    public final void setInputSources(Source[] sourceArray, SourceType[] sourceTypeArray) {
        CursorInputTemplateState cursorInputTemplateState = (CursorInputTemplateState)this.getCurrentState();
        cursorInputTemplateState.setInfo(sourceArray, sourceTypeArray, CursorInputTemplate.createParameters(this.getDataProvider(), sourceTypeArray));
        this.setCurrentState(cursorInputTemplateState);
    }

    public final void addCursorInputs(CursorInput[] cursorInputArray) {
        CursorInputTemplateState cursorInputTemplateState = (CursorInputTemplateState)this.getCurrentStateForRead();
        if (cursorInputTemplateState.getParameters() != null && cursorInputTemplateState.getParameters().length > 0 && cursorInputArray == null || cursorInputTemplateState.getParameters() == null && cursorInputArray != null && cursorInputArray.length > 0 || cursorInputArray != null && cursorInputTemplateState.getParameters() != null && cursorInputTemplateState.getParameters().length != cursorInputArray.length) {
            throw new UnsupportedOperationException();
        }
        if (cursorInputArray != null && cursorInputArray.length > 0) {
            cursorInputTemplateState.addCursorInputs(cursorInputArray);
        }
    }

    private static final CursorInputParameter[] createParameters(DataProvider dataProvider, SourceType[] sourceTypeArray) {
        if (sourceTypeArray == null) {
            return null;
        }
        CursorInputParameter[] cursorInputParameterArray = new CursorInputParameter[sourceTypeArray.length];
        for (int i = 0; i < sourceTypeArray.length; ++i) {
            cursorInputParameterArray[i] = new CursorInputParameter(dataProvider, sourceTypeArray[i]);
        }
        return cursorInputParameterArray;
    }

    public final List getParameters() {
        CursorInputTemplateState cursorInputTemplateState = (CursorInputTemplateState)this.getCurrentState();
        CursorInputParameter[] cursorInputParameterArray = cursorInputTemplateState.getParameters();
        ArrayList<CursorInputParameter> arrayList = new ArrayList<CursorInputParameter>();
        for (int i = 0; i < cursorInputParameterArray.length; ++i) {
            arrayList.add(cursorInputParameterArray[i]);
        }
        return arrayList;
    }

    public final Source generateSource(CursorInputTemplateState cursorInputTemplateState) {
        if (!this.getDataProvider().isServerVersionLaterThan(new int[]{10, 0, 0, 0})) {
            return this.getBase();
        }
        if (cursorInputTemplateState.getInputSources() == null) {
            return this.getBase();
        }
        Source source = this.getBase();
        for (int i = 0; i < cursorInputTemplateState.getInputSources().length; ++i) {
            Source source2;
            Source source3 = cursorInputTemplateState.getInputSources()[i];
            SourceType sourceType = cursorInputTemplateState.getInputSourceTypes()[i];
            CursorInputParameter cursorInputParameter = cursorInputTemplateState.getParameters()[i];
            BaseTransaction baseTransaction = this.getDataProvider().getBaseTransactionProvider().getCurrentSystemTransaction();
            FundamentalMetadataObject fundamentalMetadataObject = null;
            if (sourceType == SourceType.STRING_SOURCE) {
                fundamentalMetadataObject = this.getDataProvider().getFundamentalMetadataProvider().getStringDataType();
            } else if (sourceType == SourceType.DATE_SOURCE) {
                fundamentalMetadataObject = this.getDataProvider().getFundamentalMetadataProvider().getDateDataType();
            } else if (sourceType == SourceType.BOOLEAN_SOURCE) {
                fundamentalMetadataObject = this.getDataProvider().getFundamentalMetadataProvider().getBooleanDataType();
            } else if (sourceType == SourceType.NUMBER_SOURCE) {
                fundamentalMetadataObject = this.getDataProvider().getFundamentalMetadataProvider().getNumberDataType();
            }
            ParameterizedSourceDefinition parameterizedSourceDefinition = new ParameterizedSourceDefinition(cursorInputParameter, fundamentalMetadataObject._getSourceDefinition(), (Transaction)baseTransaction);
            Source source4 = parameterizedSourceDefinition.findOrCreateSource(baseTransaction);
            JoinDefinition joinDefinition = new JoinDefinition(source.getDefinition(), source3.getDefinition(), parameterizedSourceDefinition, 0, false, baseTransaction);
            source = source2 = joinDefinition.findOrCreateSource(baseTransaction);
        }
        return source;
    }
}

