/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class RestrictedLock
implements Lock {
    private final ReentrantLock wrappedLock;
    private final Condition unrestrictedCondition;
    private volatile Mode lockMode = Mode.UNRESTRICTED;
    private final Queue<AsyncTask> taskQueue = new ConcurrentLinkedQueue<AsyncTask>();

    static RestrictedLock newInstance(ReentrantLock reentrantLock) {
        return new RestrictedLock(reentrantLock);
    }

    private RestrictedLock(ReentrantLock reentrantLock) {
        this.wrappedLock = reentrantLock;
        this.unrestrictedCondition = reentrantLock.newCondition();
    }

    @Override
    public void unlock() {
        this.wrappedLock.unlock();
        if (!this.wrappedLock.isHeldByCurrentThread()) {
            this.dequeueTask();
        }
    }

    private void dequeueTask() {
        if (this.lockMode != Mode.UNRESTRICTED) {
            return;
        }
        AsyncTask asyncTask = this.taskQueue.poll();
        if (asyncTask != null) {
            asyncTask.executor.execute(() -> this.lockAsync(asyncTask.runnable, asyncTask.executor));
        }
    }

    @Override
    public final void lock() {
        this.wrappedLock.lock();
        while (this.lockMode == Mode.RESTRICTED) {
            this.unrestrictedCondition.awaitUninterruptibly();
        }
    }

    @Override
    public final void lockInterruptibly() throws InterruptedException {
        this.wrappedLock.lockInterruptibly();
        if (this.lockMode == Mode.RESTRICTED) {
            try {
                do {
                    this.unrestrictedCondition.await();
                } while (this.lockMode == Mode.RESTRICTED);
            }
            catch (InterruptedException interruptedException) {
                this.wrappedLock.unlock();
                throw interruptedException;
            }
        }
    }

    @Override
    public final boolean tryLock() {
        if (!this.wrappedLock.tryLock()) {
            return false;
        }
        if (this.lockMode == Mode.RESTRICTED) {
            this.unlock();
            return false;
        }
        return true;
    }

    @Override
    public final boolean tryLock(long l2, TimeUnit timeUnit) throws InterruptedException {
        boolean bl;
        long l3 = System.nanoTime();
        if (!this.wrappedLock.tryLock(l2, timeUnit)) {
            return false;
        }
        if (this.lockMode == Mode.RESTRICTED && !(bl = this.unrestrictedCondition.await(timeUnit.toNanos(l2) - (System.nanoTime() - l3), TimeUnit.NANOSECONDS))) {
            this.unlock();
            return false;
        }
        return true;
    }

    @Override
    public final Condition newCondition() {
        return this.wrappedLock.newCondition();
    }

    final void enterRestrictedMode() {
        this.wrappedLock.lock();
        try {
            this.lockMode = Mode.RESTRICTED;
        }
        finally {
            this.wrappedLock.unlock();
        }
    }

    final void exitRestrictedMode() {
        this.wrappedLock.lock();
        try {
            this.lockMode = Mode.UNRESTRICTED;
            this.unrestrictedCondition.signalAll();
        }
        finally {
            this.unlock();
        }
    }

    final void runUnrestricted(Runnable runnable) {
        this.callUnrestricted(() -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T, E extends Exception> T callUnrestricted(Task<T, E> task) throws E {
        this.wrappedLock.lock();
        if (this.lockMode == Mode.RESTRICTED) {
            this.lockMode = Mode.RESTRICTED_EXECUTING;
            T t2 = task.call();
            return t2;
            finally {
                if (this.lockMode == Mode.RESTRICTED_EXECUTING) {
                    this.lockMode = Mode.RESTRICTED;
                }
            }
        }
        T t3 = task.call();
        return t3;
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockAsync(Runnable runnable, Executor executor) {
        if (this.tryLock()) {
            try {
                runnable.run();
            }
            finally {
                this.unlock();
            }
        }
        AsyncTask asyncTask = new AsyncTask(runnable, executor);
        this.taskQueue.add(asyncTask);
        if (this.tryLock()) {
            try {
                if (this.taskQueue.remove(asyncTask)) {
                    runnable.run();
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    private static final class AsyncTask {
        final Runnable runnable;
        final Executor executor;

        private AsyncTask(Runnable runnable, Executor executor) {
            this.runnable = runnable;
            this.executor = executor;
        }
    }

    @FunctionalInterface
    static interface Task<T, E extends Exception> {
        public T call() throws E;
    }

    private static enum Mode {
        UNRESTRICTED,
        RESTRICTED,
        RESTRICTED_EXECUTING;

    }
}

