/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.util.ResourceBundle;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;

public class CMUtils {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("oracle.jdeveloper.cm.ConnectionRtBundle");
    private static final String ORACLE_URL_PREFIX = "jdbc:oracle:";
    private static final String OLITE_URL_PREFIX = "jdbc:polite:";
    private static final String OLITE4_URL_PREFIX = "jdbc:polite4";
    private static final String ODBC_URL_PREFIX = "jdbc:odbc:";

    public static String getUrl(String presentation, ConnectionDescriptor desc) throws CMException {
        if (presentation.equals("IIOP")) {
            return CMUtils._getIiopUrl(desc);
        }
        if (presentation.equals("JDBC")) {
            return CMUtils._getJdbcUrl(desc);
        }
        throw new CMException("getUrl() for connection type " + presentation + " is not supported.");
    }

    private static String _getIiopUrl(ConnectionDescriptor desc) {
        String serviceString = "sess_iiop://" + desc.getHostname() + ":" + desc.getIiopPort() + ":" + desc.getSid();
        return serviceString;
    }

    private static String _getJdbcUrl(ConnectionDescriptor desc) throws CMException {
        String url = desc.getURL();
        if (null == url || url.length() < 1) {
            if (desc.getProperty("ConnectionType").equals("JDBC_ODBC")) {
                String dsn = desc.getProperty("DSN");
                if (null == dsn) {
                    throw new CMException(bundle.getString("ERROR_NULL_DATASOURCE"));
                }
                return ODBC_URL_PREFIX + dsn;
            }
            if (desc.getProperty("ConnectionType").equals("ORACLE_LITE")) {
                String dsn = desc.getProperty("DSN");
                if (null == dsn) {
                    String host = desc.getProperty("HOSTNAME");
                    String port = desc.getProperty("JDBC_PORT");
                    String sid = desc.getProperty("SID");
                    if (null == host) {
                        throw new CMException(bundle.getString("ERROR_NULL_HOSTNAME"));
                    }
                    if (null == port) {
                        throw new CMException(bundle.getString("ERROR_NULL_PORT"));
                    }
                    if (null == sid) {
                        throw new CMException(bundle.getString("ERROR_NULL_SID"));
                    }
                    return "jdbc:polite4@" + host + ":" + port + ":" + sid;
                }
                return OLITE_URL_PREFIX + dsn;
            }
            if (desc.getProperty("ConnectionType").equals("JDBC") || desc.getProperty("ConnectionType").equals("ORACLE_JSERVER")) {
                String dt = desc.getProperty("ORACLE_JDBC_TYPE");
                String host = desc.getProperty("HOSTNAME");
                String port = desc.getProperty("JDBC_PORT");
                String sid = desc.getProperty("SID");
                String serviceName = desc.getProperty("ServiceName");
                if (null == host) {
                    throw new CMException(bundle.getString("ERROR_NULL_HOSTNAME"));
                }
                if (null == port) {
                    throw new CMException(bundle.getString("ERROR_NULL_PORT"));
                }
                if (null == dt) {
                    throw new CMException(bundle.getString("ERROR_NULL_DRIVER"));
                }
                if (null == sid && null == serviceName) {
                    throw new CMException(bundle.getString("ERROR_NULL_SID"));
                }
                String jdbcurl = null;
                jdbcurl = dt.equals("thin") ? (sid != null ? ORACLE_URL_PREFIX + dt + ":@" + host + ":" + port + ":" + sid : ORACLE_URL_PREFIX + dt + ":@//" + host + ":" + port + "/" + serviceName) : ORACLE_URL_PREFIX + dt + ":@" + CMUtils._namedHostToConnString(host, port, sid);
                return jdbcurl;
            }
        }
        return url;
    }

    public static String namedHostToConnString(String tempString) {
        try {
            int colon1 = tempString.indexOf(58);
            int colon2 = tempString.indexOf(58, colon1 + 1);
            String hostname = tempString.substring(0, colon1);
            String port = tempString.substring(colon1 + 1, colon2);
            String sid = tempString.substring(colon2 + 1);
            return CMUtils._namedHostToConnString(hostname, port, sid);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String _namedHostToConnString(String hostname, String port, String sid) {
        if (hostname == null || port == null || sid == null) {
            return null;
        }
        return "(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=" + hostname + ")(PORT=" + port + ")))(CONNECT_DATA=(SID=" + sid + ")))";
    }
}

