/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.util.function.ObjIntConsumer;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.classpath.ClassPathModel;
import oracle.javatools.exports.classpath.Constructor;
import oracle.javatools.exports.classpath.Field;
import oracle.javatools.exports.classpath.Member;
import oracle.javatools.exports.classpath.Method;
import oracle.javatools.exports.classpath.Package;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.classpath.TypeKind;
import oracle.javatools.exports.common.StringSegment;
import oracle.javatools.exports.common.StringSegmentIterator;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.ElementName;

public abstract class Element
implements Comparable<Element> {
    private char flags;
    private final String accessComment;
    static final Type[] EMPTY_TYPES = new Type[0];
    static final Member<?>[] EMPTY_MEMBERS = new Member[0];
    static final char EXPORTABLE = '\u0001';
    static final char FINAL = '\u0002';
    static final char ABSTRACT = '\u0004';
    static final char STATIC = '\b';
    static final char DEPRECATED = '\u0010';
    static final char ACCESS = '\u0005';
    static final char ACCESS_MASK = '\u0003';
    static final char EXTENSION = '\u0007';
    static final char EXTENSION_MASK = '\u0003';
    static final char JDK = '\u0200';
    static final char REFERENCE = '\u0400';
    static final char UNRESOLVED = '\u0800';
    static final char INTERFACE = '\u0800';
    static final char ESCALATION = '\u0007';
    static final char ESCALATION_MASK = '\u0003';
    static final char ESCALATED = '\u0200';
    static final char SUPPRESSED = '\u0400';
    static final char HAS_EXPORTED_MEMBERS = '\u1000';
    static final char HAS_RESTRICTED_MEMBERS = '\u2000';
    static final char HAS_CONCEALED_MEMBERS = '\u4000';
    static final char HAS_ESCALATED_MEMBERS = '\u8000';
    static final char TRANSIENT_MASK = '\u0fff';
    static final int FLAG_FORMAT = 2;
    static final String NO_FLAGS = "none";

    public void encodeFlags(ObjIntConsumer<String> builder) {
        int count = 0;
        switch (this.getKind()) {
            case PACKAGE: {
                CompatibilityAccess access;
                Package packag = (Package)this;
                if (packag.isDeprecated()) {
                    builder.accept("deprecated", count++);
                }
                if ((access = packag.getCompatibilityAccess('\u0005')) == null) break;
                builder.accept(access.toLowerCase(), count++);
                break;
            }
            case TYPE: {
                CompatibilityAccess access;
                Type type = (Type)this;
                if (!type.isExportable()) {
                    builder.accept("confined", count++);
                }
                if (type.isUnresolved()) {
                    builder.accept("unresolved", count++);
                }
                if (type.isStatic()) {
                    builder.accept("static", count++);
                }
                if (type.isAbstract()) {
                    builder.accept("abstract", count++);
                }
                if (type.isFinal()) {
                    builder.accept("final", count++);
                }
                if (type.isDeprecated()) {
                    builder.accept("deprecated", count++);
                }
                if ((access = type.getCompatibilityAccess('\u0005')) == null) break;
                builder.accept(access.toLowerCase(), count++);
                CompatibilityAccess extension = this.getCompatibilityAccess('\u0007');
                if (extension == access) break;
                builder.accept(extension.toLowerCase(), count++);
                break;
            }
            case CONSTRUCTOR: {
                CompatibilityAccess access;
                Constructor constructor = (Constructor)this;
                if (constructor.isDeprecated()) {
                    builder.accept("deprecated", count++);
                }
                if ((access = constructor.getCompatibilityAccess('\u0005')) == null) break;
                builder.accept(access.toLowerCase(), count++);
                Member.Escalation escalation = constructor.getEscalation();
                if (escalation == Member.Escalation.NONE) break;
                builder.accept(escalation.toLowerCase(), count++);
                if (constructor.isEscalated()) {
                    builder.accept("escalated", count++);
                }
                if (!constructor.isSuppressed()) break;
                builder.accept("suppressed", count++);
                break;
            }
            case METHOD: {
                CompatibilityAccess access;
                Method method = (Method)this;
                if (method.isStatic()) {
                    builder.accept("static", count++);
                }
                if (method.isAbstract()) {
                    builder.accept("abstract", count++);
                }
                if (method.isFinal()) {
                    builder.accept("final", count++);
                }
                if (method.isDeprecated()) {
                    builder.accept("deprecated", count++);
                }
                if ((access = method.getCompatibilityAccess('\u0005')) == null) break;
                builder.accept(access.toLowerCase(), count++);
                Member.Escalation escalation = method.getEscalation();
                if (escalation == Member.Escalation.NONE) break;
                builder.accept(escalation.toLowerCase(), count++);
                if (method.isEscalated()) {
                    builder.accept("escalated", count++);
                }
                if (!method.isSuppressed()) break;
                builder.accept("suppressed", count++);
                break;
            }
            case FIELD: {
                CompatibilityAccess access;
                Field field = (Field)this;
                if (field.isStatic()) {
                    builder.accept("static", count++);
                }
                if (field.isFinal()) {
                    builder.accept("final", count++);
                }
                if (field.isDeprecated()) {
                    builder.accept("deprecated", count++);
                }
                if ((access = field.getCompatibilityAccess('\u0005')) == null) break;
                builder.accept(access.toLowerCase(), count++);
                Member.Escalation escalation = field.getEscalation();
                if (escalation == Member.Escalation.NONE) break;
                builder.accept(escalation.toLowerCase(), count++);
                if (field.isEscalated()) {
                    builder.accept("escalated", count++);
                }
                if (!field.isSuppressed()) break;
                builder.accept("suppressed", count++);
                break;
            }
        }
        if (count == 0) {
            builder.accept(NO_FLAGS, 0);
        }
    }

    static char decodeFlags(ElementKind kind, TypeKind typeKind, String string, int offset, int endOffset, int version) {
        char flags;
        switch (kind) {
            case PACKAGE: {
                flags = '\u0001';
                if (offset == endOffset) {
                    return flags;
                }
                StringSegmentIterator i = new StringSegmentIterator(string, offset, endOffset, ',', StringSegmentIterator.Option.TRIM, StringSegmentIterator.Option.SENTINEL);
                StringSegment segment = (StringSegment)i.next();
                if (segment.matches(NO_FLAGS)) {
                    return flags;
                }
                if (segment.matches("deprecated")) {
                    flags = (char)(flags | 0x10);
                    segment = (StringSegment)i.next();
                }
                CompatibilityAccess access = null;
                if (segment.matches("exported")) {
                    access = CompatibilityAccess.EXPORTED;
                } else if (segment.matches("restricted")) {
                    access = CompatibilityAccess.RESTRICTED;
                } else if (segment.matches("concealed")) {
                    access = CompatibilityAccess.CONCEALED;
                }
                if (access == null) break;
                flags = (char)(flags | access.ordinal() + 1 << 5);
                break;
            }
            case TYPE: {
                flags = '\u0001';
                if (offset == endOffset) {
                    return flags;
                }
                StringSegmentIterator i = new StringSegmentIterator(string, offset, endOffset, ',', StringSegmentIterator.Option.TRIM, StringSegmentIterator.Option.SENTINEL);
                StringSegment segment = (StringSegment)i.next();
                if (segment.matches(NO_FLAGS)) {
                    return flags;
                }
                if (segment.matches("confined")) {
                    flags = '\u0000';
                    segment = (StringSegment)i.next();
                }
                if (segment.matches("unresolved")) {
                    flags = (char)(flags | 0x800);
                    segment = (StringSegment)i.next();
                } else {
                    flags = (char)(flags | 0x400);
                    if (typeKind.isInterface()) {
                        flags = (char)(flags | 0x800);
                    }
                }
                if (segment.matches("static")) {
                    flags = (char)(flags | 8);
                    segment = (StringSegment)i.next();
                }
                if (segment.matches("abstract")) {
                    flags = (char)(flags | 4);
                    segment = (StringSegment)i.next();
                }
                if (segment.matches("final")) {
                    flags = (char)(flags | 2);
                    segment = (StringSegment)i.next();
                }
                if (segment.matches("deprecated")) {
                    flags = (char)(flags | 0x10);
                    segment = (StringSegment)i.next();
                }
                CompatibilityAccess access = null;
                if (segment.matches("exported")) {
                    access = CompatibilityAccess.EXPORTED;
                } else if (segment.matches("restricted")) {
                    access = CompatibilityAccess.RESTRICTED;
                } else if (segment.matches("concealed")) {
                    access = CompatibilityAccess.CONCEALED;
                }
                if (access == null) break;
                flags = (char)(flags | access.ordinal() + 1 << 5);
                segment = (StringSegment)i.next();
                CompatibilityAccess extension = access;
                switch (access) {
                    case EXPORTED: {
                        if (segment.matches("restricted")) {
                            extension = CompatibilityAccess.RESTRICTED;
                            break;
                        }
                        if (!segment.matches("concealed")) break;
                        extension = CompatibilityAccess.CONCEALED;
                        break;
                    }
                    case RESTRICTED: {
                        if (!segment.matches("concealed")) break;
                        extension = CompatibilityAccess.CONCEALED;
                    }
                }
                flags = (char)(flags | extension.ordinal() + 1 << 7);
                break;
            }
            case CONSTRUCTOR: {
                flags = '\u0001';
                if (offset == endOffset) {
                    return flags;
                }
                StringSegmentIterator i = new StringSegmentIterator(string, offset, endOffset, ',', StringSegmentIterator.Option.TRIM, StringSegmentIterator.Option.SENTINEL);
                StringSegment segment = (StringSegment)i.next();
                if (segment.matches(NO_FLAGS)) {
                    return flags;
                }
                if (segment.matches("deprecated")) {
                    flags = (char)(flags | 0x10);
                    segment = (StringSegment)i.next();
                }
                CompatibilityAccess access = null;
                if (segment.matches("exported")) {
                    access = CompatibilityAccess.EXPORTED;
                } else if (segment.matches("restricted")) {
                    access = CompatibilityAccess.RESTRICTED;
                } else if (segment.matches("concealed")) {
                    access = CompatibilityAccess.CONCEALED;
                }
                if (access == null) break;
                flags = (char)(flags | access.ordinal() + 1 << 5);
                segment = (StringSegment)i.next();
                Member.Escalation escalation = null;
                if (segment.matches("private")) {
                    escalation = Member.Escalation.PRIVATE;
                } else if (segment.matches("default")) {
                    escalation = Member.Escalation.DEFAULT;
                } else if (segment.matches("public")) {
                    escalation = Member.Escalation.PUBLIC;
                }
                if (escalation == null) break;
                flags = (char)(flags | escalation.ordinal() << 7);
                segment = (StringSegment)i.next();
                if (segment.matches("escalated")) {
                    flags = (char)(flags | 0x200);
                    segment = (StringSegment)i.next();
                }
                if (!segment.matches("suppressed")) break;
                flags = (char)(flags | 0x400);
                break;
            }
            case METHOD: {
                flags = '\u0001';
                if (offset == endOffset) {
                    return flags;
                }
                StringSegmentIterator i = new StringSegmentIterator(string, offset, endOffset, ',', StringSegmentIterator.Option.TRIM, StringSegmentIterator.Option.SENTINEL);
                StringSegment segment = (StringSegment)i.next();
                if (segment.matches(NO_FLAGS)) {
                    return flags;
                }
                if (segment.matches("static")) {
                    flags = (char)(flags | 8);
                    segment = (StringSegment)i.next();
                }
                if (segment.matches("abstract")) {
                    flags = (char)(flags | 4);
                    segment = (StringSegment)i.next();
                }
                if (segment.matches("final")) {
                    flags = (char)(flags | 2);
                    segment = (StringSegment)i.next();
                }
                if (segment.matches("deprecated")) {
                    flags = (char)(flags | 0x10);
                    segment = (StringSegment)i.next();
                }
                CompatibilityAccess access = null;
                if (segment.matches("exported")) {
                    access = CompatibilityAccess.EXPORTED;
                } else if (segment.matches("restricted")) {
                    access = CompatibilityAccess.RESTRICTED;
                } else if (segment.matches("concealed")) {
                    access = CompatibilityAccess.CONCEALED;
                }
                if (access == null) break;
                flags = (char)(flags | access.ordinal() + 1 << 5);
                segment = (StringSegment)i.next();
                Member.Escalation escalation = null;
                if (segment.matches("private")) {
                    escalation = Member.Escalation.PRIVATE;
                } else if (segment.matches("default")) {
                    escalation = Member.Escalation.DEFAULT;
                } else if (segment.matches("public")) {
                    escalation = Member.Escalation.PUBLIC;
                }
                if (escalation == null) break;
                flags = (char)(flags | escalation.ordinal() << 7);
                segment = (StringSegment)i.next();
                if (segment.matches("escalated")) {
                    flags = (char)(flags | 0x200);
                    segment = (StringSegment)i.next();
                }
                if (!segment.matches("suppressed")) break;
                flags = (char)(flags | 0x400);
                break;
            }
            case FIELD: {
                flags = '\u0001';
                if (offset == endOffset) {
                    return flags;
                }
                StringSegmentIterator i = new StringSegmentIterator(string, offset, endOffset, ',', StringSegmentIterator.Option.TRIM, StringSegmentIterator.Option.SENTINEL);
                StringSegment segment = (StringSegment)i.next();
                if (segment.matches(NO_FLAGS)) {
                    return flags;
                }
                if (segment.matches("static")) {
                    flags = (char)(flags | 8);
                    segment = (StringSegment)i.next();
                }
                if (segment.matches("final")) {
                    flags = (char)(flags | 2);
                    segment = (StringSegment)i.next();
                }
                if (segment.matches("deprecated")) {
                    flags = (char)(flags | 0x10);
                    segment = (StringSegment)i.next();
                }
                CompatibilityAccess access = null;
                if (segment.matches("exported")) {
                    access = CompatibilityAccess.EXPORTED;
                } else if (segment.matches("restricted")) {
                    access = CompatibilityAccess.RESTRICTED;
                } else if (segment.matches("concealed")) {
                    access = CompatibilityAccess.CONCEALED;
                }
                if (access == null) break;
                flags = (char)(flags | access.ordinal() + 1 << 5);
                segment = (StringSegment)i.next();
                Member.Escalation escalation = null;
                if (segment.matches("private")) {
                    escalation = Member.Escalation.PRIVATE;
                } else if (segment.matches("default")) {
                    escalation = Member.Escalation.DEFAULT;
                } else if (segment.matches("public")) {
                    escalation = Member.Escalation.PUBLIC;
                }
                if (escalation == null) break;
                flags = (char)(flags | escalation.ordinal() << 7);
                segment = (StringSegment)i.next();
                if (segment.matches("escalated")) {
                    flags = (char)(flags | 0x200);
                    segment = (StringSegment)i.next();
                }
                if (!segment.matches("suppressed")) break;
                flags = (char)(flags | 0x400);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected label " + (Object)((Object)kind));
            }
        }
        return flags;
    }

    final String flags() {
        if (this.flags == '\u0000') {
            return "confined";
        }
        StringBuilder builder = new StringBuilder();
        if (!this.is('\u0001')) {
            builder.append("confined,");
        }
        switch (this.getKind()) {
            case PACKAGE: {
                CompatibilityAccess access;
                Package packag = (Package)this;
                if (packag.isDeprecated()) {
                    builder.append("deprecated,");
                }
                if ((access = packag.getCompatibilityAccess('\u0005')) != null) {
                    builder.append((Object)access).append(',');
                }
                if (this.is('\u1000')) {
                    builder.append("has-exported,");
                }
                if (this.is('\u2000')) {
                    builder.append("has-restricted,");
                }
                if (this.is('\u4000')) {
                    builder.append("has-concealed,");
                }
                if (!this.is('\u8000')) break;
                builder.append("has-escalated,");
                break;
            }
            case TYPE: {
                CompatibilityAccess access;
                Type type = (Type)this;
                if (!this.is('\u0001')) {
                    builder.append("unexportable,");
                }
                if (type.isUnresolved()) {
                    builder.append("unresolved,");
                }
                if (this.is('\b')) {
                    builder.append("static,");
                }
                if (this.is('\u0004')) {
                    builder.append("abstract,");
                }
                if (this.is('\u0002')) {
                    builder.append("final,");
                }
                if (this.is('\u0010')) {
                    builder.append("deprecated,");
                }
                if (this.is('\u0200')) {
                    builder.append("jdk,");
                }
                if ((access = this.getCompatibilityAccess('\u0005')) == null) break;
                builder.append((Object)access).append(',');
                CompatibilityAccess extension = this.getCompatibilityAccess('\u0007');
                if (extension != access) {
                    builder.append((Object)extension).append(',');
                }
                if (this.is('\u1000')) {
                    builder.append("has-exported,");
                }
                if (this.is('\u2000')) {
                    builder.append("has-restricted,");
                }
                if (this.is('\u4000')) {
                    builder.append("has-concealed,");
                }
                if (!this.is('\u8000')) break;
                builder.append("has-escalated,");
                break;
            }
            case CONSTRUCTOR: {
                CompatibilityAccess access;
                Constructor constructor = (Constructor)this;
                if (constructor.isDeprecated()) {
                    builder.append("deprecated,");
                }
                if ((access = constructor.getCompatibilityAccess('\u0005')) == null) break;
                builder.append((Object)access).append(',');
                Member.Escalation escalation = constructor.getEscalation();
                if (escalation != Member.Escalation.NONE) {
                    builder.append(escalation.toLowerCase()).append(',');
                }
                if (constructor.isEscalated()) {
                    builder.append("escalated,");
                }
                if (!constructor.isSuppressed()) break;
                builder.append("suppressed,");
                break;
            }
            case METHOD: {
                CompatibilityAccess access;
                Method method = (Method)this;
                if (method.isStatic()) {
                    builder.append("static,");
                }
                if (method.isAbstract()) {
                    builder.append("abstract,");
                }
                if (method.isFinal()) {
                    builder.append("final,");
                }
                if (method.isDeprecated()) {
                    builder.append("deprecated,");
                }
                if ((access = method.getCompatibilityAccess('\u0005')) == null) break;
                builder.append((Object)access).append(',');
                Member.Escalation escalation = method.getEscalation();
                if (escalation != Member.Escalation.NONE) {
                    builder.append(escalation.toLowerCase()).append(',');
                }
                if (method.isEscalated()) {
                    builder.append("escalated,");
                }
                if (!method.isSuppressed()) break;
                builder.append("suppressed,");
                break;
            }
            case FIELD: {
                CompatibilityAccess access;
                Field field = (Field)this;
                if (field.isStatic()) {
                    builder.append("static,");
                }
                if (field.isFinal()) {
                    builder.append("final,");
                }
                if (field.isDeprecated()) {
                    builder.append("deprecated,");
                }
                if ((access = field.getCompatibilityAccess('\u0005')) == null) break;
                builder.append((Object)access).append(',');
                Member.Escalation escalation = field.getEscalation();
                if (escalation != Member.Escalation.NONE) {
                    builder.append(escalation.toLowerCase()).append(',');
                }
                if (field.isEscalated()) {
                    builder.append("escalated,");
                }
                if (!field.isSuppressed()) break;
                builder.append("suppressed,");
                break;
            }
        }
        if (builder.length() == 0) {
            return "";
        }
        if (builder.charAt(builder.length() - 1) == ',') {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    final boolean is(char flag) {
        return (this.flags & flag) == flag;
    }

    final boolean set(char flag, boolean value) {
        this.flags = value ? (char)(this.flags | flag) : (char)(this.flags & ~flag);
        return value;
    }

    final int is(char flag, char mask) {
        return (this.flags & mask << flag) >>> flag;
    }

    final void set(char flag, char mask, int value) {
        this.flags = (char)(this.flags & ~(mask << flag));
        this.flags = (char)(this.flags | value << flag);
    }

    CompatibilityAccess getCompatibilityAccess(char flag) {
        if (!this.is('\u0001')) {
            return null;
        }
        char mask = (char)(3 << flag);
        switch ((this.flags & mask) >>> flag) {
            case 0: {
                return null;
            }
            case 1: {
                return CompatibilityAccess.EXPORTED;
            }
            case 2: {
                return CompatibilityAccess.RESTRICTED;
            }
            case 3: {
                return CompatibilityAccess.CONCEALED;
            }
        }
        throw new IllegalStateException("unexpected flag value " + (this.flags & 3 << flag) + " at " + flag + " value");
    }

    void setAccess(char flag, CompatibilityAccess access) {
        char mask = (char)(3 << flag);
        this.flags = (char)(this.flags & ~mask);
        if (access != null) {
            this.flags = (char)(this.flags | access.ordinal() + 1 << flag);
        }
    }

    Element(boolean exportable, boolean deprecated, CompatibilityAccess access, String accessComment) {
        this.set('\u0001', exportable);
        this.set('\u0010', deprecated);
        this.setAccess('\u0005', access);
        this.accessComment = accessComment;
    }

    Element(char flags) {
        this.flags = flags = (char)(flags & 0xFFF);
        this.accessComment = null;
    }

    public ElementKind getKind() {
        return this.getName().getKind();
    }

    public ClassPathModel getModel() {
        return this.getParent().getModel();
    }

    public abstract Element getParent();

    public abstract Element getPackage();

    public abstract ElementName getName();

    public final String getSimpleName() {
        return this.getName().getSimpleName();
    }

    public final String getSourceName() {
        return this.getName().getSourceName();
    }

    public final String getQualifiedSourceName() {
        return this.getName().getQualifiedSourceName();
    }

    public boolean isExportable() {
        return this.is('\u0001');
    }

    public boolean isDeprecated() {
        return this.is('\u0010');
    }

    public CompatibilityAccess getReferenceAccess() {
        return CompatibilityAccess.mostExported(this.getCompatibilityAccess('\u0005'), this.getMemberAccess());
    }

    public CompatibilityAccess getMemberAccess() {
        if (this.containsExported()) {
            return CompatibilityAccess.EXPORTED;
        }
        if (this.containsRestricted()) {
            return CompatibilityAccess.RESTRICTED;
        }
        if (this.containsConcealed()) {
            return CompatibilityAccess.CONCEALED;
        }
        return null;
    }

    public abstract boolean containsExported();

    public abstract boolean containsRestricted();

    public abstract boolean containsConcealed();

    public boolean containsExportedOrRestricted() {
        return this.containsExported() || this.containsRestricted();
    }

    public boolean hasOrContainsExported() {
        return this.getReferenceAccess() == CompatibilityAccess.EXPORTED || this.containsExported();
    }

    public boolean hasOrContainsRestricted() {
        return this.getReferenceAccess() == CompatibilityAccess.RESTRICTED || this.containsRestricted();
    }

    public boolean hasOrContainsConcealed() {
        return this.getReferenceAccess() == CompatibilityAccess.CONCEALED || this.containsConcealed();
    }

    public boolean isExported() {
        return CompatibilityAccess.isExported(this.getReferenceAccess()) || this.containsExported();
    }

    public boolean isExportedOrRestricted() {
        return CompatibilityAccess.isExportedOrRestricted(this.getReferenceAccess()) || this.containsExportedOrRestricted();
    }

    public boolean isConcealedOrNull() {
        return CompatibilityAccess.isConcealedOrNull(this.getReferenceAccess()) && !this.containsExportedOrRestricted();
    }

    public boolean containsConsistentAccess() {
        int count = 0;
        if (this.containsExported()) {
            ++count;
        }
        if (this.containsRestricted()) {
            ++count;
        }
        if (this.containsConcealed()) {
            ++count;
        }
        if (this.containsEscalated()) {
            ++count;
        }
        return count <= 1;
    }

    public boolean hasOrContainsConsistentAccess() {
        int count = 0;
        if (this.hasOrContainsExported()) {
            ++count;
        }
        if (this.hasOrContainsRestricted()) {
            ++count;
        }
        if (this.hasOrContainsConcealed()) {
            ++count;
        }
        if (this.hasOrContainsEscalated()) {
            ++count;
        }
        return count <= 1;
    }

    public CompatibilityAccess getReferenceAccess(CompatibilityAccess restrictedAs) {
        CompatibilityAccess access = this.getReferenceAccess();
        return CompatibilityAccess.isRestricted(access) ? restrictedAs : access;
    }

    public CompatibilityAccess getMemberAccess(CompatibilityAccess restrictedAs) {
        CompatibilityAccess access = this.getMemberAccess();
        return CompatibilityAccess.isRestricted(access) ? restrictedAs : access;
    }

    public boolean containsExported(CompatibilityAccess restrictedAs) {
        return this.containsExported() || restrictedAs.isExported() && this.containsRestricted();
    }

    public boolean containsRestricted(CompatibilityAccess restrictedAs) {
        return restrictedAs.isRestricted() && this.containsRestricted();
    }

    public boolean containsConcealed(CompatibilityAccess restrictedAs) {
        return this.containsConcealed() || restrictedAs.isConcealed() && this.containsRestricted();
    }

    public boolean containsExportedOrRestricted(CompatibilityAccess restrictedAs) {
        return this.containsExported(restrictedAs) || this.containsRestricted(restrictedAs);
    }

    public boolean hasOrContainsExported(CompatibilityAccess restrictedAs) {
        return this.getReferenceAccess(restrictedAs) == CompatibilityAccess.EXPORTED || this.containsExported(restrictedAs);
    }

    public boolean hasOrContainsRestricted(CompatibilityAccess restrictedAs) {
        return this.getReferenceAccess(restrictedAs) == CompatibilityAccess.RESTRICTED || this.containsRestricted(restrictedAs);
    }

    public boolean hasOrContainsConcealed(CompatibilityAccess restrictedAs) {
        return this.getReferenceAccess(restrictedAs) == CompatibilityAccess.CONCEALED || this.containsConcealed(restrictedAs);
    }

    public boolean isExported(CompatibilityAccess restrictedAs) {
        return CompatibilityAccess.isExported(this.getReferenceAccess(restrictedAs)) || this.containsExported(restrictedAs);
    }

    public boolean isExportedOrRestricted(CompatibilityAccess restrictedAs) {
        return CompatibilityAccess.isExportedOrRestricted(this.getReferenceAccess(restrictedAs)) || this.containsExportedOrRestricted(restrictedAs);
    }

    public boolean isConcealedOrNull(CompatibilityAccess restrictedAs) {
        return CompatibilityAccess.isConcealedOrNull(this.getReferenceAccess(restrictedAs)) && !this.containsExportedOrRestricted(restrictedAs);
    }

    public boolean containsConsistentAccess(CompatibilityAccess restrictedAs) {
        int count = 0;
        if (this.containsExported(restrictedAs)) {
            ++count;
        }
        if (restrictedAs.isRestricted() && this.containsRestricted()) {
            ++count;
        }
        if (this.containsConcealed(restrictedAs)) {
            ++count;
        }
        if (this.containsEscalated()) {
            ++count;
        }
        return count <= 1;
    }

    public boolean hasOrContainsConsistentAccess(CompatibilityAccess restrictedAs) {
        int count = 0;
        if (this.hasOrContainsExported(restrictedAs)) {
            ++count;
        }
        if (this.hasOrContainsRestricted(restrictedAs)) {
            ++count;
        }
        if (this.hasOrContainsConcealed(restrictedAs)) {
            ++count;
        }
        if (this.hasOrContainsEscalated()) {
            ++count;
        }
        return count <= 1;
    }

    public boolean containsEscalated() {
        return this.is('\u8000');
    }

    public boolean hasOrContainsEscalated() {
        return this.containsEscalated();
    }

    public String getAccessComment() {
        return this.accessComment;
    }

    public Log getLog() {
        return this.getModel().getLog();
    }

    abstract void resolve();

    public boolean equals(Object that) {
        return that instanceof Element && this.getName().equals(((Element)that).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public int compareTo(Element that) {
        return this.getName().compareTo(that.getName());
    }

    public String toString() {
        return this.getKind().toLowerCase() + " " + this.getName() + "<" + this.flags() + ">";
    }
}

