/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import oracle.javatools.exports.classpath.Method;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.name.MethodName;

public class OverrideEquivalentMethod {
    private final MethodName name;
    private int layer;
    private Method incumbent;
    private Kind kind = Kind.EMPTY;

    OverrideEquivalentMethod(MethodName name) {
        this.name = name;
    }

    OverrideEquivalentMethod(Method method) {
        this.name = method.getName();
        this.collect(0, method);
    }

    public MethodName getName() {
        return this.name;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Method getMethod() {
        return this.incumbent;
    }

    public boolean isEmpty() {
        return this.kind == Kind.EMPTY;
    }

    public boolean isClass() {
        return this.kind == Kind.CLASS_CONCRETE || this.kind == Kind.CLASS_ABSTRACT;
    }

    public boolean isInterface() {
        return this.kind == Kind.INTERFACE_ABSTRACT || this.kind == Kind.DEFAULT;
    }

    public boolean isAbstract() {
        return this.kind == Kind.CLASS_ABSTRACT || this.kind == Kind.INTERFACE_ABSTRACT;
    }

    public boolean isConcrete() {
        return this.kind == Kind.CLASS_CONCRETE || this.kind == Kind.DEFAULT;
    }

    public boolean isDefault() {
        return this.kind == Kind.DEFAULT;
    }

    void collect(int layer, Method method) {
        if (this.kind != Kind.EMPTY && layer > this.layer) {
            return;
        }
        this.layer = layer;
        Type type = method.getType();
        Kind kind = type.isClass() ? (method.isAbstract() ? Kind.CLASS_ABSTRACT : Kind.CLASS_CONCRETE) : (method.isAbstract() ? Kind.INTERFACE_ABSTRACT : Kind.DEFAULT);
        switch (this.kind) {
            case EMPTY: {
                this.kind = kind;
                this.incumbent = method;
                break;
            }
            case CLASS_CONCRETE: {
                throw new IllegalStateException("add " + method + " blocked by " + this.incumbent);
            }
            case CLASS_ABSTRACT: {
                if (kind != Kind.CLASS_CONCRETE && kind != Kind.CLASS_ABSTRACT) break;
                throw new IllegalStateException("add class method after interface method: " + method + " after " + this.incumbent);
            }
            case DEFAULT: 
            case INTERFACE_ABSTRACT: {
                if (kind == Kind.CLASS_CONCRETE || kind == Kind.CLASS_ABSTRACT) {
                    throw new IllegalStateException("add class method after interface method: " + method + " after " + this.incumbent);
                }
                if (!type.isSubtypeOf(this.incumbent.getType())) break;
                this.incumbent = method;
                this.kind = kind;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected kind " + (Object)((Object)kind));
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof OverrideEquivalentMethod && this.incumbent.equals(((OverrideEquivalentMethod)object).incumbent);
    }

    public int hashCode() {
        return this.incumbent.hashCode();
    }

    public String toString() {
        return this.name.getHybridName() + ":{" + (this.incumbent != null ? this.incumbent.getName().getQualifiedHybridName() : "null") + '}';
    }

    public static enum Kind {
        EMPTY,
        CLASS_CONCRETE,
        CLASS_ABSTRACT,
        DEFAULT,
        INTERFACE_ABSTRACT;

    }
}

