/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import oracle.javatools.exports.common.Arrays;
import oracle.javatools.exports.common.StringSegment;

public class StringSegmentIterator
implements Iterator<StringSegment>,
Iterable<StringSegment> {
    public static final Option TRIM = Option.TRIM;
    public static final Option SENTINEL = Option.SENTINEL;
    private final String string;
    private final char delimiter;
    private final boolean trim;
    private final boolean sentinel;
    private final DefaultStringSegment segment;
    private final int stringEndOffset;
    private int pendingOffset;
    private int pendingDelimiterOffset;
    private int pendingEndOffset;
    private static final StringSegment SENTINEL_SEGMENT = new SentinelStringSegment();

    public StringSegmentIterator(String string, Option ... options) {
        this(string, 0, string.length(), ',', options);
    }

    public StringSegmentIterator(String string, char delimiter, Option ... options) {
        this(string, 0, string.length(), delimiter, options);
    }

    public StringSegmentIterator(StringSegment segment, char delimiter, Option ... options) {
        this(segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset(), delimiter, options);
    }

    public StringSegmentIterator(StringSegment segment, int offset, int endOffset, char delimiter, Option ... options) {
        this(segment.getBackingString(), offset + (offset >= 0 ? segment.getSegmentOffset() : segment.getSegmentEndOffset()), endOffset + (endOffset >= 0 ? segment.getSegmentOffset() : segment.getSegmentEndOffset()), delimiter, options);
    }

    public StringSegmentIterator(String string, int offset, int endOffset, char delimiter, Option ... options) {
        if (offset < 0) {
            offset += string.length();
        }
        if (endOffset < 0) {
            endOffset += string.length();
        }
        this.string = string;
        this.delimiter = delimiter;
        this.trim = Arrays.contains(options, TRIM);
        this.sentinel = Arrays.contains(options, SENTINEL);
        if (this.trim) {
            while (offset < endOffset) {
                if (!Character.isWhitespace(string.charAt(offset))) {
                    int i = endOffset - 1;
                    while (i > offset && Character.isWhitespace(string.charAt(i))) {
                        endOffset = i--;
                    }
                    break;
                }
                ++offset;
            }
        }
        this.stringEndOffset = endOffset;
        if (endOffset > offset) {
            this.pendingOffset = offset;
            int endOffset1 = this.string.indexOf(this.delimiter, offset);
            if (endOffset1 < 0 || endOffset1 >= this.stringEndOffset) {
                endOffset1 = this.stringEndOffset;
            }
            this.pendingDelimiterOffset = endOffset1;
            if (this.trim) {
                int i;
                for (i = endOffset1 - 1; i > offset && Character.isWhitespace(this.string.charAt(i)); --i) {
                }
                endOffset1 = i + 1;
            }
            this.pendingEndOffset = endOffset1;
        } else {
            this.pendingOffset = this.stringEndOffset + 1;
            this.pendingEndOffset = this.pendingDelimiterOffset = this.stringEndOffset;
        }
        this.segment = new DefaultStringSegment(string, this.pendingOffset, this.pendingDelimiterOffset, this.pendingEndOffset, this.sentinel);
    }

    private StringSegmentIterator(StringSegmentIterator iterator) {
        this.string = iterator.string;
        this.delimiter = iterator.delimiter;
        this.trim = iterator.trim;
        this.sentinel = iterator.sentinel;
        this.stringEndOffset = iterator.stringEndOffset;
        this.pendingOffset = iterator.pendingOffset;
        this.pendingDelimiterOffset = iterator.pendingDelimiterOffset;
        this.pendingEndOffset = iterator.pendingEndOffset;
        this.segment = new DefaultStringSegment(this.string, this.pendingOffset, this.pendingDelimiterOffset, this.pendingEndOffset, this.sentinel);
    }

    @Override
    public Iterator<StringSegment> iterator() {
        return new StringSegmentIterator(this);
    }

    @Override
    public boolean hasNext() {
        return this.segment.pendingOffset <= this.stringEndOffset || this.segment.pendingSentinel;
    }

    @Override
    public StringSegment next() {
        int offset;
        if (this.segment.pendingOffset > this.stringEndOffset) {
            if (this.segment.pendingSentinel) {
                this.segment.pendingSentinel = false;
                return SENTINEL_SEGMENT;
            }
            throw new NoSuchElementException();
        }
        this.segment.currentOffset = this.segment.pendingOffset;
        this.segment.currentEndOffset = this.segment.pendingEndOffset;
        if (this.trim) {
            for (offset = this.segment.pendingDelimiterOffset + 1; offset < this.stringEndOffset && Character.isWhitespace(this.string.charAt(offset)); ++offset) {
            }
        }
        this.segment.pendingOffset = offset;
        int endOffset = this.string.indexOf(this.delimiter, offset);
        if (endOffset < 0 || endOffset >= this.stringEndOffset) {
            endOffset = this.stringEndOffset;
        }
        this.segment.pendingDelimiterOffset = endOffset;
        if (this.trim) {
            int i;
            for (i = endOffset - 1; i > offset && Character.isWhitespace(this.string.charAt(i)); --i) {
            }
            endOffset = i + 1;
        }
        this.segment.pendingEndOffset = endOffset;
        return this.segment;
    }

    public StringSegment remainder() {
        if (this.segment.pendingOffset > this.stringEndOffset) {
            if (this.segment.pendingSentinel) {
                this.segment.pendingSentinel = false;
                return SENTINEL_SEGMENT;
            }
            throw new NoSuchElementException();
        }
        this.segment.currentOffset = this.segment.pendingOffset;
        this.segment.currentEndOffset = this.stringEndOffset;
        this.segment.pendingOffset = this.stringEndOffset + 1;
        this.segment.pendingEndOffset = (this.segment.pendingDelimiterOffset = this.stringEndOffset);
        return this.segment;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class SentinelStringSegment
    implements StringSegment {
        private SentinelStringSegment() {
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public char charAt(int offset) {
            throw new StringIndexOutOfBoundsException();
        }

        @Override
        public boolean isWhitespace(int offset) {
            return false;
        }

        @Override
        public int indexOf(char c) {
            return -1;
        }

        @Override
        public int indexOf(char c, int offset) {
            return -1;
        }

        @Override
        public int lastIndexOf(char c) {
            return -1;
        }

        @Override
        public int lastIndexOf(char c, int offset) {
            return -1;
        }

        @Override
        public boolean matches(String string) {
            return false;
        }

        @Override
        public boolean matches(String ... strings) {
            return false;
        }

        @Override
        public boolean matches(String string, int offset, int endOffset) {
            return false;
        }

        @Override
        public boolean matchesIgnoreCase(String string) {
            return false;
        }

        @Override
        public boolean matchesIgnoreCase(String ... strings) {
            return false;
        }

        @Override
        public boolean matchesIgnoreCase(String string, int offset, int endOffset) {
            return false;
        }

        @Override
        public boolean startsWith(String string) {
            return false;
        }

        @Override
        public boolean endsWith(String string) {
            return false;
        }

        @Override
        public boolean isSentinel() {
            return true;
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public String toString(int offset) {
            return "";
        }

        @Override
        public String toString(int offset, int endOffset) {
            return "";
        }

        @Override
        public int toInteger() {
            throw new NumberFormatException();
        }

        @Override
        public int toInteger(int radix) {
            throw new NumberFormatException();
        }

        @Override
        public int toNatural() {
            return -1;
        }

        @Override
        public int toNatural(int radix) {
            return -1;
        }

        @Override
        public <E extends Enum<E>> E toEnum(Class<E> type) {
            return null;
        }

        @Override
        public <E extends Enum<E>> E toEnumIgnoreCase(Class<E> type) {
            return null;
        }

        @Override
        public StringBuilder append(StringBuilder builder) {
            return builder;
        }

        @Override
        public String getBackingString() {
            return "";
        }

        @Override
        public int getSegmentOffset() {
            return 0;
        }

        @Override
        public int getSegmentEndOffset() {
            return 0;
        }
    }

    private static class DefaultStringSegment
    implements StringSegment {
        private final String string;
        private int pendingOffset;
        private int pendingDelimiterOffset;
        private int pendingEndOffset;
        private boolean pendingSentinel;
        private int currentOffset = -1;
        private int currentEndOffset = -1;
        private static final Map<Object, Object[]> ENUM_CONSTANTS = new HashMap<Object, Object[]>();

        public DefaultStringSegment(String string, int pendingOffset, int pendingDelimiterOffset, int pendingEndOffset, boolean sentinel) {
            this.string = string;
            this.pendingOffset = pendingOffset;
            this.pendingDelimiterOffset = pendingDelimiterOffset;
            this.pendingEndOffset = pendingEndOffset;
            this.pendingSentinel = sentinel;
        }

        @Override
        public int getLength() {
            return this.currentEndOffset - this.currentOffset;
        }

        @Override
        public char charAt(int offset) {
            return this.string.charAt(offset += offset >= 0 ? this.currentOffset : this.currentEndOffset);
        }

        @Override
        public boolean isWhitespace(int offset) {
            return Character.isWhitespace(this.string.charAt(offset += offset >= 0 ? this.currentOffset : this.currentEndOffset));
        }

        @Override
        public int indexOf(char c) {
            int index = this.string.indexOf(c, this.currentOffset);
            return index < this.currentEndOffset ? index - this.currentOffset : -1;
        }

        @Override
        public int indexOf(char c, int offset) {
            int index = this.string.indexOf(c, offset += offset >= 0 ? this.currentOffset : this.currentEndOffset);
            return index < this.currentEndOffset ? index - this.currentOffset : -1;
        }

        @Override
        public int lastIndexOf(char c) {
            int index = this.string.lastIndexOf(c, this.currentEndOffset - 1);
            return index >= this.currentOffset - this.currentOffset ? index : -1;
        }

        @Override
        public int lastIndexOf(char c, int offset) {
            int index = this.string.lastIndexOf(c, offset += offset >= 0 ? this.currentOffset : this.currentEndOffset);
            return index >= this.currentOffset - this.currentOffset ? index : -1;
        }

        @Override
        public boolean matches(String string) {
            int length = string.length();
            if (length != this.currentEndOffset - this.currentOffset) {
                return false;
            }
            return string.regionMatches(0, this.string, this.currentOffset, length);
        }

        @Override
        public boolean matches(String ... strings) {
            for (String string : strings) {
                if (!this.matches(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matches(String string, int offset, int endOffset) {
            int length;
            if (offset < 0) {
                offset += string.length();
            }
            if (endOffset < 0) {
                endOffset += string.length();
            }
            if ((length = endOffset - offset) != this.currentEndOffset - this.currentOffset) {
                return false;
            }
            return string.regionMatches(offset, this.string, this.currentOffset, length);
        }

        @Override
        public boolean matchesIgnoreCase(String string) {
            int length = string.length();
            if (length != this.currentEndOffset - this.currentOffset) {
                return false;
            }
            return string.regionMatches(true, 0, this.string, this.currentOffset, length);
        }

        @Override
        public boolean matchesIgnoreCase(String ... strings) {
            for (String string : strings) {
                if (!this.matchesIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matchesIgnoreCase(String string, int offset, int endOffset) {
            int length;
            if (offset < 0) {
                offset += string.length();
            }
            if (endOffset < 0) {
                endOffset += string.length();
            }
            if ((length = endOffset - offset) != this.currentEndOffset - this.currentOffset) {
                return false;
            }
            return string.regionMatches(true, offset, this.string, this.currentOffset, length);
        }

        @Override
        public boolean startsWith(String string) {
            return string.regionMatches(0, this.string, this.currentOffset, string.length());
        }

        @Override
        public boolean endsWith(String string) {
            int length = string.length();
            return string.regionMatches(0, this.string, this.currentEndOffset - length, length);
        }

        @Override
        public boolean isSentinel() {
            return false;
        }

        @Override
        public String toString() {
            return this.currentOffset < this.currentEndOffset ? this.string.substring(this.currentOffset, this.currentEndOffset) : "";
        }

        @Override
        public String toString(int offset) {
            return this.toString(offset, this.currentEndOffset);
        }

        @Override
        public String toString(int offset, int endOffset) {
            return offset < (endOffset += endOffset >= 0 ? this.currentOffset : this.currentEndOffset) ? this.string.substring(offset += offset >= 0 ? this.currentOffset : this.currentEndOffset, endOffset) : "";
        }

        @Override
        public int toInteger() {
            return this.toInteger(10);
        }

        @Override
        public int toInteger(int radix) {
            if (radix < 2) {
                throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
            }
            if (radix > 36) {
                throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
            }
            int length = this.currentEndOffset - this.currentOffset;
            if (length <= 0) {
                throw new NumberFormatException("For input string: \"" + this.toString() + "\"");
            }
            boolean negative = false;
            int limit = -2147483647;
            int i = this.currentOffset;
            char firstChar = this.string.charAt(i);
            if (firstChar < '0') {
                if (length == 1) {
                    throw new NumberFormatException("For input string: \"" + this.toString() + "\"");
                }
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw new NumberFormatException("For input string: \"" + this.toString() + "\"");
                }
                ++i;
            }
            int multmin = limit / radix;
            int result = 0;
            while (i < this.currentEndOffset) {
                int digit;
                if ((digit = Character.digit(this.string.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException("For input string: \"" + this.toString() + "\"");
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input string: \"" + this.toString() + "\"");
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException("For input string: \"" + this.toString() + "\"");
                }
                result -= digit;
            }
            return negative ? result : -result;
        }

        @Override
        public int toNatural() {
            return this.toNatural(10);
        }

        @Override
        public int toNatural(int radix) {
            if (radix < 2) {
                throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
            }
            if (radix > 36) {
                throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
            }
            int length = this.currentEndOffset - this.currentOffset;
            if (length <= 0) {
                return -1;
            }
            int limit = -2147483647;
            int multmin = limit / radix;
            int result = 0;
            for (int i = this.currentOffset; i < this.currentEndOffset; ++i) {
                int digit = Character.digit(this.string.charAt(i), radix);
                if (digit < 0 || result < multmin) {
                    return -1;
                }
                if ((result *= radix) < limit + digit) {
                    return -1;
                }
                result -= digit;
            }
            return -result;
        }

        private static synchronized <E extends Enum<E>> E[] getEnumConstants(Class<E> type) {
            Enum[] values = (Enum[])ENUM_CONSTANTS.get(type);
            if (values == null) {
                values = (Enum[])type.getEnumConstants();
                ENUM_CONSTANTS.put(type, values);
            }
            return values;
        }

        @Override
        public <E extends Enum<E>> E toEnum(Class<E> type) {
            for (Enum e : DefaultStringSegment.getEnumConstants(type)) {
                String name = e.toString();
                int length = name.length();
                if (length != this.currentEndOffset - this.currentOffset || !name.regionMatches(0, this.string, this.currentOffset, length)) continue;
                return (E)e;
            }
            return null;
        }

        @Override
        public <E extends Enum<E>> E toEnumIgnoreCase(Class<E> type) {
            for (Enum e : DefaultStringSegment.getEnumConstants(type)) {
                String name = e.toString();
                int length = name.length();
                if (length != this.currentEndOffset - this.currentOffset || !name.regionMatches(true, 0, this.string, this.currentOffset, length)) continue;
                return (E)e;
            }
            return null;
        }

        @Override
        public StringBuilder append(StringBuilder builder) {
            builder.append(this.string, this.currentOffset, this.currentEndOffset);
            return builder;
        }

        @Override
        public String getBackingString() {
            return this.string;
        }

        @Override
        public int getSegmentOffset() {
            return this.currentOffset;
        }

        @Override
        public int getSegmentEndOffset() {
            return this.currentEndOffset;
        }
    }

    public static enum Option {
        TRIM,
        SENTINEL;

    }
}

