/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.common;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class UnmodifiableArrayWrapper<E>
implements List<E> {
    private final E[] values;
    private int offset;
    private int length;

    public UnmodifiableArrayWrapper(E ... values) {
        this.values = values;
        this.offset = 0;
        this.length = values.length;
    }

    public UnmodifiableArrayWrapper(E[] values, int from, int to) {
        if (from > values.length) {
            throw new IndexOutOfBoundsException();
        }
        if (to > values.length) {
            throw new IndexOutOfBoundsException();
        }
        if (from > to) {
            throw new IndexOutOfBoundsException("from > to");
        }
        this.values = values;
        this.offset = from;
        this.length = to - from;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean contains(Object e) {
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            if (!Objects.equals(e, this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int next;
            {
                this.next = UnmodifiableArrayWrapper.this.offset;
            }

            @Override
            public boolean hasNext() {
                return this.next < UnmodifiableArrayWrapper.this.offset + UnmodifiableArrayWrapper.this.length;
            }

            @Override
            public E next() {
                if (this.next >= UnmodifiableArrayWrapper.this.offset + UnmodifiableArrayWrapper.this.length) {
                    throw new NoSuchElementException();
                }
                return UnmodifiableArrayWrapper.this.values[this.next++];
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.length];
        System.arraycopy(this.values, this.offset, array, 0, this.length);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length < this.length) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.length);
        }
        for (int i = 0; i < this.length; ++i) {
            array[i] = this.values[this.offset + i];
        }
        if (array.length > this.length) {
            array[this.length] = null;
        }
        return array;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object item : c) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        return this.values[this.offset + index];
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object e) {
        for (int i = this.offset; i < this.length; ++i) {
            if (!Objects.equals(e, this.values[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object e) {
        for (int i = this.length - 1; i >= this.offset; --i) {
            if (!Objects.equals(e, this.values[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        return new ListIterator<E>(){
            private int next;
            {
                this.next = UnmodifiableArrayWrapper.this.offset + index;
            }

            @Override
            public boolean hasNext() {
                return this.next < UnmodifiableArrayWrapper.this.offset + UnmodifiableArrayWrapper.this.length;
            }

            @Override
            public E next() {
                if (this.next >= UnmodifiableArrayWrapper.this.offset + UnmodifiableArrayWrapper.this.length) {
                    throw new NoSuchElementException();
                }
                return UnmodifiableArrayWrapper.this.values[this.next++];
            }

            @Override
            public boolean hasPrevious() {
                return this.next > UnmodifiableArrayWrapper.this.offset;
            }

            @Override
            public E previous() {
                if (this.next == UnmodifiableArrayWrapper.this.offset) {
                    throw new NoSuchElementException();
                }
                return UnmodifiableArrayWrapper.this.values[--this.next];
            }

            @Override
            public int nextIndex() {
                return this.next - UnmodifiableArrayWrapper.this.offset;
            }

            @Override
            public int previousIndex() {
                return this.next - UnmodifiableArrayWrapper.this.offset - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<E> subList(int from, int to) {
        return new UnmodifiableArrayWrapper<E>(this.values, this.offset + from, this.offset + to);
    }
}

