/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.file;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import oracle.javatools.exports.file.Paths;

public final class PathKey {
    private final Path path;
    private final String entry;
    private int hash;

    public PathKey(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        FileSystem fileSystem = path.getFileSystem();
        if ("jar".equals(fileSystem.provider().getScheme())) {
            this.path = java.nio.file.Paths.get(path.getFileSystem().toString(), new String[0]);
            this.entry = path.getNameCount() > 0 ? path.toString() : "/";
        } else {
            this.path = path;
            this.entry = "";
        }
    }

    public PathKey(Path path, String entry) {
        if (path == null) {
            throw new NullPointerException("path == null");
        }
        if (path.getFileSystem() != FileSystems.getDefault()) {
            throw new IllegalArgumentException("path file system not default");
        }
        if (entry == null) {
            throw new NullPointerException("entry == null");
        }
        this.path = path;
        this.entry = entry;
    }

    public Path getPath() throws IOException {
        return this.entry.isEmpty() ? this.path : FileSystems.newFileSystem(this.path, null).getPath(this.entry, new String[0]);
    }

    public Path getRootPath() {
        return this.path;
    }

    public String getEntry() {
        return this.entry;
    }

    public String relativize(Path basePath) {
        String head = basePath != null && basePath.getNameCount() > 0 && this.path.startsWith(basePath) ? Paths.relativize(this.path, basePath) : this.path.toString();
        return this.entry.isEmpty() ? head : head + this.path.getFileSystem().getSeparator() + this.entry;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PathKey)) {
            return false;
        }
        PathKey that = (PathKey)object;
        return this.path.equals(that.path) && this.entry.equals(that.entry);
    }

    public int hashCode() {
        int hash = this.hash;
        if (hash != 0) {
            return hash;
        }
        hash = this.path.hashCode();
        if (!this.entry.isEmpty()) {
            hash = 31 * hash + this.entry.hashCode();
        }
        this.hash = hash;
        return this.hash;
    }

    public String toString() {
        return this.entry.isEmpty() ? this.path.toString() : this.path.toString() + this.path.getFileSystem().getSeparator() + this.entry;
    }
}

