/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.message;

import java.io.File;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.logging.Level;
import oracle.ide.net.URLKey;
import oracle.javatools.exports.common.ObjectCache;
import oracle.javatools.exports.file.PathKey;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Severity;
import oracle.javatools.exports.message.Tag;
import oracle.javatools.exports.name.ElementName;

public class Message {
    private final long time;
    private final Severity severity;
    private final String id;
    private final String format;
    private final Object[] arguments;
    private Tag[] tags;
    private static final EnumMap<Severity, Tag[]> severityPool = Message.severityPool();
    public static final long TIME_ZERO_NANO = System.nanoTime();
    private static final Message NULL_MESSAGE;
    private static final ObjectCache<Object, Tag> filePool;
    private static final ObjectCache<Object, Tag> scopePool;
    private static final ObjectCache<Object, Tag> elementPool;
    public static final String EXCEPTION_TAG = "exception";
    public static final String FILE_TAG = "file";
    public static final String SCOPE_TAG = "scope";
    public static final String ELEMENT_TAG = "element";

    private static EnumMap<Severity, Tag[]> severityPool() {
        EnumMap<Severity, Tag[]> pool = new EnumMap<Severity, Tag[]>(Severity.class);
        for (Severity severity : (Severity[])Severity.class.getEnumConstants()) {
            Tag tag = new Tag("severity", (Object)severity);
            pool.put(severity, new Tag[]{tag});
        }
        return pool;
    }

    static Message nullMessage() {
        return NULL_MESSAGE;
    }

    public Message(Severity severity, String id, String format, Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            if (!(argument instanceof Path) || ((Path)argument).getFileSystem() == FileSystems.getDefault()) continue;
            arguments[i] = new PathKey((Path)argument);
        }
        this.time = System.nanoTime();
        this.severity = severity;
        this.format = format;
        this.id = id;
        this.tags = severityPool.get((Object)severity);
        this.arguments = arguments;
    }

    public long getTime() {
        return this.time;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Level getLevel() {
        return this.severity.getLevel();
    }

    public String getId() {
        return this.id;
    }

    public String getFormat() {
        return this.format;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getMessage() {
        return String.format(this.format, this.arguments);
    }

    public Message tag(Tag tag) {
        if (this == NULL_MESSAGE) {
            return this;
        }
        int count = this.tags.length;
        this.tags = new Tag[count + 1];
        System.arraycopy(this.tags, 0, this.tags, 0, count);
        this.tags[count] = tag;
        return this;
    }

    public Message tag(String id, Object value) {
        if (this == NULL_MESSAGE) {
            return this;
        }
        return this.tag(new Tag(id, value));
    }

    public Message tags(Tag ... newTags) {
        if (this == NULL_MESSAGE) {
            return this;
        }
        int count = this.tags.length;
        int newCount = newTags.length;
        this.tags = new Tag[count + newCount];
        System.arraycopy(this.tags, 0, this.tags, 0, count);
        System.arraycopy(newTags, 0, this.tags, count, newCount);
        return this;
    }

    public Tag getTag(String id) {
        int i = this.tags.length;
        while (--i >= 0) {
            Tag tag = this.tags[i];
            if (!id.equals(tag.getId())) continue;
            return tag;
        }
        return null;
    }

    public <T> T getValue(String id, Class<T> type) {
        int i = this.tags.length;
        while (--i >= 0) {
            Tag tag = this.tags[i];
            if (!id.equals(tag.getId())) continue;
            return type.cast(tag.getValue());
        }
        return null;
    }

    public Object getValue(String id) {
        int i = this.tags.length;
        while (--i >= 0) {
            Tag tag = this.tags[i];
            if (!id.equals(tag.getId())) continue;
            return tag.getValue();
        }
        return null;
    }

    public Message exception(Throwable exception) {
        if (this == NULL_MESSAGE) {
            return this;
        }
        return this.tag(new Tag(EXCEPTION_TAG, exception));
    }

    public Message file(File file) {
        if (this == NULL_MESSAGE) {
            return this;
        }
        return this.tag(filePool.cache((Object)file, v -> new Tag(FILE_TAG, file)));
    }

    public Message file(URL url) {
        if (this == NULL_MESSAGE) {
            return this;
        }
        URLKey key = URLKey.getInstance(url);
        return this.tag(filePool.cache((Object)key, v -> new Tag(FILE_TAG, key)));
    }

    public Message file(Path path) {
        if (this == NULL_MESSAGE) {
            return this;
        }
        PathKey key = new PathKey(path);
        return this.tag(filePool.cache((Object)path, v -> new Tag(FILE_TAG, key)));
    }

    public Message scope(Object scope) {
        if (this == NULL_MESSAGE) {
            return this;
        }
        Object s = scope instanceof URL ? URLKey.getInstance((URL)scope) : (scope instanceof Path ? new PathKey((Path)scope) : scope);
        return this.tag(scopePool.cache(scope, v -> new Tag(SCOPE_TAG, s)));
    }

    public Message element(ElementName element) {
        if (this == NULL_MESSAGE) {
            return this;
        }
        return this.tag(elementPool.cache((Object)element, v -> new Tag(ELEMENT_TAG, element)));
    }

    public Message element(Object element) {
        if (this == NULL_MESSAGE) {
            return this;
        }
        return this.tag(elementPool.cache(element, v -> new Tag(ELEMENT_TAG, element)));
    }

    public String toString() {
        return String.valueOf((Object)this.severity) + ' ' + this.id;
    }

    static {
        for (Severity severity : (Severity[])Severity.class.getEnumConstants()) {
            Tag tag = new Tag("severity", (Object)severity);
            severityPool.put(severity, new Tag[]{tag});
        }
        NULL_MESSAGE = new Message(Log.NOTE, "?", "", new Object[0]){

            @Override
            public Message tag(Tag tag) {
                return this;
            }

            @Override
            public Message tag(String id, Object value) {
                return this;
            }

            @Override
            public Message tags(Tag ... tag) {
                return this;
            }
        };
        filePool = ObjectCache.synchronizedCache();
        scopePool = ObjectCache.synchronizedCache();
        elementPool = ObjectCache.synchronizedCache();
    }
}

