/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.name;

import java.io.IOException;
import java.io.Writer;
import oracle.javatools.exports.common.Arrays;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.NameFormat;
import oracle.javatools.exports.name.TypeName;

public final class MethodName
extends MemberName {
    private final String methodName;
    private final TypeName[] parameters;
    private final boolean varargs;
    private int hash;

    MethodName(TypeName parent, String methodName, TypeName[] parameters, boolean varargs) {
        super(parent);
        assert (!Arrays.contains(parameters, null)) : parent.getQualifiedHybridName() + Arrays.toString(parameters);
        assert (!varargs || parameters.length > 0 && parameters[parameters.length - 1].isArray()) : parent.getQualifiedHybridName() + Arrays.toString(parameters);
        this.methodName = methodName;
        this.parameters = parameters.length > 0 ? parameters : TypeName.EMPTY_ARRAY;
        this.varargs = varargs;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.METHOD;
    }

    @Override
    public int getArity() {
        return this.parameters.length;
    }

    @Override
    public boolean isVariableArity() {
        return this.varargs;
    }

    @Override
    public boolean isFixedArity() {
        return !this.varargs;
    }

    @Override
    public TypeName[] getParameters() {
        return this.parameters;
    }

    @Override
    public String getSimpleName() {
        return this.methodName;
    }

    @Override
    public String getSourceName() {
        StringBuilder builder = new StringBuilder(this.methodName.length() + this.getParametersLength(this.parameters, this.varargs));
        return this.appendSourceName(builder).toString();
    }

    @Override
    public StringBuilder appendSourceName(StringBuilder builder) {
        builder.append(this.methodName);
        return this.appendParameters(builder, NameFormat.SOURCE, this.parameters, this.varargs);
    }

    @Override
    public void writeSourceName(Writer writer) throws IOException {
        writer.write(this.methodName);
        this.writeParameters(writer, NameFormat.SOURCE, this.parameters, this.varargs);
    }

    @Override
    public String getQualifiedSourceName() {
        StringBuilder builder = new StringBuilder(this.getType().getQualifiedNamePrefixLength() + this.methodName.length() + this.getParametersLength(this.parameters, this.varargs));
        this.getType().appendQualifiedSourceNamePrefix(builder);
        return this.appendSourceName(builder).toString();
    }

    @Override
    public String getBinaryName() {
        return this.appendBinaryName(new StringBuilder(this.methodName.length() + this.getParametersLength(this.parameters, this.varargs))).toString();
    }

    @Override
    public StringBuilder appendBinaryName(StringBuilder builder) {
        builder.append(this.methodName);
        return this.appendParameters(builder, NameFormat.BINARY, this.parameters, this.varargs);
    }

    @Override
    public void writeBinaryName(Writer writer) throws IOException {
        writer.write(this.methodName);
        this.writeParameters(writer, NameFormat.BINARY, this.parameters, this.varargs);
    }

    @Override
    public String getQualifiedBinaryName() {
        StringBuilder builder = new StringBuilder(this.getType().getQualifiedNamePrefixLength() + this.methodName.length() + this.getParametersLength(this.parameters, this.varargs));
        this.getType().appendQualifiedBinaryNamePrefix(builder);
        return this.appendBinaryName(builder).toString();
    }

    @Override
    public String getHybridName() {
        return this.appendHybridName(new StringBuilder(this.methodName.length() + this.getHybridParametersLength(this.parameters, this.varargs))).toString();
    }

    @Override
    public StringBuilder appendHybridName(StringBuilder builder) {
        builder.append(this.methodName);
        return this.appendParameters(builder, NameFormat.HYBRID, this.parameters, this.varargs);
    }

    @Override
    public String getQualifiedHybridName() {
        StringBuilder builder = new StringBuilder(this.getType().getQualifiedHybridNamePrefixLength() + this.methodName.length() + this.getHybridParametersLength(this.parameters, this.varargs));
        this.getType().appendQualifiedHybridNamePrefix(builder);
        return this.appendHybridName(builder).toString();
    }

    @Override
    public void writeHybridName(Writer writer) throws IOException {
        writer.write(this.methodName);
        this.writeParameters(writer, NameFormat.HYBRID, this.parameters, this.varargs);
    }

    @Override
    public final int compareToUnqualified(MemberName that) {
        switch (that.getKind()) {
            case CONSTRUCTOR: {
                return 1;
            }
            case METHOD: {
                int comparison = this.methodName.compareTo(that.getSimpleName());
                if (comparison != 0) {
                    return comparison;
                }
                return this.compareParameters(this.getParameters(), that.getParameters(), this.varargs, ((MethodName)that).varargs);
            }
            case FIELD: {
                int comparison = this.methodName.compareTo(that.getSimpleName());
                return comparison != 0 ? comparison : 1;
            }
        }
        throw new IllegalStateException("unexpected kind " + (Object)((Object)that.getKind()));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MethodName)) {
            return false;
        }
        MethodName that = (MethodName)object;
        if (this.parameters.length != that.parameters.length) {
            return false;
        }
        if (!this.getParent().equals(that.getParent())) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i].equals(that.parameters[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.getParent().hashCode() * 31 + this.methodName.hashCode();
        for (TypeName parameter : this.parameters) {
            this.hash = this.hash * 31 + parameter.hashCode();
        }
        return this.hash;
    }
}

