/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.uses;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.uses.TypeOrMemberUses;

public class MemberUses
implements TypeOrMemberUses {
    private final ElementKind kind;
    private final boolean modelled;
    private final MemberName migratedTo;
    private short references;
    private short workspaces;
    private Set<TypeName> migratedFrom = Collections.emptySet();

    MemberUses(ElementKind kind, boolean modelled, MemberName migratedTo) {
        this.kind = kind;
        this.modelled = modelled;
        this.migratedTo = migratedTo;
    }

    void addReferences(short references) {
        this.references = (short)(this.references + references);
        this.workspaces = (short)(this.workspaces + 1);
    }

    void addMigratedFrom(TypeName type) {
        switch (this.migratedFrom.size()) {
            case 0: {
                this.migratedFrom = Collections.singleton(type);
                break;
            }
            case 1: {
                this.migratedFrom = new HashSet<TypeName>(this.migratedFrom);
            }
            default: {
                this.migratedFrom.add(type);
            }
        }
    }

    public ElementKind getKind() {
        return this.kind;
    }

    @Override
    public boolean isModelled() {
        return this.modelled;
    }

    @Override
    public short getReferences() {
        return this.references;
    }

    @Override
    public short getWorkspaces() {
        return this.workspaces;
    }

    public MemberName getMigratedTo() {
        return this.migratedTo;
    }

    public Iterable<TypeName> getMigratedFrom() {
        return this.migratedFrom;
    }

    @Override
    public String getLabel() {
        return this.kind.toLowerCase();
    }

    public String toString() {
        return String.format("%d reference%s, %d workspace%s", this.getReferences(), MemberUses.s(this.getReferences()), this.getWorkspaces(), MemberUses.s(this.getWorkspaces()));
    }

    private static String s(int i) {
        return i == 1 ? "" : "s";
    }
}

