/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.wizard.InstallDBAUserDialog;

public class InstallVerifySchemaDialog
extends InstallDBAUserDialog {
    private static final String NEWLINE = "\n";
    private static final String YES = "YES";
    private Map<String, String> m_usersMap;
    private String m_schemaVersion;
    private String m_url;
    private boolean m_isRoot;
    private Version m_dbVersion;

    public InstallVerifySchemaDialog() {
        super(RestArb.getString("VERIFY_ORDS_SCHEMA"), RestArb.getString("VERIFY_SCHEMA_DBA_PRIV_DESCRIP"), "install_verify_schema_dba_credentials_html");
    }

    public InstallVerifySchemaDialog(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public boolean checkSchema(Component component, Properties properties) {
        this.m_connProps = properties;
        this.m_url = InstallDBUtils.getUrl(properties);
        return this.runDialog(component);
    }

    public String getSchemaVersion() {
        return this.m_schemaVersion;
    }

    public Version getDBVersion() {
        return this.m_dbVersion;
    }

    public boolean existCommonPublicUser() {
        return this.isCommonUser("ORDS_METADATA");
    }

    public boolean existCommonMetadataUser() {
        return this.isCommonUser("ORDS_METADATA");
    }

    public boolean isCDBRoot() {
        return this.m_isRoot;
    }

    @Override
    protected boolean validInfo() {
        if (super.validInfo()) {
            return this.verifySchemaVersion();
        }
        return false;
    }

    private boolean isCommonUser(String string) {
        String string2;
        return this.m_usersMap != null && this.m_usersMap.containsKey(string) && YES.equals(string2 = this.m_usersMap.get(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifySchemaVersion() {
        this.m_usersMap = null;
        this.m_isRoot = false;
        String string = null;
        String string2 = null;
        String string3 = this.m_connProps.getProperty("db.connectionType");
        if ("tns".equals(string3)) {
            string = System.getProperty("oracle.net.tns_admin");
            string2 = this.m_connProps.getProperty("db.tnsDirectory");
            if (InstallUtils.nullOrEmpty(string) || !string2.equalsIgnoreCase(string)) {
                System.setProperty("oracle.net.tns_admin", string2);
            }
        }
        boolean bl = false;
        Connection connection = null;
        String string4 = InstallDBUtils.getDBAUsername(this.getUsername());
        try {
            connection = DriverManager.getConnection(this.m_url, string4, new String(this.getPassword()));
            this.m_dbVersion = RaptorVersionTracker.getDbVersion((Connection)connection);
            if (this.m_dbVersion == null) {
                this.getErrMsg().append(NEWLINE).append(RestArb.getString("ERROR_NO_VERSION"));
            } else {
                int n = this.m_dbVersion.toIntArray()[0];
                if (n < 11) {
                    this.getErrMsg().append(NEWLINE).append(RestArb.format("ERROR_UNSUPPORTED_DB", this.m_dbVersion.toString()));
                } else {
                    String[] stringArray = new String[]{"ORDS_METADATA", "ORDS_PUBLIC_USER"};
                    if (n == 11) {
                        this.m_usersMap = InstallDBUtils.getUsersStatus(connection, stringArray);
                        bl = this.canInstallOrUpgrade(this.m_usersMap, false);
                    } else {
                        this.m_isRoot = InstallDBUtils.isCDBRoot(connection);
                        if (this.m_isRoot && !InstallDBUtils.isSysAsSysDba(string4)) {
                            this.getErrMsg().append(NEWLINE).append(RestArb.getString("WIZ_VERIFY_SCHEMA_SYS_REQ"));
                        } else {
                            this.m_usersMap = InstallDBUtils.getUsersCommonIndicator(connection, stringArray);
                            bl = this.canInstallOrUpgrade(this.m_usersMap, this.m_isRoot);
                        }
                    }
                    if (bl && this.m_usersMap.containsKey("ORDS_PUBLIC_USER") && this.m_usersMap.containsKey("ORDS_METADATA")) {
                        this.m_schemaVersion = InstallDBUtils.getORDSVersion(connection);
                        if (InstallUtils.nullOrEmpty(this.m_schemaVersion)) {
                            this.getErrMsg().append(NEWLINE).append(RestArb.getString("ERROR_MISSING_SCHEMA_VERSION"));
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            if (this.getErrMsg().length() > 0) {
                this.getErrMsg().append(NEWLINE);
            }
            this.getErrMsg().append(RestArb.format("ERR_CONN_FAILED", string4, this.m_url, sQLException.getLocalizedMessage()));
        }
        catch (Exception exception) {
            if (this.getErrMsg().length() > 0) {
                this.getErrMsg().append(NEWLINE);
            }
            this.getErrMsg().append(RestArb.format("ERR_CONN_FAILED", string4, this.m_url, exception.getLocalizedMessage()));
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
            if ("tns".equals(string3)) {
                if (InstallUtils.nullOrEmpty(string)) {
                    System.clearProperty("oracle.net.tns_admin");
                } else if (!string2.equalsIgnoreCase(string)) {
                    System.setProperty("oracle.net.tns_admin", string);
                }
            }
        }
        return bl;
    }

    private boolean canInstallOrUpgrade(Map<String, String> map, boolean bl) {
        if (map != null) {
            if (!map.containsKey("ORDS_PUBLIC_USER") && !map.containsKey("ORDS_METADATA")) {
                return true;
            }
            if (map.containsKey("ORDS_PUBLIC_USER") && map.containsKey("ORDS_METADATA")) {
                return true;
            }
            if (map.containsKey("ORDS_PUBLIC_USER") && !map.containsKey("ORDS_METADATA")) {
                if (bl) {
                    return true;
                }
                this.getErrMsg().append(NEWLINE).append(RestArb.getString("ERROR_MISSING_ORDS_SCHEMA"));
            } else if (!map.containsKey("ORDS_PUBLIC_USER") && map.containsKey("ORDS_METADATA")) {
                this.getErrMsg().append(NEWLINE).append(RestArb.getString("ERROR_MISSING_ORDS_PUB_USER"));
            }
            return false;
        }
        return false;
    }
}

