/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.Collection;
import oracle.ide.layout.ViewId;
import oracle.ide.palette2.DefaultPaletteGroup;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.view.View;
import oracle.ideimpl.palette2.AbstractPaletteDockable;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteAugmentedItem;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteWindowUI;
import oracle.ideimpl.palette2.SearchGroupUI;
import oracle.ideimpl.palette2.SearchSection;

public class SearchDockable
extends AbstractPaletteDockable {
    public static final String VIEW_NAME = "PALETTE2_SEARCH";
    public static final String SEARCHGROUP_NAME = "SearchResultsGroup";
    public static final ViewId VIEW_ID = new ViewId("PALETTEFACTORY", "PALETTE2_SEARCH");
    private DefaultPaletteGroup _searchGroup;
    private SearchSection _searchSection;
    private Collection<PaletteAugmentedItem> searchResults;
    private PaletteWindowUI palette;

    public SearchDockable(PaletteWindowUI palette) {
        super(VIEW_ID);
        this.palette = palette;
        this.createSearchGroup();
    }

    private void createSearchGroup() {
        this._searchGroup = new DefaultPaletteGroup(SEARCHGROUP_NAME, "Search results", SEARCHGROUP_NAME, "search");
        this._searchSection = new SearchSection("", "SearchResultsGroup.Section");
        this._searchGroup.addSection(this._searchSection);
    }

    @Override
    public String getTabName() {
        return PaletteArb.getString(55);
    }

    public void hideResults() {
        this.palette.removeSearchResults();
    }

    public void showSearchResults(Collection<PaletteAugmentedItem> paletteItems) {
        this.searchResults = paletteItems;
        this._searchSection.removeAllItems();
        for (PaletteAugmentedItem item : paletteItems) {
            this._searchSection.addItem(item.getPaletteItem(), item.getPageName(), item.getGroupName());
        }
        PaletteGroupUI ui = this.getGroupUI();
        ui.setData(this._searchGroup);
        this.palette.addCloseableDrawer(this, Integer.MIN_VALUE);
        this.palette.expand((View)this);
        this.palette.setSearchThread(null);
        this.palette.updateDrawerHandlesVisibility();
    }

    public Collection<PaletteAugmentedItem> getSearchResults() {
        return this.searchResults;
    }

    @Override
    protected PaletteGroupUI initGroupUI() {
        return new SearchGroupUI("list");
    }

    @Override
    public void setData(PaletteGroup paletteGroup) {
    }

    @Override
    public String getViewState() {
        return null;
    }

    @Override
    public void setViewState(String viewState) {
    }

    @Override
    public void toggleViewState() {
    }

    public void close() {
        this.palette.showSearchResults(null);
        super.close();
    }

    @Override
    protected String getDefaultLayout() {
        return "list";
    }
}

