/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.gallery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Project;
import oracle.ide.util.Assert;
import oracle.ideimpl.gallery.MruItem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public final class MruItems
extends HashStructureAdapter {
    static final String DATA_KEY = "project-level-mru-items";
    private static final int USER_MAX_ITEMS = Integer.getInteger("project.level.mru.limit", 7);
    public static final int MAX_ITEMS = Math.min(USER_MAX_ITEMS, 15);
    public static final int INTERNAL_MAX = 30;

    public static MruItems getInstance(Project project) {
        return new MruItems((HashStructureNode)project);
    }

    private MruItems(HashStructureNode node) {
        this(MruItems.getHashStructure(node));
    }

    private MruItems(HashStructure hash) {
        super(hash);
    }

    private static HashStructure getHashStructure(HashStructureNode node) {
        HashStructure userProps;
        if (node != null && (userProps = node.getPropertiesForOverriding()) != null) {
            return userProps.getOrCreateHashStructure(DATA_KEY);
        }
        return HashStructure.newInstance();
    }

    public void recentlyCreated(String invokable, String id) {
        block3: {
            String key;
            block4: {
                key = MruItems.key(invokable, id);
                if (!this._hash.containsKey(key)) break block4;
                MruItem item = MruItem.getInstance(this._hash.getHashStructure(key));
                int threshold = item.position();
                if (threshold == 0) break block3;
                List<String> keys = this.getSortedKeys();
                keys.remove(key);
                keys.add(0, key);
                int pos = 0;
                for (String mruKey : keys) {
                    MruItem.getInstance(this._hash.getHashStructure(mruKey)).position(pos++);
                    if (pos <= threshold) continue;
                    break block3;
                }
                break block3;
            }
            List<String> hashKeys = this.getSortedKeys();
            hashKeys.add(0, key);
            new MruItem(this._hash.getOrCreateHashStructure(key), invokable, id);
            int pos = 0;
            for (String mruKey : hashKeys) {
                if (pos < 30) {
                    MruItem.getInstance(this._hash.getHashStructure(mruKey)).position(pos++);
                    continue;
                }
                this._hash.remove(mruKey);
            }
        }
    }

    private static String key(String name, String id) {
        Assert.check((name != null ? 1 : 0) != 0);
        if (id == null) {
            return name;
        }
        return (name + id).replaceAll("/", "_");
    }

    List<MruItem> recentlyCreatedItemsList() {
        ArrayList<MruItem> list = new ArrayList<MruItem>();
        Iterator iter = this._hash.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            if (!(this._hash.getObject(key) instanceof HashStructure)) continue;
            list.add(MruItem.getInstance(this._hash.getHashStructure(key)));
        }
        Collections.sort(list, MruItem.POSITION_COMPARATOR);
        return Collections.unmodifiableList(list);
    }

    private List<String> getSortedKeys() {
        ArrayList<String> list = new ArrayList<String>();
        for (MruItem item : this.recentlyCreatedItemsList()) {
            list.add(MruItems.key(item.invokableClassName(), item.id()));
        }
        return list;
    }
}

