/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.io.IOException;
import java.util.Set;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.plusplus.connections.db.ConnectionDefinitionCreator;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreCommand;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.NamedConnections;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ExtraParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.MissingRequiredParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;

abstract class NewConnectionDefinitionCreator
extends ConnectionDefinitionCreator {
    protected NewConnectionDefinitionCreator(ScriptRunnerContext ctx, MessageLogger logger) {
        super(ctx, logger);
    }

    final void processParameters(ScriptRunnerContext.Parameters params) throws MissingRequiredParameterException, ExtraParameterException, ParameterFailedValidationException, IOException {
        this.connectionName = ConnectionStoreCommand.getParameterValue(params, "name");
        Set<String> existingConns = Set.copyOf(NamedConnections.instance().listConnections());
        if (existingConns.contains(this.connectionName)) {
            throw new ParameterFailedValidationException(ConnectionStoreResources.format("ERROR_EXISTING_CONNECTION", this.connectionName));
        }
        String spec = this.processTypeSpecificParameters(params);
        String user = ConnectionStoreCommand.getParameterValue(params, "user");
        if (ModelUtil.hasLength(user)) {
            this.dbtoolProperties.setProperty("userName", user);
            Boolean skipPwd = ConnectionStoreCommand.getBooleanParameterValue(params, "nopwd");
            if (Boolean.FALSE.equals(skipPwd)) {
                char[] pwd = this.promptForPassword(spec, user);
                this.wallet = this.createWallet(spec, user, pwd);
            }
        }
    }

    protected abstract String processTypeSpecificParameters(ScriptRunnerContext.Parameters var1) throws MissingRequiredParameterException, ParameterFailedValidationException, ExtraParameterException;
}

