/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.helpers.ora;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.helpers.ora.BaseOracleConnectionHelper;
import oracle.dbtools.plusplus.connections.db.storage.NamedConnectionDefinition;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;

public class AdvancedOracleConnectionHelper
extends BaseOracleConnectionHelper {
    public static final String TNS_URL_FORMAT = "jdbc:oracle:{0}:@{1}";
    public static final String TNS_DESCRIPTOR = "TNS Descriptor";

    AdvancedOracleConnectionHelper(NamedConnectionDefinition definition, ScriptRunnerContext ctx, MessageLogger logger) {
        super(definition, ctx, logger);
    }

    @Override
    public String getConnectionSpec() {
        return this.getDbtoolsProperty("connectionString");
    }

    @Override
    public String getURL() {
        String spec = this.getConnectionSpec();
        return spec != null && spec.startsWith("jdbc") ? spec : MessageFormat.format(TNS_URL_FORMAT, this.getDriverType(), spec);
    }

    @Override
    public Properties getDisplayProperties() {
        Properties props;
        block15: {
            props = super.getDisplayProperties();
            Path connDir = this.definition.getConnectionDirectory();
            try {
                String tnsName = this.getConnectionSpec();
                if (!AdvancedOracleConnectionHelper.isPossibleTNS(tnsName)) break block15;
                try (Stream<Path> s = Files.list(connDir);){
                    Path tns = s.filter(AdvancedOracleConnectionHelper::matchesTNS).findFirst().orElse(null);
                    if (tns == null) break block15;
                    props.setProperty("TNSNAMES.ORA", tns.toString());
                    File dir = connDir.toFile();
                    try (BufferedReader r = Files.newBufferedReader(tns);){
                        for (TCPTNSEntry entry : TNSHelper.parseTnsFile(r, dir)) {
                            if (!entry.getName().equals(tnsName)) continue;
                            props.setProperty(TNS_DESCRIPTOR, tnsName + " = " + entry.getDescriptor());
                            break;
                        }
                    }
                }
            }
            catch (IOException e) {
                this.logger.logError("error processing tnsnames.ora file", e);
            }
        }
        return props;
    }

    private static boolean isPossibleTNS(String spec) {
        return Pattern.matches("^[a-zA-Z0-9._]*$", spec);
    }

    private static boolean matchesTNS(Path p) {
        String fname = p.getFileName().toString();
        return "tnsnames.ora".equalsIgnoreCase(fname);
    }
}

