/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.Location;
import oracle.dbtools.connections.Storage;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.connections.StorageManager;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.DatabaseProviderStorageFactory;
import oracle.dbtools.connections.security.ReferenceWorker;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.DuplicatesPolicy;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverterFactory;
import oracle.dbtools.plusplus.connections.db.imp.ImportedConnectionResult;
import oracle.dbtools.plusplus.connections.db.imp.Importer;
import oracle.dbtools.plusplus.connections.db.imp.ImporterFactory;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class LegacyImporterFactory
implements ImporterFactory {
    @Override
    public boolean canHandle(Path path) {
        Path file;
        String fileName;
        int dot;
        if (Files.isRegularFile(path, new LinkOption[0]) && (dot = (fileName = (file = path.getFileName()).toString()).lastIndexOf(46)) > 0) {
            String ext = fileName.substring(dot + 1);
            return "json".equalsIgnoreCase(ext);
        }
        return false;
    }

    @Override
    public Importer<DatabaseProvider> create(Path path, DuplicatesPolicy duplicatesPolicy, Collection<String> existingConnections, ScriptRunnerContext ctx, MessageLogger logger) {
        return new LegacyImporter(path, duplicatesPolicy, existingConnections, ctx, logger);
    }

    static final class LegacyImporter
    extends Importer<DatabaseProvider> {
        public static final String KEY = "Key";
        public static final String EXPORT_PASSWORD_MODE = "ExportPasswordMode";

        private LegacyImporter(Path path, DuplicatesPolicy duplicatesPolicy, Collection<String> existingConnections, ScriptRunnerContext ctx, MessageLogger logger) {
            super(path, duplicatesPolicy, existingConnections, ctx, logger);
        }

        @Override
        protected Map<String, DatabaseProvider> loadConnections() {
            HashMap<String, DatabaseProvider> namesAndConnections = new HashMap();
            try {
                Collection<DatabaseProvider> conns = this.connections(LegacyImporter.createDefaultWorker(null));
                if (this.checkForPasswords(conns)) {
                    conns = this.connections(this.promptForKey());
                }
                namesAndConnections = conns.stream().collect(HashMap::new, (m, p) -> m.put(this.getConnectionName((DatabaseProvider)p), p), HashMap::putAll);
            }
            catch (StorageException e) {
                this.logger.logUserMessage(ConnectionStoreResources.format("FAILURE_LOADING_FILE", this.importPath.toString(), e.getLocalizedMessage()));
                this.logger.logError("LegacyImporter.loadConnections", e);
            }
            return namesAndConnections;
        }

        @Override
        protected String getConnectionName(DatabaseProvider prov) {
            return prov.getName();
        }

        @Override
        protected ImportedConnectionResult importConnection(DatabaseProvider connectionDefinition, String name) {
            ImportedConnectionResult result;
            ConnectionsConverter transmogrifier;
            String oldName = this.getConnectionName(connectionDefinition);
            if (ModelUtil.areDifferent(oldName, name)) {
                connectionDefinition = DatabaseProvider.builder(name, connectionDefinition).build();
            }
            if ((transmogrifier = ConnectionsConverterFactory.getConverter(connectionDefinition, this.logger)) == null) {
                String subtype = connectionDefinition.getProperty("subtype");
                if ("oraJDBC".equals(subtype)) {
                    String oracleType = connectionDefinition.getProperty("OracleConnectionType");
                    result = ImportedConnectionResult.failure(connectionDefinition.getName(), ConnectionStoreResources.format("FAILURE_UNSUPPORTED_ORACLE_TYPE", oracleType));
                } else {
                    result = ImportedConnectionResult.failure(connectionDefinition.getName(), ConnectionStoreResources.format("FAILURE_UNSUPPORTED_TYPE", subtype));
                }
            } else {
                try {
                    result = transmogrifier.convert();
                }
                catch (IOException e) {
                    result = ImportedConnectionResult.failure(connectionDefinition.getName(), e.getLocalizedMessage());
                }
            }
            return result;
        }

        private boolean checkForPasswords(Collection<DatabaseProvider> conns) {
            return conns.stream().anyMatch(this::hasPassword);
        }

        private boolean hasPassword(DatabaseProvider prov) {
            return KEY.equals(prov.getProperty(EXPORT_PASSWORD_MODE));
        }

        private Collection<DatabaseProvider> connections(ReferenceWorker refWorker) throws StorageException {
            Location jsonFile = Location.createFileLocation(this.importPath);
            StorageManager storageManager = StorageManager.builder().location(jsonFile).autosave(false).addEnvValue(ReferenceWorker.KEY, refWorker).build();
            Storage storage = storageManager.getStorage("jdbc");
            String[] connNames = storage.listConnections();
            DatabaseProviderStorageFactory factory = new DatabaseProviderStorageFactory();
            return Arrays.stream(connNames).collect(ArrayList::new, (l, s) -> {
                DatabaseProvider prov;
                try {
                    prov = (DatabaseProvider)storage.getConnection((String)s, factory);
                }
                catch (StorageException ex) {
                    prov = DatabaseProvider.builder("s").property("subtype", "Unknown").build();
                }
                l.add(prov);
            }, ArrayList::addAll);
        }

        private ReferenceWorker promptForKey() {
            this.logger.traceMessage("prompting user for encryption key");
            String key = null;
            ConsoleService reader = (ConsoleService)this.ctx.getProperty("script.runner.jline");
            if (reader != null) {
                String haveASpace = this.ctx.getProperty("script.runner.sqlplus.silent") == null ? ConnectionStoreResources.getString("IMPORT_PROMPT_ENCRYPTION_KEY") + " " : "";
                try {
                    key = this.ctx.getProperty("script.runner.sqlplus.silent") == null ? (this.ctx.isSQLPlusClassic() ? reader.readInput(haveASpace, Character.valueOf(' ')) : reader.readInput(haveASpace, Character.valueOf('*'))) : reader.readInput(haveASpace, Character.valueOf(' '));
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                }
            }
            return LegacyImporter.createDefaultWorker(key);
        }

        private static ReferenceWorker createDefaultWorker(String key) {
            ReferenceWorker<char[]> retval = ModelUtil.hasLength(key) ? ReferenceWorker.createDefaultWorker(key) : ReferenceWorker.createNullWorker();
            return retval;
        }
    }
}

