/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetEditor
extends CommandListener
implements IShowCommand,
IStoreCommand {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        if (cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("seteditor")) {
            String[] parts = cmd.getSQLOrig().split("\\s+");
            if (parts.length == 3) {
                switch (parts[2].toLowerCase()) {
                    case "vi": {
                        consoleService.setDefaultEditor(ConsoleService.Editor.VI);
                        break;
                    }
                    case "emacs": {
                        consoleService.setDefaultEditor(ConsoleService.Editor.EMACS);
                        break;
                    }
                    default: {
                        ctx.write("Editor: invalid option '" + parts[2] + "'\n");
                        return true;
                    }
                }
            } else {
                ctx.write("Editor: unrecognized command\n");
            }
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"editor"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        ctx.write("Inline editor: " + consoleService.getDefaultEditor().toString().toLowerCase() + "\n");
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        StringBuilder sb = new StringBuilder();
        sb.append("set editor ");
        switch (consoleService.getDefaultEditor()) {
            case VI: {
                sb.append("vi");
                break;
            }
            case EMACS: {
                sb.append("emacs");
            }
        }
        return sb.toString();
    }
}

