/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;

public class SetEncoding
extends CommandListener
implements IShowCommand {
    private static final String USAGE = "Usage: SET ENCODING <encoding>\nExample: SET ENCODING UTF-8\nUse \"show encodings\" to list all available encodings\n";

    @Override
    public String[] getShowAliases() {
        return new String[]{"ENCODING"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ctx.write(MessageFormat.format(Messages.getString("SetEncoding"), ctx.getEncoding()));
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] cmds = cmd.getSQLOrig().split("\\s+");
        if (cmds.length == 3) {
            String encoding = cmds[2];
            try {
                ctx.setEncoding(encoding);
            }
            catch (IllegalArgumentException e) {
                ctx.write("Invalid Encoding\nUsage: SET ENCODING <encoding>\nExample: SET ENCODING UTF-8\nUse \"show encodings\" to list all available encodings\n");
            }
        } else {
            ctx.write(USAGE);
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

