/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.subjectmap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.subjectmap.SubjectClassIRITableModel;
import oracle.dbtools.rdfgraph.r2rml.language.RDFSClassNode;
import oracle.dbtools.rdfgraph.r2rml.language.SubjectMapNode;
import oracle.javatools.icons.OracleIcons;

public class SubjectClassIRIEditor
extends JPanel {
    private static final String SUBECT_CLASS_LIST_TITLE = R2RMLArb.getString("SubjectClassIRIEditor.SUBJECT_CLASS_IRI_S_");
    SubjectMapNode node;
    Connection connection;
    private JTable table;
    SubjectClassIRITableModel tmodel;
    private JToolBar toolbar;

    public SubjectClassIRIEditor(SubjectMapNode subjectMapNode, Connection connection) {
        this.node = subjectMapNode;
        this.connection = connection;
        this.setBorder(BorderFactory.createTitledBorder(SUBECT_CLASS_LIST_TITLE));
        this.setLayout(new BorderLayout());
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 250));
        this.initUI();
    }

    private void initUI() {
        this.table = this.createTable();
        this.toolbar = this.createToolBar();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.toolbar, "North");
    }

    private JToolBar createToolBar() {
        this.toolbar = new JToolBar();
        JButton jButton = new JButton("Add", OracleIcons.getIcon((String)"add.png"));
        jButton.addActionListener(actionEvent -> {
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#class>", new RDFSClassNode(""));
            this.tmodel.fireTableDataChanged();
            int n = this.node.getSubjectClasses().size();
            boolean bl = this.table.editCellAt(n - 1, 0);
            if (bl) {
                boolean bl2 = false;
                boolean bl3 = false;
                this.table.changeSelection(n - 1, 0, bl2, bl3);
                this.table.requestFocusInWindow();
            }
        });
        JButton jButton2 = new JButton(RdfgraphArb.getString("DELETE"), OracleIcons.getIcon((String)"delete.png"));
        jButton2.addActionListener(actionEvent -> {
            if (this.table.getSelectedRow() != -1) {
                int n = this.table.getSelectedRow();
                this.table.clearSelection();
                if (this.table.isEditing()) {
                    this.table.getCellEditor().stopCellEditing();
                }
                this.tmodel.removeRow(n);
            }
        });
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(jButton);
        this.toolbar.add(jButton2);
        return this.toolbar;
    }

    private JTable createTable() {
        this.tmodel = new SubjectClassIRITableModel(this.node);
        this.table = new JTable(this.tmodel);
        this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
        this.table.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.table.setAutoResizeMode(3);
        this.table.setFillsViewportHeight(true);
        return this.table;
    }
}

