/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.JPanelActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControlPanel;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.SourceRow;
import oracle.dbtools.rdfgraph.ui.TableSearchRunnable;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class SingleSearchAndSelectActionControl
extends ActionControl
implements SearchListener {
    JPanel mPanel = new JPanel();
    SearchField txtSearch;
    TableActionControl resultTable;
    JTable jResultTable;
    Connection connection;
    TableSearchRunnable searchRunnable;
    String[] columnNames;
    String searchCol;
    private List<ActionControl> childControls;
    private List<SourceRow> selectedRows;
    String querySource;

    public void setSearchCol(String string) {
        this.searchCol = string;
    }

    public String getSearchCol() {
        return this.searchCol;
    }

    public SourceRow getSelectedRow() {
        int n = this.jResultTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        Object[] objectArray = new Object[this.getColumnNames().length];
        for (int i = 0; i < this.getColumnNames().length; ++i) {
            objectArray[i] = (String)this.jResultTable.getModel().getValueAt(n, i);
        }
        return new SourceRow(objectArray);
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setQuerySource(String string) {
        this.querySource = string;
    }

    public String getQuerySource() {
        return this.querySource;
    }

    public void setSearchRunnable(TableSearchRunnable tableSearchRunnable) {
        this.searchRunnable = tableSearchRunnable;
    }

    public TableSearchRunnable getSearchRunnable() {
        return this.searchRunnable;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public SingleSearchAndSelectActionControl(String string, Connection connection, String string2, String[] stringArray, String string3) {
        super(string, string);
        this.setConnection(connection);
        this.setQuerySource(string2);
        this.setColumnNames(stringArray);
        this.setSearchCol(string3);
        this.init();
    }

    private void init() {
        this.selectedRows = new ArrayList<SourceRow>();
        this.childControls = new ArrayList<ActionControl>();
        this.txtSearch = new SearchField();
        this.txtSearch.setStyle(SearchField.Style.SEARCH);
        this.txtSearch.addSearchListener((SearchListener)this);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.getColumnNames()));
        this.resultTable = new TableActionControl("available_sources", arrayList, new ArrayList(), 10);
        this.resultTable.setTitle(RdfgraphArb.getString("SingleSearchAndSelectActionControl.AVAILABLE_SOURCES"));
        this.jResultTable = ((TableActionControlPanel)this.resultTable.getUI()).getTable();
        this.jResultTable.setCellSelectionEnabled(false);
        this.jResultTable.setRowSelectionAllowed(true);
        this.jResultTable.setSelectionMode(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.txtSearch, "Center");
        JPanelActionControl jPanelActionControl = new JPanelActionControl("search_panel", "", jPanel);
        this.childControls.add((ActionControl)jPanelActionControl);
        this.childControls.add((ActionControl)this.resultTable);
        this.mPanel.setLayout(new BorderLayout());
        this.mPanel.add((Component)jPanelActionControl.getUI(), "North");
        this.mPanel.add((Component)new JScrollPane(this.jResultTable), "Center");
    }

    public void searchPerformed(SearchEvent searchEvent) {
        TableSearchRunnable tableSearchRunnable = new TableSearchRunnable(searchEvent.getSearchProgress(), searchEvent.getSearchCategory(), searchEvent.getSearchText());
        tableSearchRunnable.setColumnNames(this.getColumnNames());
        tableSearchRunnable.setQuerySource(this.getQuerySource());
        tableSearchRunnable.setSearchCol(this.getSearchCol());
        tableSearchRunnable.setResultTablecontrol(this.resultTable);
        tableSearchRunnable.setConnection(this.getConnection());
        Thread thread = new Thread((Runnable)tableSearchRunnable, RdfgraphArb.getString("SEARCHING"));
        thread.start();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
    }

    public ActionControl.Value getValue() {
        return new ActionControl.Value();
    }

    public Component getUI() {
        return this.mPanel;
    }

    public void setEditable(boolean bl) {
    }

    public List<ActionControl> getChildControls() {
        return this.childControls;
    }
}

