/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.security.redaction.generator;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.security.redaction.generator.RedactCodeGenerator;
import oracle.dbtools.security.redaction.model.RedactModel;

public class RedactCodeGeneratorController {
    RedactModel redactModel = null;
    private String beginScript = "BEGIN\n";
    private String endScript = "END;\n";
    private String slashScript = "/\n";

    public RedactCodeGeneratorController(RedactModel redactModel) {
        this.redactModel = redactModel;
    }

    public void setModel(RedactModel redactModel) {
        this.redactModel = redactModel;
    }

    public String getCreateRedactScript() {
        String string = null;
        Object var2_2 = null;
        Object object = null;
        String string2 = this.redactModel.getPolicyName();
        if (string2 == null || string2.trim().length() == 0) {
            return object;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        RedactCodeGenerator redactCodeGenerator = RedactCodeGenerator.getInstance();
        String string3 = this.redactModel.getDBVersion();
        String string4 = this.getRedactCreateCodeGeneratorOption(this.redactModel);
        hashMap.put("model", this.collectPropertiesFromModel(this.redactModel));
        string = redactCodeGenerator.generate(string3, string4, hashMap);
        object = string;
        object = this.beginScript + (String)object + "\n" + this.endScript + this.slashScript;
        return object;
    }

    public String getAlterRedactScript() {
        String string = null;
        String string2 = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        RedactCodeGenerator redactCodeGenerator = RedactCodeGenerator.getInstance();
        String string3 = this.redactModel.getDBVersion();
        String string4 = this.getRedactAlterCodeGeneratorOption(this.redactModel);
        if (this.redactModel.alterPolicyChanges()) {
            hashMap.put("changes", this.collectChangesPropertiesFromModel(this.redactModel));
            hashMap.put("model", this.collectPropertiesFromModel(this.redactModel));
            string = redactCodeGenerator.generate(string3, string4, hashMap);
            string2 = this.removeLastComma(string) + "\n";
            string2 = this.beginScript + string2 + this.endScript + this.slashScript;
        }
        return string2;
    }

    public String getDropRedactScript() {
        String string = null;
        String string2 = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        RedactCodeGenerator redactCodeGenerator = RedactCodeGenerator.getInstance();
        String string3 = this.redactModel.getDBVersion();
        String string4 = this.getRedactDropCodeGeneratorOption();
        hashMap.put("model", this.collectPropertiesFromModel(this.redactModel));
        string = redactCodeGenerator.generate(string3, string4, hashMap);
        string2 = this.beginScript + string + "\n" + this.endScript + this.slashScript;
        return string2;
    }

    public String getEnableDisableRedactScript() {
        String string = null;
        String string2 = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        RedactCodeGenerator redactCodeGenerator = RedactCodeGenerator.getInstance();
        String string3 = this.redactModel.getDBVersion();
        String string4 = this.getRedactCreateCodeGeneratorEnableDisableOption(this.redactModel);
        hashMap.put("model", this.collectPropertiesFromModel(this.redactModel));
        string = redactCodeGenerator.generate(string3, string4, hashMap);
        string2 = this.beginScript + string + "\n" + this.endScript + this.slashScript;
        return string2;
    }

    private String getRedactDropCodeGeneratorOption() {
        return "REDACT_POLICY_DROP";
    }

    private Map<String, Object> collectChangesPropertiesFromModel(RedactModel redactModel) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("policy_description", new Boolean(!redactModel.comparePolicyDescription()));
        hashMap.put("expression", new Boolean(!redactModel.compareExpression()));
        hashMap.put("action", new Boolean(!redactModel.compareAction()));
        hashMap.put("column_description", new Boolean(!redactModel.compareColumnDescription()));
        hashMap.put("function_type", new Boolean(!redactModel.compareFunctionType()));
        hashMap.put("function_parameters", new Boolean(!redactModel.compareFunctionParameters()));
        hashMap.put("regexp_pattern", new Boolean(!redactModel.compareRegexpPattern()));
        hashMap.put("regexp_replace_string", new Boolean(!redactModel.compareRegexpReplaceString()));
        hashMap.put("regexp_position", new Boolean(!redactModel.compareRegexpPosition()));
        hashMap.put("regexp_occurrence", new Boolean(!redactModel.compareRegexpOccurrence()));
        hashMap.put("regexp_match_parameter", new Boolean(!redactModel.compareRegexpMatchParameter()));
        return hashMap;
    }

    private Map<String, Object> collectPropertiesFromModel(RedactModel redactModel) {
        DBUtil dBUtil = DBUtil.getInstance((Connection)redactModel.getConnection());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("policy_name", this.redactModel.getPolicyName());
        hashMap.put("policy_description", this.redactModel.getPolicyDescription());
        hashMap.put("object_schema", RedactCodeGeneratorController.quoteIdentifier(dBUtil, this.redactModel.getSchemaName()));
        hashMap.put("object_name", RedactCodeGeneratorController.quoteIdentifier(dBUtil, this.redactModel.getObjectName()));
        hashMap.put("column_name", RedactCodeGeneratorController.quoteIdentifier(dBUtil, this.redactModel.getColumnName()));
        hashMap.put("column_description", this.redactModel.getColumnDescription());
        hashMap.put("expression", this.redactModel.getExpression());
        hashMap.put("enabled", this.redactModel.isEnabled());
        hashMap.put("function_type", this.redactModel.getFunctionType());
        hashMap.put("function_parameters", this.redactModel.getFunctionParameters());
        hashMap.put("action", this.redactModel.getActionType());
        hashMap.put("regexp_pattern", this.redactModel.getRegexpPattern());
        hashMap.put("regexp_replace_string", this.redactModel.getRegexpReplaceString());
        hashMap.put("regexp_position", this.redactModel.getRegexpPosition());
        hashMap.put("regexp_occurrence", this.redactModel.getRegexpOccurrence());
        hashMap.put("regexp_match_parameter", this.redactModel.getRegexpMatchParameter());
        return hashMap;
    }

    private static String quoteIdentifier(DBUtil dBUtil, String string) {
        return ModelUtil.hasLength((String)string) ? dBUtil.addDbQuotes(string, false) : string;
    }

    private String getRedactCreateCodeGeneratorOption(RedactModel redactModel) {
        String string = redactModel.getColumnName();
        String string2 = redactModel.getSchemaName();
        String string3 = redactModel.getFunctionType();
        String string4 = redactModel.getFunctionParameters();
        boolean bl = new Boolean(redactModel.getIsRegexp());
        if (!bl) {
            if (redactModel.getFunctionType().equals("DBMS_REDACT.FULL")) {
                return "REDACT_POLICY_CREATE_FULL_WITHOUT_FUNCTION_PARAMS";
            }
            if (redactModel.getFunctionType().equals("DBMS_REDACT.RANDOM")) {
                return "REDACT_POLICY_CREATE_RANDOM_WITHOUT_FUNCTION_PARAMS";
            }
            if (redactModel.getFunctionType().equals("DBMS_REDACT.NONE")) {
                return "REDACT_POLICY_CREATE_NONE_WITHOUT_FUNCTION_PARAMS";
            }
            if (redactModel.getFunctionType().equals("DBMS_REDACT.PARTIAL")) {
                String string5 = redactModel.getFunctionParameters();
                if (string5 != null && string5.trim().length() > 0) {
                    return "REDACT_POLICY_CREATE_PARTIAL_WITH_FUNCTION_PARAMS";
                }
                return "REDACT_POLICY_CREATE_PARTIAL_WITHOUT_FUNCTION_PARAMS";
            }
        } else {
            return "REDACT_POLICY_CREATE_REGEXP";
        }
        return "REDACT_POLICY_CREATE_FULL";
    }

    private String getRedactCreateCodeGeneratorEnableDisableOption(RedactModel redactModel) {
        boolean bl = new Boolean(redactModel.isEnabled());
        if (bl) {
            return "REDACT_POLICY_ENABLE";
        }
        return "REDACT_POLICY_DISABLE";
    }

    private String getRedactCreateCodeGeneratorEnableOption(RedactModel redactModel) {
        boolean bl = new Boolean(redactModel.isEnabled());
        if (bl) {
            return "REDACT_POLICY_ENABLE";
        }
        return null;
    }

    private String getRedactAlterCodeGeneratorOption(RedactModel redactModel) {
        return "REDACT_POLICY_ALTER_ONLY_CHANGE_TEMPLATE";
    }

    private String removeLastComma(String object) {
        int n = ((String)object).lastIndexOf(44);
        object = ((String)object).substring(0, n) + "\n);";
        return object;
    }
}

