/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.beans.editor;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.graphic.IlvDoubleLinkImage;
import ilog.views.graphic.IlvDoubleSplineLinkImage;
import ilog.views.graphic.IlvOneLinkImage;
import ilog.views.graphic.IlvOneSplineLinkImage;
import ilog.views.graphic.IlvPolylineLinkImage;
import ilog.views.graphic.IlvSplineLinkImage;
import ilog.views.interactor.IlvLinkImageFactory;
import ilog.views.util.internal.IlvReflection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;

public class LinkFactoryEditor
extends Panel
implements PropertyEditor {
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected IlvLinkImageFactory value;
    protected List factoryList;
    protected TextField factoryText;
    protected static Class[] factories;

    public LinkFactoryEditor() {
        if (factories == null) {
            Class[] classArray = new Class[7];
            classArray[0] = IlvLinkImage.class;
            classArray[1] = IlvPolylineLinkImage.class;
            classArray[2] = IlvSplineLinkImage.class;
            classArray[3] = IlvOneLinkImage.class;
            classArray[4] = IlvOneSplineLinkImage.class;
            classArray[5] = IlvDoubleLinkImage.class;
            classArray[6] = IlvDoubleSplineLinkImage.class;
            factories = classArray;
        }
        this.setLayout(new BorderLayout(4, 4));
        this.factoryList = new List(8);
        this.factoryText = new TextField();
        for (int i = 0; i < factories.length; ++i) {
            this.factoryList.add(factories[i].getName());
        }
        this.add((Component)new Label("The class of link created:"), "North");
        this.add((Component)this.factoryList, "Center");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(4, 1));
        panel.add(this.factoryText);
        panel.add(new Label("The class must have a constructor like this:"));
        panel.add(new Label("IlvGraphic from, IlvGraphic to, boolean oriented, ..."));
        panel.add(new Label("... IlvPoint[] points"));
        this.add((Component)panel, "South");
        this.factoryList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Integer n = (Integer)itemEvent.getItem();
                    LinkFactoryEditor.this.factoryText.setText(LinkFactoryEditor.this.factoryList.getItem(n));
                    IlvLinkImageFactory ilvLinkImageFactory = (IlvLinkImageFactory)LinkFactoryEditor.this.getValue();
                    NamedFactory namedFactory = new NamedFactory(LinkFactoryEditor.this.factoryText.getText());
                    LinkFactoryEditor.this.value = namedFactory;
                    LinkFactoryEditor.this.support.firePropertyChange(null, ilvLinkImageFactory, namedFactory);
                }
            }
        });
        this.factoryText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (LinkFactoryEditor.this.factoryText.getText() != null && LinkFactoryEditor.this.factoryText.getText().length() != 0) {
                    IlvLinkImageFactory ilvLinkImageFactory = (IlvLinkImageFactory)LinkFactoryEditor.this.getValue();
                    NamedFactory namedFactory = new NamedFactory(LinkFactoryEditor.this.factoryText.getText());
                    LinkFactoryEditor.this.value = namedFactory;
                    LinkFactoryEditor.this.support.firePropertyChange(null, ilvLinkImageFactory, namedFactory);
                }
            }
        });
        this.setSize(250, 250);
    }

    @Override
    public void setValue(Object object) {
        this.value = (IlvLinkImageFactory)object;
        this.factoryText.setText(this.a(this.value));
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    private String a(IlvLinkImageFactory ilvLinkImageFactory) {
        if (ilvLinkImageFactory == null) {
            return "ilog.views.graphic.IlvLinkImage";
        }
        try {
            Class clazz = ilvLinkImageFactory.getLinkImageClass();
            if (clazz == null) {
                return "";
            }
            return clazz.getName();
        }
        catch (Exception exception) {
            return "Unknown type";
        }
    }

    @Override
    public String getJavaInitializationString() {
        IlvLinkImageFactory ilvLinkImageFactory = this.value;
        if (ilvLinkImageFactory == null) {
            return "null";
        }
        Class clazz = ilvLinkImageFactory.getLinkImageClass();
        if (clazz == null) {
            return "null";
        }
        try {
            Class[] classArray = new Class[3];
            classArray[0] = IlvGraphic.class;
            classArray[1] = IlvGraphic.class;
            classArray[2] = Boolean.TYPE;
            Class[] classArray2 = classArray;
            clazz.getConstructor(classArray2);
            return "new ilog.views.interactor.IlvLinkImageFactory() {\n  public Class getLinkImageClass() {\n    return " + clazz.getName() + ".class;\n    }\n  public ilog.views.IlvLinkImage createObject(ilog.views.IlvGraphic from, ilog.views.IlvGraphic to, ilog.views.IlvPoint[] points, boolean oriented) {\n    return new " + clazz.getName() + "(from, to, oriented);\n    }\n}";
        }
        catch (Exception exception) {
            try {
                Class[] classArray = new Class[4];
                classArray[0] = IlvGraphic.class;
                classArray[1] = IlvGraphic.class;
                classArray[2] = Boolean.TYPE;
                classArray[3] = IlvReflection.arrayType(IlvPoint.class);
                Class[] classArray3 = classArray;
                clazz.getConstructor(classArray3);
                return "new ilog.views.interactor.IlvLinkImageFactory() {\n  public Class getLinkImageClass() {\n    return " + clazz.getName() + ".class;\n    }\n  public ilog.views.IlvLinkImage createObject(ilog.views.IlvGraphic from, ilog.views.IlvGraphic to, ilog.views.IlvPoint[] points, boolean oriented) {\n    IlvPoint[] pts = null;\n    if (points.length > 2) {\n      pts = new IlvPoint[points.length-2];\n      System.arraycopy(points, 1, pts, 0, points.length-2);\n    }\n    return new " + clazz.getName() + "(from, to,  oriented, points);\n    }\n}";
            }
            catch (Exception exception2) {
                return "null";
            }
        }
    }

    @Override
    public String getAsText() {
        return this.a(this.value);
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        this.factoryText.setText(string);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public class NamedFactory
    implements IlvLinkImageFactory {
        String a;
        Constructor b;
        Class c;
        boolean d;

        public String toString() {
            return "LinkImageFactory " + this.a;
        }

        public NamedFactory(String string) {
            this.a = string;
            this.d = false;
            try {
                this.c = Class.forName(string);
                if (!IlvLinkImage.class.isAssignableFrom(this.c)) {
                    return;
                }
                Constructor<?>[] constructorArray = this.c.getConstructors();
                for (int i = 0; i < constructorArray.length; ++i) {
                    Constructor<?> constructor = constructorArray[i];
                    Class<?>[] classArray = constructor.getParameterTypes();
                    if (classArray.length != 3 && classArray.length != 4 || classArray[0] != IlvGraphic.class) continue;
                    if (classArray[1] != IlvGraphic.class || classArray[2] != Boolean.TYPE) continue;
                    if (classArray.length != 3) {
                        if (!classArray[3].isArray()) continue;
                        if (classArray[3].getComponentType() != IlvPoint.class) continue;
                    }
                    this.b = constructor;
                    this.d = classArray.length == 4;
                    break;
                }
            }
            catch (Exception exception) {
                this.b = null;
                this.c = null;
            }
        }

        @Override
        public Class getLinkImageClass() {
            return this.c;
        }

        @Override
        public IlvLinkImage createObject(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, IlvPoint[] ilvPointArray, boolean bl) {
            Object[] objectArray = this.d ? new Object[]{ilvGraphic, ilvGraphic2, bl ? Boolean.TRUE : Boolean.FALSE, ilvPointArray} : new Object[]{ilvGraphic, ilvGraphic2, bl ? Boolean.TRUE : Boolean.FALSE};
            try {
                return (IlvLinkImage)this.b.newInstance(objectArray);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

