/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;

public class ChangelogRewriter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ChangeLogRewriterResult removeChangeLogId(String changeLogFile, String changeLogId, DatabaseChangeLog databaseChangeLog) {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        try {
            String changeLogString;
            Throwable throwable;
            String encoding;
            Resource resource;
            block42: {
                resource = resourceAccessor.get(changeLogFile);
                encoding = GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
                throwable = null;
                try (InputStream is = resource.openInputStream();){
                    changeLogString = StreamUtil.readStreamAsString(is, encoding);
                    if (changeLogFile.toLowerCase().endsWith(".xml")) {
                        String changeLogIdString = " changeLogId=\"" + changeLogId + "\"";
                        String editedString = changeLogString.replaceFirst(changeLogIdString, "");
                        if (editedString.equals(changeLogString)) {
                            ChangeLogRewriterResult changeLogRewriterResult = new ChangeLogRewriterResult("Unable to update changeLogId in changelog file '" + changeLogFile + "'", false);
                            return changeLogRewriterResult;
                        }
                        changeLogString = editedString;
                        break block42;
                    }
                    if (changeLogFile.toLowerCase().endsWith(".sql")) {
                        String newChangeLogString = changeLogString.replaceFirst("--(\\s*)liquibase formatted sql changeLogId:(\\s*)" + changeLogId, "-- liquibase formatted sql");
                        if (newChangeLogString.equals(changeLogString)) {
                            ChangeLogRewriterResult changeLogRewriterResult = new ChangeLogRewriterResult("Unable to update changeLogId in changelog file '" + changeLogFile + "'", false);
                            return changeLogRewriterResult;
                        }
                        changeLogString = newChangeLogString;
                        break block42;
                    }
                    if (changeLogFile.toLowerCase().endsWith(".json")) {
                        changeLogString = changeLogString.replaceFirst("\"changeLogId\":\"" + changeLogId + "\",", "\n");
                    } else {
                        if (!changeLogFile.toLowerCase().endsWith(".yml") && !changeLogFile.toLowerCase().endsWith(".yaml")) {
                            ChangeLogRewriterResult changeLogRewriterResult = new ChangeLogRewriterResult("Changelog file '" + changeLogFile + "' is not a supported format", false);
                            return changeLogRewriterResult;
                        }
                        changeLogString = changeLogString.replaceFirst("- changeLogId: " + changeLogId, "");
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            throwable = null;
            try (OutputStream outputStream = resource.openOutputStream(true);){
                outputStream.write(changeLogString.getBytes(encoding));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            if (databaseChangeLog != null) {
                databaseChangeLog.setChangeLogId(null);
            }
            String message = "The changeLogId has been removed from changelog '" + changeLogFile + "'.";
            Scope.getCurrentScope().getLog(ChangelogRewriter.class).info(message);
            return new ChangeLogRewriterResult(message, true);
        }
        catch (IOException ioe) {
            String errorMessage = "Changelog file '" + changeLogFile + "' with changelog ID '" + changeLogId + "' was not deactivated due to an error: " + ioe.getMessage();
            Scope.getCurrentScope().getLog(ChangelogRewriter.class).warning(errorMessage);
            return new ChangeLogRewriterResult(errorMessage, false);
        }
    }

    public static ChangeLogRewriterResult addChangeLogId(String changeLogFile, String changeLogId, DatabaseChangeLog databaseChangeLog) {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        try {
            Resource resource = resourceAccessor.get(changeLogFile);
            InputStream is = resource.openInputStream();
            String encoding = GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
            String changeLogString = StreamUtil.readStreamAsString(is, encoding);
            if (changeLogFile.toLowerCase().endsWith(".xml")) {
                String patternString = "(?ms).*<databaseChangeLog[^>]*>";
                Pattern pattern = Pattern.compile(patternString);
                Matcher matcher = pattern.matcher(changeLogString);
                if (matcher.find()) {
                    String header = changeLogString.substring(matcher.start(), matcher.end() - 1);
                    String xsdPatternString = "([dbchangelog|liquibase-pro])-3.[0-9]?[0-9]?.xsd";
                    Pattern xsdPattern = Pattern.compile(xsdPatternString);
                    Matcher xsdMatcher = xsdPattern.matcher(header);
                    String editedString = xsdMatcher.replaceAll("$1-" + XMLChangeLogSAXParser.getSchemaVersion() + ".xsd");
                    String outputChangeLogString = " changeLogId=\"" + changeLogId + "\"";
                    if (changeLogString.trim().endsWith("/>")) {
                        changeLogString = changeLogString.replaceFirst("/>", outputChangeLogString + "/>");
                    } else {
                        String outputHeader = editedString + outputChangeLogString + ">";
                        changeLogString = changeLogString.replaceFirst(patternString, outputHeader);
                    }
                }
            } else if (changeLogFile.toLowerCase().endsWith(".sql")) {
                String newChangeLogString = changeLogString.replaceFirst("--(\\s*)liquibase formatted sql", "-- liquibase formatted sql changeLogId:" + changeLogId);
                if (newChangeLogString.equals(changeLogString)) {
                    return new ChangeLogRewriterResult("Unable to update changeLogId in changelog file '" + changeLogFile + "'", false);
                }
                changeLogString = newChangeLogString;
            } else if (changeLogFile.toLowerCase().endsWith(".json")) {
                changeLogString = changeLogString.replaceFirst("\\[", "\\[\n\"changeLogId\":\"" + changeLogId + "\",\n");
            } else if (changeLogFile.toLowerCase().endsWith(".yml") || changeLogFile.toLowerCase().endsWith(".yaml")) {
                changeLogString = changeLogString.replaceFirst("^databaseChangeLog:(\\s*)\n", "databaseChangeLog:$1\n- changeLogId: " + changeLogId + "$1\n");
            } else {
                return new ChangeLogRewriterResult("Changelog file '" + changeLogFile + "' is not a supported format", false);
            }
            try (OutputStream outputStream = resource.openOutputStream(true);){
                outputStream.write(changeLogString.getBytes(encoding));
            }
            if (databaseChangeLog != null) {
                databaseChangeLog.setChangeLogId(changeLogId);
            }
        }
        catch (IOException ioe) {
            return new ChangeLogRewriterResult("* Changelog file '" + changeLogFile + "' with changelog ID '" + changeLogId + "' was not registered due to an error: " + ioe.getMessage(), false);
        }
        return new ChangeLogRewriterResult("* Changelog file '" + changeLogFile + "' has been updated with changelog ID '" + changeLogId + "'.", true);
    }

    public static class ChangeLogRewriterResult {
        public String message;
        public boolean success;

        public ChangeLogRewriterResult(String message, boolean success) {
            this.message = message;
            this.success = success;
        }
    }
}

