/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.advisor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.logging.IStatusMessageConsumer;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.ui.IImageRegistry;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.advisor.IndexAdvicePanel;
import oracle.dbtools.raptor.timesten.advisor.IndexAdvisorTask;
import oracle.dbtools.raptor.timesten.advisor.StatisticsPanel;
import oracle.dbtools.raptor.timesten.dialogs.connection.IndexAdvisorHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetState;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;

public class WorksheetIndexAdvisorPanel
extends JPanel
implements WorksheetResultPanel {
    private static final String CAPTURE_DROP_SQL = "call ttIndexAdviceCaptureDrop";
    private static Logger LOGGER = Logger.getLogger(WorksheetIndexAdvisorPanel.class.getPackage().getName());
    private static final String HOME_DIR = System.getProperty("user.home");
    private Icon m_overlayIcon = null;
    private WorksheetState m_state = WorksheetState.CLOSED;
    private WorksheetContext theContext;
    private String theId;
    private JMenuItem[] theMenuItems;
    private JTabbedPane theTabbedPane;
    private BasicEditorPane theSqlPane;
    private IndexAdvicePanel theIndexAdvice;
    private StatisticsPanel theStatisticsPane;
    protected int PIN_CMD_ID = 68;
    protected int NULL_CMD_ID = -123456;
    DBConfig conf = null;
    protected boolean m_isPinned = false;
    protected ToggleToolButton _pinToggle;
    private Icon _ranOkIcon;
    private Icon _tabIcon;
    Map<RaptorTaskDescriptor, ITaskUI> _descUIMap;
    JPanel _statusPanel;
    private JLabel _statusLabel;
    private final Icon _waitingIcon;
    private final Icon _runningIcon;
    private final Icon _problemIcon;
    private final Icon _fileSaveIcon;
    private Toolbar _toolbar;
    private Icon overlayIcon;

    public WorksheetIndexAdvisorPanel() {
        this(null, null);
    }

    public WorksheetIndexAdvisorPanel(String string, WorksheetContext worksheetContext) {
        try {
            this.conf = DBConfig.getInstance();
        }
        catch (Throwable throwable) {
            this.conf = new DBConfig();
        }
        this.m_isPinned = this.conf.getBoolean("AUTOPIN_RESULTS_TABS");
        this._ranOkIcon = null;
        this._tabIcon = null;
        this._descUIMap = new HashMap<RaptorTaskDescriptor, ITaskUI>();
        this._statusPanel = new JPanel(new BorderLayout());
        this._statusLabel = new JLabel();
        this._waitingIcon = IImageRegistry.LIGHT_YELLOW;
        this._runningIcon = OracleIcons.getIcon((String)"throbber.gif");
        this._problemIcon = OracleIcons.getIcon((String)"exception.png");
        this._fileSaveIcon = OracleIcons.getIcon((String)"filesave.png");
        this.overlayIcon = null;
        this.theContext = worksheetContext;
        this.theId = string;
        this.init();
    }

    public static String getConnectionName(WorksheetContext worksheetContext) {
        String string = worksheetContext.getConnectionName();
        return Connections.getConnectionName((String)string);
    }

    private void init() {
        try {
            this.setLayout(new BorderLayout());
            this.theTabbedPane = new JTabbedPane();
            String string = WorksheetIndexAdvisorPanel.getConnectionName(this.theContext);
            Connection connection = Connections.getInstance().getConnection(this.theContext.getConnectionName());
            this.theIndexAdvice = new IndexAdvicePanel(string, connection, null, true);
            this.theStatisticsPane = new StatisticsPanel();
            this.theTabbedPane.addTab(Messages.getString("IndexAdvisor.indexRecommendations"), this.theIndexAdvice);
            this.theTabbedPane.addTab(Messages.getString("TTJpanel.SQL"), this.createSqlPanel());
            this.theMenuItems = new JMenuItem[2];
            this.theMenuItems[0] = new JMenuItem(Messages.getString("IndexAdvisor.configure"));
            this.theMenuItems[1] = new JMenuItem(Messages.getString("IndexAdvisor.drop"));
            this.add((Component)this.theTabbedPane, "Center");
            this.initToolbar();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Can't initialize GUI", exception);
        }
    }

    private void initToolbar() {
        this._toolbar = new Toolbar();
        this.add((Component)this._toolbar, "North");
        if (this.PIN_CMD_ID != this.NULL_CMD_ID && this.isCloseable()) {
            Icon icon = this.m_isPinned ? RaptorImagesArb.getIcon((String)"PINNED") : OracleIcons.getIcon((String)"pin.png");
            ToggleAction toggleAction = new ToggleAction(oracle.dbtools.worksheet.Messages.getString((String)"AbstractWorksheetResultPanel.1"), icon){

                public void actionPerformed(ActionEvent actionEvent) {
                    Icon icon = WorksheetIndexAdvisorPanel.this.m_isPinned ? OracleIcons.getIcon((String)"pin.png") : RaptorImagesArb.getIcon((String)"PINNED");
                    WorksheetIndexAdvisorPanel.this._pinToggle.setIcon(icon);
                    WorksheetIndexAdvisorPanel.this.m_isPinned = !WorksheetIndexAdvisorPanel.this.m_isPinned;
                }
            };
            toggleAction.setName(toggleAction.getValue("Name").toString());
            this._pinToggle = this._toolbar.addToggleButton(toggleAction);
            toggleAction.setState(this.isPinned());
            this._pinToggle.setIcon(icon);
        }
        this._toolbar.addSeparator();
        this._toolbar.add(Box.createHorizontalStrut(5));
        this._toolbar.add(new ToggleAction(Messages.getString("IndexAdvisor.saveIndices"), this._fileSaveIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(Messages.getString("IndexAdvisor.saveIndices"));
                jFileChooser.setFileSelectionMode(0);
                String string = WorksheetIndexAdvisorPanel.getConnectionName(WorksheetIndexAdvisorPanel.this.theContext);
                File file = IndexAdvisorHelper.getFileName(string, HOME_DIR);
                jFileChooser.setSelectedFile(file);
                int n = jFileChooser.showSaveDialog((Component)Ide.getMainWindow());
                if (n == 0) {
                    File file2 = jFileChooser.getSelectedFile();
                    WorksheetIndexAdvisorPanel.this.save(file2);
                }
            }
        });
        this._toolbar.addSeparator();
        this._toolbar.add(Box.createHorizontalStrut(5));
        this._statusPanel.setOpaque(false);
        this._statusLabel.setOpaque(false);
        this._toolbar.add((Component)this._statusPanel);
    }

    private void saveAll(String string) {
        String string2 = WorksheetIndexAdvisorPanel.getConnectionName(this.theContext);
        File[] fileArray = IndexAdvisorHelper.getFileNames(string2, string);
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(this.theContext.getConnectionName());
        }
        catch (DBException dBException) {
            LOGGER.log(Level.SEVERE, "Error while getting connection", dBException);
        }
        String[] stringArray = IndexAdvisorHelper.getHeaders(connection, string2);
        this.theIndexAdvice.save(fileArray[0], stringArray);
        this.theStatisticsPane.save(fileArray[1], stringArray);
    }

    private void save(File file) {
        String string = WorksheetIndexAdvisorPanel.getConnectionName(this.theContext);
        String[] stringArray = IndexAdvisorHelper.getHeaders(IndexAdvisorTask.getConnection(this.theContext), string);
        this.theIndexAdvice.save(file, stringArray);
    }

    private JPanel createSqlPanel() {
        this.theSqlPane = WorksheetIndexAdvisorPanel.createEditorPane();
        JScrollPane jScrollPane = new JScrollPane((Component)this.theSqlPane, 22, 32);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 10, 10, 10), 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    public static BasicEditorPane createEditorPane() {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        basicEditorPane.setAutoscrolls(true);
        basicEditorPane.setEditable(false);
        BasicDocument basicDocument = new BasicDocument("foo1.plsql");
        basicEditorPane.setDocument((Document)basicDocument);
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        HighlightEditorPlugin highlightEditorPlugin = new HighlightEditorPlugin();
        basicEditorPane.installPlugin((EditorPlugin)lineGutterPlugin);
        basicEditorPane.installPlugin((EditorPlugin)highlightEditorPlugin);
        basicEditorPane.setText("");
        return basicEditorPane;
    }

    public void tabClosed() {
    }

    public String getLastStatusMessage() {
        return "Last status message";
    }

    public void registerConsumer(IStatusMessageConsumer iStatusMessageConsumer) {
    }

    public void publishStatusMessage(String string, Exception exception) {
    }

    public String getTabLabel() {
        return Messages.getString("IndexAdvisor.timestenIndexAdvisor");
    }

    public void setTabLabel(String string) {
    }

    public String getTabToolTip() {
        return Messages.getString("IndexAdvisor.timestenIndexAdvisor");
    }

    public Icon getTabIcon() {
        if (this.m_overlayIcon != null) {
            return this.m_overlayIcon;
        }
        return RaptorImage.getIcon((String)RaptorImagesArb.getString((String)"SQL_TUNING_ADVISOR"));
    }

    public JMenuItem[] getTabDynamicCtxMenu(WorksheetResultPanel[] worksheetResultPanelArray) {
        return this.theMenuItems;
    }

    public JComponent getGUI() {
        return this;
    }

    public WorksheetState getState() {
        return this.m_state;
    }

    public void setState(WorksheetState worksheetState) {
        this.m_state = worksheetState;
    }

    public boolean isCloseable() {
        return true;
    }

    public boolean isPinned() {
        return false;
    }

    public void setPinned(boolean bl) {
    }

    public String getID() {
        return "TimesTen Index Advisor";
    }

    public void setContext(WorksheetContext worksheetContext) {
    }

    public void setOverlayIcon(Icon icon) {
        this.overlayIcon = icon;
    }

    public WorksheetContext getContext() {
        return null;
    }

    public void displayAdvice(final String[] stringArray, final Connection connection) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.displayAdviceHelper(stringArray, connection);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WorksheetIndexAdvisorPanel.this.displayAdviceHelper(stringArray, connection);
                }
            });
        }
    }

    private void displayAdviceHelper(String[] stringArray, Connection connection) {
        this.setSql(stringArray);
        this.generateAdvice(connection);
        this.dropIndexAdvisorData(connection);
    }

    private void setSql(String[] stringArray) {
        Document document = this.theSqlPane.getDocument();
        String string = TimesTenUtil.getLineSeparator();
        try {
            for (String string2 : stringArray) {
                document.insertString(document.getLength(), string2 + ";" + string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.SEVERE, "Can't write into field", badLocationException);
        }
    }

    private void generateAdvice(Connection connection) {
        this.theIndexAdvice.generateAdvice();
        this.theIndexAdvice.displayFeedback(this);
    }

    private void generateStatistics(Connection connection) {
        this.theStatisticsPane.generateStatistics(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropIndexAdvisorData(Connection connection) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            Connections.getInstance().lock(connection);
            statement.execute(CAPTURE_DROP_SQL);
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, "Can't drop captures", sQLException);
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, "Error on closing statement", sQLException);
            }
        }
        Connections.getInstance().unlock(connection);
    }

    public class IndexAdvisorTaskListner
    extends RaptorTaskAdapter {
        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.showError(raptorTaskEvent);
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            this.showError(raptorTaskEvent);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            if (raptorTaskEvent.getTaskDescriptor().isCancelled()) {
                this.showError(raptorTaskEvent);
            } else {
                WorksheetIndexAdvisorPanel.this.setOverlayIcon(null);
                this.removeTask(raptorTaskEvent);
            }
        }

        public void taskPaused(RaptorTaskEvent raptorTaskEvent) {
            WorksheetIndexAdvisorPanel.this.setOverlayIcon(WorksheetIndexAdvisorPanel.this._waitingIcon);
        }

        public void taskRunning(RaptorTaskEvent raptorTaskEvent) {
            WorksheetIndexAdvisorPanel.this.setOverlayIcon(WorksheetIndexAdvisorPanel.this._runningIcon);
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            WorksheetIndexAdvisorPanel.this.setOverlayIcon(WorksheetIndexAdvisorPanel.this._waitingIcon);
        }

        public void messageChanged(RaptorTaskEvent raptorTaskEvent) {
            super.messageChanged(raptorTaskEvent);
        }

        public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
            super.progressChanged(raptorTaskEvent);
        }

        public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
            super.stateChanged(raptorTaskEvent);
        }

        private void removeTask(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JPanel jPanel = WorksheetIndexAdvisorPanel.this._statusPanel;
                    synchronized (jPanel) {
                        RaptorTaskDescriptor raptorTaskDescriptor = raptorTaskEvent.getTaskDescriptor();
                        if (!IRaptorTaskStatus.isAlive((IRaptorTaskStatus)raptorTaskDescriptor.getStatus())) {
                            WorksheetIndexAdvisorPanel.this._descUIMap.remove(raptorTaskDescriptor);
                            WorksheetIndexAdvisorPanel.this._statusPanel.add(Box.createHorizontalStrut(5));
                            WorksheetIndexAdvisorPanel.this._statusPanel.add(WorksheetIndexAdvisorPanel.this._statusLabel);
                            this.updateTimer(raptorTaskEvent.getTaskDescriptor().getElapsedTime());
                            WorksheetIndexAdvisorPanel.this._toolbar.revalidate();
                            WorksheetIndexAdvisorPanel.this._toolbar.repaint();
                        }
                    }
                }

                private void updateTimer(long l) {
                    float f = 0.0f;
                    if (l > 0L) {
                        f = Float.parseFloat("" + l) / 1000.0f;
                    }
                    Object[] objectArray = new Object[]{new Float(f)};
                    String string = MessageFormat.format(oracle.dbtools.worksheet.Messages.getString((String)"Worksheet.4"), objectArray);
                    WorksheetIndexAdvisorPanel.this._statusLabel.setText(string);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        private void showError(RaptorTaskEvent raptorTaskEvent) {
            WorksheetIndexAdvisorPanel.this.setOverlayIcon(WorksheetIndexAdvisorPanel.this._problemIcon);
            this.removeTask(raptorTaskEvent);
        }
    }
}

