/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.PreparedQuery;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCIndexCol;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCIndexesWithoutFloatsQuery;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreeNode;
import oracle.dbtools.raptor.utils.DBObject;

public abstract class CGCIndexesAbstractQuery
extends PreparedQuery {
    public CGCIndexesAbstractQuery(DBObject dBObject, String string) {
        super(dBObject, string);
    }

    public void executeQuery(CGCTableTreeNode cGCTableTreeNode) {
        DialogBase.LOUD("CGCIndexesAbstractQuery for " + cGCTableTreeNode);
        try {
            this._p3m.setup();
            this._stmt.setString(1, cGCTableTreeNode.getRealOwnerName());
            this._stmt.setString(2, cGCTableTreeNode.getRealTableName());
            DialogBase.LOUD("  CGCIndexesAbstractQuery executeQuery");
            ResultSet resultSet = this._stmt.executeQuery();
            DialogBase.LOUD("  ...CGCIndexesAbstractQuery executeQuery done");
            ArrayList<CGCIndexCol> arrayList = new ArrayList<CGCIndexCol>();
            while (resultSet.next()) {
                DialogBase.LOUD("  CGCIndexesAbstractQuery adding to collection");
                arrayList.add(new CGCIndexCol(resultSet));
            }
            resultSet.close();
            CGCIndexCol[] cGCIndexColArray = arrayList.toArray(new CGCIndexCol[arrayList.size()]);
            DialogBase.LOUD("  CGCIndexesAbstractQuery setIndex");
            if (this instanceof CGCIndexesWithoutFloatsQuery) {
                cGCTableTreeNode.setIndexWithoutFloat(cGCIndexColArray);
            } else {
                cGCTableTreeNode.setIndexWithFloat(cGCIndexColArray);
            }
            DialogBase.LOUD("  ...CGCIndexesAbstractQuery setIndex done");
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        try {
            this._p3m.restore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DialogBase.LOUD("... CGCIndexesAbstractQuery for " + cGCTableTreeNode + " done");
    }
}

