/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.Element;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.utils.SqlLikeConditionToRegex;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class DBDetailedConnectionsPanel
extends JPanel {
    private String[] COLUMN_TITLES = new String[]{Messages.getString("TimesTenGrid.element"), Messages.getString("TimesTenGrid.connType"), Messages.getString("TimesTenGrid.connName"), "PID"};
    private final int CONN_NAME_COL = 2;
    private final int CONN_TYPE_COL = 1;
    private final int PID_COL = 3;
    private final int EL_ID_COL = 0;
    private static final int DIALOG_WIDTH = 900;
    private static final int DIALOG_HEIGHT = 600;
    private JTable _connTable;
    private JComboBox<String> _elementsCmb;
    private JLabel _elementsCmbSelection;
    private JLabel _filterConnectionName;
    private JTextField _connectionName;
    private JPanel _filterPanel;
    private JCheckBox _systemConnections;
    private JSplitPane _splitPane;
    private JPanel _detailsPanel;
    private JLabel _elementLabel;
    private JLabel _hostLabel;
    private JLabel _instanceLabel;
    private JLabel _connIdLabel;
    private JLabel _connNameLabel;
    private JLabel _PIDLabel;
    private JLabel _typeLabel;
    private JLabel _extraInfoLabel1;
    private JLabel _extraInfoLabel2;
    private JLabel _extraInfoLabel3;
    private JLabel _extraInfoLabel4;
    private JLabel _elementLabelVal;
    private JLabel _hostLabelVal;
    private JLabel _instanceLabelVal;
    private JLabel _connIdLabelVal;
    private JLabel _connNameLabelVal;
    private JLabel _PIDLabelVal;
    private JLabel _typeLabelVal;
    private JLabel _extraInfoLabel1Val;
    private JLabel _extraInfoLabel2Val;
    private JLabel _extraInfoLabel3Val;
    private JLabel _extraInfoLabel4Val;
    private TableRowSorter<AbstractTableModel> _sorter;

    public static void showDetailedConnections(DatabaseObject databaseObject) {
        GridObject gridObject = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
        boolean bl = Common.gridVersionGreaterThanOrEqual(gridObject, "18.1.1.3.0");
        Runnable runnable = () -> {
            DBDetailedConnectionsPanel dBDetailedConnectionsPanel = new DBDetailedConnectionsPanel(databaseObject);
            JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)dBDetailedConnectionsPanel, (String)databaseObject.getName(), null);
            jEWTDialog.setButtonMask(5);
            Dimension dimension = new Dimension(900, 600);
            jEWTDialog.setSize(dimension);
            jEWTDialog.setMinimumSize(dimension);
            jEWTDialog.setPreferredSize(dimension);
            jEWTDialog.setMaximumSize(dimension);
            jEWTDialog.setDefaultCloseOperation(2);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            jEWTDialog.setVisible(true);
        };
        if (bl) {
            runnable.run();
        } else {
            gridObject.updateDBConnectionsOnSwingWorker(databaseObject, runnable);
        }
    }

    public DBDetailedConnectionsPanel(DatabaseObject databaseObject) {
        GridObject gridObject = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
        boolean bl = Common.gridVersionGreaterThanOrEqual(gridObject, "18.1.1.3.0");
        this.setLayout(new GridBagLayout());
        this._elementsCmbSelection = new JLabel(Messages.getString("TimesTenGrid.instanceColumn"));
        this._elementsCmb = new JComboBox();
        this._elementsCmb.addItem(Messages.getString("TimesTenGrid.allInstances"));
        for (Element object2 : databaseObject.getAllElements()) {
            this._elementsCmb.addItem(object2.toString());
        }
        this._elementsCmb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ((AbstractTableModel)DBDetailedConnectionsPanel.this._connTable.getModel()).fireTableDataChanged();
            }
        });
        this._systemConnections = new JCheckBox(Messages.getString("TimesTenGrid.systemConnections"));
        this._systemConnections.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ((AbstractTableModel)DBDetailedConnectionsPanel.this._connTable.getModel()).fireTableDataChanged();
            }
        });
        this._connTable = new JTable(new ConnectionTableModel(databaseObject)){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                string = DBDetailedConnectionsPanel.this._connTable.getValueAt(n, n2).toString();
                return string;
            }
        };
        ConnectionTableModel connectionTableModel = (ConnectionTableModel)this._connTable.getModel();
        GridObject gridObject2 = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
        if (bl) {
            this.detailsPanelSetup();
            this._connTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
                if (this._connTable.getSelectedRow() < 0) {
                    return;
                }
                int n = this._connTable.getSelectedRow();
                DatabaseObject.ElementConnection elementConnection = connectionTableModel.getRowAt(n);
                this.setDetails(elementConnection);
            });
        }
        this._sorter = new TableRowSorter<Object>(connectionTableModel);
        this._connTable.setRowSorter(this._sorter);
        this._filterPanel = new JPanel(new GridBagLayout());
        this._filterConnectionName = new JLabel(Messages.getString("TimesTenGrid.connectionName"));
        this._connectionName = new JTextField();
        this._connectionName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                DBDetailedConnectionsPanel.this.connNameFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                DBDetailedConnectionsPanel.this.connNameFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                DBDetailedConnectionsPanel.this.connNameFilter();
            }
        });
        this.add((Component)this._elementsCmbSelection, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._elementsCmb, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._systemConnections, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)(bl ? this._splitPane : new JScrollPane(this._connTable)), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._filterPanel.add((Component)this._filterConnectionName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._filterPanel.add((Component)this._connectionName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._filterPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.connDetails")));
        this._filterPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.filterConnection")));
        TableColumnSizer.setColumnsWidthToFit(this._connTable, true, true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.DB_CONNECTIONS.toString());
    }

    private void clearDetails() {
        this._elementLabelVal.setText("");
        this._hostLabelVal.setText("");
        this._instanceLabelVal.setText("");
        this._connIdLabelVal.setText("");
        this._PIDLabelVal.setText("");
        this._typeLabelVal.setText("");
        this._extraInfoLabel1Val.setText("");
        this._extraInfoLabel2Val.setText("");
        this._extraInfoLabel3Val.setText("");
        this._extraInfoLabel4Val.setText("");
        this._extraInfoLabel1.setText("");
        this._extraInfoLabel2.setText("");
        this._extraInfoLabel3.setText("");
        this._extraInfoLabel4.setText("");
    }

    private void setDetails(DatabaseObject.ElementConnection elementConnection) {
        this.clearDetails();
        this._elementLabelVal.setText(Integer.toString(elementConnection.getElement().getId()));
        this._hostLabelVal.setText(elementConnection.getHost());
        this._instanceLabelVal.setText(elementConnection.getInstance());
        this._connIdLabelVal.setText(Integer.toString(elementConnection.getConnId()));
        this._connNameLabelVal.setText(elementConnection.getConnectionName());
        this._PIDLabelVal.setText(Integer.toString(elementConnection.getPID()));
        this._typeLabelVal.setText(elementConnection.getContype());
        if ("C/S".equals(elementConnection.getContype())) {
            this._extraInfoLabel1.setText(Messages.getString("TimesTenGrid.ConnectionDetailsClientHost"));
            this._extraInfoLabel2.setText(Messages.getString("TimesTenGrid.ConnectionDetailsClientAddress"));
            this._extraInfoLabel3.setText(Messages.getString("TimesTenGrid.ConnectionDetailsClientPID"));
            this._extraInfoLabel1Val.setText(elementConnection.getClientHost());
            this._extraInfoLabel2Val.setText(elementConnection.getClientAddress());
            this._extraInfoLabel3Val.setText(Integer.toString(elementConnection.getClientPID()));
        }
        if ("Proxy".equals(elementConnection.getContype())) {
            this._extraInfoLabel1.setText(Messages.getString("TimesTenGrid.ConnectionDetailsProxyHost"));
            this._extraInfoLabel2.setText(Messages.getString("TimesTenGrid.ConnectionDetailsProxyInstance"));
            this._extraInfoLabel3.setText(Messages.getString("TimesTenGrid.ConnectionDetailsProxyPID"));
            this._extraInfoLabel4.setText(Messages.getString("TimesTenGrid.ConnectionDetailsProxyConnectionID"));
            this._extraInfoLabel1Val.setText(elementConnection.getProxyHost());
            this._extraInfoLabel2Val.setText(elementConnection.getProxyInstance());
            this._extraInfoLabel3Val.setText(Integer.toString(elementConnection.getProxyPID()));
            this._extraInfoLabel4Val.setText(Integer.toString(elementConnection.getProxyConnID()));
        }
    }

    private JPanel mergeLabels(JLabel jLabel, JLabel jLabel2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        return jPanel;
    }

    private void makeBold(JLabel jLabel) {
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(font.getStyle() | 1));
    }

    private void detailsPanelSetup() {
        this._elementLabel = new JLabel(Messages.getString("TimesTenGrid.ConnectionDetailsElement"));
        this._hostLabel = new JLabel(Messages.getString("TimesTenGrid.ConnectionDetailsHost"));
        this._instanceLabel = new JLabel(Messages.getString("TimesTenGrid.ConnectionDetailsInstance"));
        this._connIdLabel = new JLabel(Messages.getString("TimesTenGrid.ConnectionDetailsConnId"));
        this._connNameLabel = new JLabel(Messages.getString("TimesTenGrid.ConnectionDetailsConnName"));
        this._PIDLabel = new JLabel(Messages.getString("TimesTenGrid.ConnectionDetailsPID"));
        this._typeLabel = new JLabel(Messages.getString("TimesTenGrid.ConnectionDetailsType"));
        this._extraInfoLabel1 = new JLabel();
        this._extraInfoLabel2 = new JLabel();
        this._extraInfoLabel3 = new JLabel();
        this._extraInfoLabel4 = new JLabel();
        this.makeBold(this._elementLabel);
        this.makeBold(this._hostLabel);
        this.makeBold(this._instanceLabel);
        this.makeBold(this._connIdLabel);
        this.makeBold(this._connNameLabel);
        this.makeBold(this._PIDLabel);
        this.makeBold(this._typeLabel);
        this.makeBold(this._extraInfoLabel1);
        this.makeBold(this._extraInfoLabel2);
        this.makeBold(this._extraInfoLabel3);
        this.makeBold(this._extraInfoLabel4);
        this._elementLabelVal = new JLabel();
        this._hostLabelVal = new JLabel();
        this._instanceLabelVal = new JLabel();
        this._connIdLabelVal = new JLabel();
        this._connNameLabelVal = new JLabel();
        this._PIDLabelVal = new JLabel();
        this._typeLabelVal = new JLabel();
        this._extraInfoLabel1Val = new JLabel();
        this._extraInfoLabel2Val = new JLabel();
        this._extraInfoLabel3Val = new JLabel();
        this._extraInfoLabel4Val = new JLabel();
        this._detailsPanel = new JPanel();
        this._detailsPanel.setLayout(new GridBagLayout());
        this._detailsPanel.add((Component)this.mergeLabels(this._elementLabel, this._elementLabelVal), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 0, new Insets(10, 10, 0, 0), 0, 0));
        this._detailsPanel.add((Component)this.mergeLabels(this._hostLabel, this._hostLabelVal), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        this._detailsPanel.add((Component)this.mergeLabels(this._instanceLabel, this._instanceLabelVal), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        this._detailsPanel.add((Component)this.mergeLabels(this._connIdLabel, this._connIdLabelVal), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        this._detailsPanel.add((Component)this.mergeLabels(this._connNameLabel, this._connNameLabelVal), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        this._detailsPanel.add((Component)this.mergeLabels(this._PIDLabel, this._PIDLabelVal), new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        this._detailsPanel.add((Component)this.mergeLabels(this._typeLabel, this._typeLabelVal), new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        this._detailsPanel.add((Component)this.mergeLabels(this._extraInfoLabel1, this._extraInfoLabel1Val), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 0, new Insets(10, 0, 0, 0), 0, 0));
        this._detailsPanel.add((Component)this.mergeLabels(this._extraInfoLabel2, this._extraInfoLabel2Val), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._detailsPanel.add((Component)this.mergeLabels(this._extraInfoLabel3, this._extraInfoLabel3Val), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._detailsPanel.add((Component)this.mergeLabels(this._extraInfoLabel4, this._extraInfoLabel4Val), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._splitPane = new JSplitPane(0, new JScrollPane(this._connTable), this._detailsPanel);
        this._splitPane.setOneTouchExpandable(true);
        this._splitPane.setResizeWeight(0.99);
        this._splitPane.setDividerLocation(0.99);
    }

    private void connNameFilter() {
        RowFilter rowFilter = null;
        String string = this._connectionName.getText();
        SqlLikeConditionToRegex sqlLikeConditionToRegex = new SqlLikeConditionToRegex();
        string = sqlLikeConditionToRegex.parse(string);
        try {
            rowFilter = RowFilter.regexFilter(string, 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
        this._sorter.setRowFilter(rowFilter);
    }

    private void setNames() {
        this._elementsCmb.setName("_elementsCmb");
        this._elementsCmbSelection.setName(Messages.getString("TimesTenGrid.instanceColumn"));
        this._filterConnectionName.setName(Messages.getString("TimesTenGrid.connectionName"));
        this._connectionName.setName("_connectionName");
        this._systemConnections.setName(Messages.getString("TimesTenGrid.systemConnections"));
    }

    private class IconTextCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private IconTextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setIcon(null);
            if ("C/S".equals(object) || "Proxy".equals(object)) {
                jLabel.setIcon(Common.DOWN_ICON);
            }
            jLabel.setText(object.toString());
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }
    }

    private class ConnectionTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private DatabaseObject db;

        public ConnectionTableModel(DatabaseObject databaseObject) {
            this.db = databaseObject;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        private List<DatabaseObject.ElementConnection> filterAppConnections(List<DatabaseObject.ElementConnection> list) {
            return list.stream().filter(elementConnection -> elementConnection.isAppConnection()).collect(Collectors.toList());
        }

        private List<DatabaseObject.ElementConnection> getElementsFromSelectedItem() {
            List<DatabaseObject.ElementConnection> list;
            if (DBDetailedConnectionsPanel.this._elementsCmb.getSelectedItem().equals(Messages.getString("TimesTenGrid.allInstances"))) {
                list = this.db.getElementsConnections();
            } else {
                Element element = this.db.getElementByInstanceName(DBDetailedConnectionsPanel.this._elementsCmb.getSelectedItem().toString());
                list = this.db.getElementsConnections(element);
            }
            if (!DBDetailedConnectionsPanel.this._systemConnections.isSelected()) {
                return this.filterAppConnections(list);
            }
            return list;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 2: {
                    return this.getElementsFromSelectedItem().get(n).getConnectionName();
                }
                case 1: {
                    return this.getElementsFromSelectedItem().get(n).getContype();
                }
                case 3: {
                    return this.getElementsFromSelectedItem().get(n).getPID();
                }
                case 0: {
                    return this.getElementsFromSelectedItem().get(n).getElement().getId();
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.getElementsFromSelectedItem().size();
        }

        @Override
        public String getColumnName(int n) {
            return DBDetailedConnectionsPanel.this.COLUMN_TITLES[n];
        }

        @Override
        public int getColumnCount() {
            return DBDetailedConnectionsPanel.this.COLUMN_TITLES.length;
        }

        public DatabaseObject.ElementConnection getRowAt(int n) {
            return this.getElementsFromSelectedItem().get(DBDetailedConnectionsPanel.this._sorter.convertRowIndexToModel(n));
        }
    }
}

