/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.AnalysisPropHelper;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;
import java.util.List;

public abstract class has_absent_tablespaces
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_absent_tablespaces.class.getName());
    protected List<String> defaultList;
    protected List<String> tablespaceColumnNames;

    protected has_absent_tablespaces() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("USERNAME").objectNameColumn("USERNAME").objectTypeFixed("USER").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        AnalysisPropHelper propHelper = new AnalysisPropHelper(exeCtx, this.defaultList, this.tablespaceColumnNames);
        if (propHelper.isMigrationMethodMappingAll()) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_MIGRATION_METHOD_TABLESPACE_MAPPING_ALL", this.getName()), CheckResult.PASS);
        }
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "USERNAME");
        String andClause = propHelper.getTablespaceAndClause();
        String selectColumns = Utilities.join(",", this.tablespaceColumnNames);
        String sqlQuery = "SELECT USERNAME, " + selectColumns + " FROM SYS.DBA_USERS" + whereClause + andClause + " ORDER BY 1";
        this.setSqlQuery(sqlQuery);
    }
}

