/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.json.serialization;

import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.json.CpatJsonIgnore;
import com.oracle.premigration.reports.json.CpatJsonIgnoreIfNull;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;

public class JsonSerializer {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(JsonSerializer.class.getName());

    public String writeJSON(Object reportData, String jsonOutputFilename) throws IOException {
        JsonStructure jsonReport = (JsonStructure)this.toJson(reportData);
        File reportFile = new File(jsonOutputFilename);
        FileWriter fileWriter = new FileWriter(reportFile);
        JsonWriter writer = Json.createWriter(fileWriter);
        writer.write(jsonReport);
        writer.close();
        return reportFile.getCanonicalPath();
    }

    private JsonValue toJson(Object object) {
        JsonStructure returnResult;
        if (object instanceof List) {
            List list = (List)object;
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (Object element : list) {
                if (this.isSimpleType(element)) {
                    this.addSimpleJsonValue(null, arrayBuilder, null, element);
                    continue;
                }
                arrayBuilder.add(this.toJson(element));
            }
            returnResult = arrayBuilder.build();
        } else if (object instanceof Map) {
            Map map = (Map)object;
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object mapObj = entry.getValue();
                if (this.isSimpleType(mapObj)) {
                    this.addSimpleJsonValue(objectBuilder, null, key.toString(), mapObj);
                    continue;
                }
                objectBuilder.add(key.toString(), this.toJson(map.get(key)));
            }
            returnResult = objectBuilder.build();
        } else {
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            Class<?> clazz = object.getClass();
            for (Method getter : clazz.getMethods()) {
                Object value;
                if (JsonSerializer.isInappropriateMethod(getter)) continue;
                String name = JsonSerializer.getterNameToJsonFieldName(getter.getName());
                try {
                    value = getter.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    System.err.println(e);
                    continue;
                }
                if (value == null) {
                    if (getter.isAnnotationPresent(CpatJsonIgnoreIfNull.class)) continue;
                    objectBuilder.add(name, "");
                    continue;
                }
                if (this.isSimpleType(value)) {
                    this.addSimpleJsonValue(objectBuilder, null, name, value);
                    continue;
                }
                objectBuilder.add(name, this.toJson(value));
            }
            returnResult = objectBuilder.build();
        }
        return returnResult;
    }

    private void addSimpleJsonValue(JsonObjectBuilder objectBuilder, JsonArrayBuilder arrayBuilder, String objectName, Object object) {
        if (object == null) {
            if (objectBuilder != null) {
                objectBuilder.add(objectName, JsonValue.NULL);
            } else {
                arrayBuilder.add(JsonValue.NULL);
            }
        } else if (object instanceof String) {
            if (objectBuilder != null) {
                objectBuilder.add(objectName, (String)object);
            } else {
                arrayBuilder.add((String)object);
            }
        } else if (object instanceof Enum) {
            if (objectBuilder != null) {
                objectBuilder.add(objectName, ((Enum)object).name());
            } else {
                arrayBuilder.add(((Enum)object).name());
            }
        } else if (object instanceof Date) {
            if (objectBuilder != null) {
                objectBuilder.add(objectName, Utilities.getISODateTimeString(object));
            } else {
                arrayBuilder.add(Utilities.getISODateTimeString(object));
            }
        } else if (object instanceof Integer) {
            if (objectBuilder != null) {
                objectBuilder.add(objectName, (Integer)object);
            } else {
                arrayBuilder.add((Integer)object);
            }
        } else if (object instanceof Boolean) {
            if (objectBuilder != null) {
                objectBuilder.add(objectName, (Boolean)object != false ? JsonValue.TRUE : JsonValue.FALSE);
            } else {
                arrayBuilder.add((Boolean)object != false ? JsonValue.TRUE : JsonValue.FALSE);
            }
        } else if (object instanceof Float) {
            if (objectBuilder != null) {
                objectBuilder.add(objectName, ((Float)object).floatValue());
            } else {
                arrayBuilder.add(((Float)object).floatValue());
            }
        } else if (object instanceof Double) {
            if (objectBuilder != null) {
                objectBuilder.add(objectName, (Double)object);
            } else {
                arrayBuilder.add((Double)object);
            }
        } else if (object instanceof Long) {
            if (objectBuilder != null) {
                objectBuilder.add(objectName, (Long)object);
            } else {
                arrayBuilder.add((Long)object);
            }
        } else {
            String wth = "Something went wrong and addSimpleJson was passed something inappropriate.  Class: " + object.getClass() + ", value: " + object.toString();
            if (objectBuilder != null) {
                objectBuilder.add(objectName, wth);
            } else {
                arrayBuilder.add(wth);
            }
        }
    }

    private boolean isSimpleType(Object object) {
        return object == null || object instanceof String || object instanceof Enum || object instanceof Date || object instanceof Integer || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof Long;
    }

    private static boolean isInappropriateMethod(Method getter) {
        return !getter.getName().startsWith("get") || getter.getParameterTypes().length > 0 || getter.getDeclaringClass() == Object.class || getter.isAnnotationPresent(CpatJsonIgnore.class);
    }

    private static String getterNameToJsonFieldName(String getterName) {
        return getterName.substring(3, 4).toLowerCase() + getterName.substring(4);
    }
}

