/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectListener;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObjectListener;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractDBObject
implements DBObject {
    private final ListenerSupport m_listenerSupport = new ListenerSupport();
    private final PropertySupport m_properties;
    private DBObjectID m_id;
    private Executor m_propertyExecutor = AbstractDBObject.createDefaultExecutor();
    private Holder<oracle.javatools.db.event.DBObjectChange> m_compoundChange;
    private boolean m_compoundChangeProcessing;
    private DBObject m_parent;
    private Schema m_schema;

    protected AbstractDBObject() {
        this(null, null);
    }

    protected AbstractDBObject(String string) {
        this(string, null);
    }

    protected AbstractDBObject(String string, DBObjectID dBObjectID) {
        this.m_properties = this.createPropertySupport();
        this.setName(string);
        this.setID(dBObjectID);
    }

    PropertySupport createPropertySupport() {
        return new PropertySupport();
    }

    PropertySupport getPropertySupport() {
        return this.m_properties;
    }

    @Override
    public final void addObjectListener(oracle.javatools.db.event.DBObjectListener dBObjectListener) {
        this.m_listenerSupport.addObjectListener(dBObjectListener);
    }

    @Override
    public final void removeObjectListener(oracle.javatools.db.event.DBObjectListener dBObjectListener) {
        this.m_listenerSupport.removeObjectListener(dBObjectListener);
    }

    final void replacePropertyExecutor(Executor executor) {
        if (executor != null) {
            this.m_propertyExecutor = executor;
        }
    }

    final Executor getPropertyExecutor() {
        return this.m_propertyExecutor;
    }

    final void invokeCompoundChange(Runnable runnable, boolean bl) {
        if (runnable != null) {
            this.invokeCompoundChangeImpl(runnable, null, bl);
        }
    }

    private oracle.javatools.db.event.DBObjectChange invokeCompoundChangeImpl(final Runnable runnable, final oracle.javatools.db.event.DBObjectChange dBObjectChange, boolean bl) {
        final Holder holder = new Holder();
        final Holder holder2 = new Holder((Object)false);
        this.m_propertyExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AbstractDBObject.this.m_compoundChange != null) {
                    holder2.set((Object)true);
                    if (runnable == null) {
                        AbstractDBObject.this.m_compoundChange.set((Object)oracle.javatools.db.event.DBObjectChange.merge(dBObjectChange, (oracle.javatools.db.event.DBObjectChange)AbstractDBObject.this.m_compoundChange.get()));
                    } else {
                        runnable.run();
                    }
                } else {
                    AbstractDBObject.this.m_compoundChange = new Holder();
                    try {
                        if (runnable == null) {
                            AbstractDBObject.this.m_compoundChange.set((Object)dBObjectChange);
                        } else {
                            runnable.run();
                        }
                    }
                    finally {
                        oracle.javatools.db.event.DBObjectChange dBObjectChange2 = (oracle.javatools.db.event.DBObjectChange)AbstractDBObject.this.m_compoundChange.get();
                        if (!AbstractDBObject.this.m_compoundChangeProcessing && dBObjectChange2 != null) {
                            AbstractDBObject.this.m_compoundChangeProcessing = true;
                            try {
                                AbstractDBObject.this.processChange(dBObjectChange2);
                            }
                            finally {
                                AbstractDBObject.this.m_compoundChangeProcessing = false;
                            }
                        }
                        holder.set((Object)((oracle.javatools.db.event.DBObjectChange)AbstractDBObject.this.m_compoundChange.get()));
                        AbstractDBObject.this.m_compoundChange = null;
                    }
                }
            }
        });
        oracle.javatools.db.event.DBObjectChange dBObjectChange2 = (oracle.javatools.db.event.DBObjectChange)holder.get();
        if (dBObjectChange2 != null && !((Boolean)holder2.get()).booleanValue() && bl && this.fireListeners(dBObjectChange)) {
            this.notifyListeners(dBObjectChange2);
        }
        return dBObjectChange2;
    }

    void processChange(oracle.javatools.db.event.DBObjectChange dBObjectChange) {
    }

    public final void fireObjectUpdated(oracle.javatools.db.event.DBObjectChange dBObjectChange) {
        if (dBObjectChange != null && this.fireListeners(dBObjectChange)) {
            this.invokeCompoundChangeImpl(null, dBObjectChange, true);
        }
    }

    boolean fireListeners(oracle.javatools.db.event.DBObjectChange dBObjectChange) {
        return true;
    }

    private void notifyListeners(final oracle.javatools.db.event.DBObjectChange dBObjectChange) {
        String string;
        this.m_listenerSupport.fireObjectUpdated(dBObjectChange);
        DBObject dBObject = this.getParent();
        if (dBObject instanceof AbstractDBObject && (string = DBUtil.getParentProperty(this)) != null) {
            oracle.javatools.db.event.DBObjectChange dBObjectChange2 = new oracle.javatools.db.event.DBObjectChange(dBObject, dBObjectChange.getProvider()){

                @Override
                public Map<DBObject, oracle.javatools.db.event.DBObjectChange> getOwnedObjectsUpdated() {
                    return Collections.singletonMap(AbstractDBObject.this, dBObjectChange);
                }

                @Override
                public Collection<String> getAllChangedProperties() {
                    return Collections.singleton(string);
                }
            };
            ((AbstractDBObject)dBObject).fireObjectUpdated(dBObjectChange2);
        }
    }

    @Deprecated
    public final void addObjectListener(DBObjectListener dBObjectListener) {
        this.m_listenerSupport.addBridgedListener(dBObjectListener);
    }

    @Deprecated
    public final void removeObjectListener(DBObjectListener dBObjectListener) {
        this.m_listenerSupport.removeBridgedListener(dBObjectListener);
    }

    @Deprecated
    public final void removeObjectListener(SchemaObjectListener schemaObjectListener) {
        this.m_listenerSupport.removeBridgedListener(schemaObjectListener);
    }

    @Deprecated
    public final void addObjectListener(SchemaObjectListener schemaObjectListener) {
        this.m_listenerSupport.addBridgedListener(schemaObjectListener);
    }

    @Override
    public final Object copyTo(Object object) {
        DBObject dBObject = object != null && (TemporaryObjectID.getOriginalObject(this) == object || this.m_id instanceof TemporaryObjectID && TemporaryObjectID.findOriginalObject((TemporaryObjectID)this.m_id) == object) ? this.copyTo((DBObject)object, new TemporaryObjectID.CopyBackPolicy()) : this.copyTo((DBObject)object, false);
        return dBObject;
    }

    @Override
    public final DBObject copyTo(DBObject dBObject, boolean bl) {
        return this.copyTo(dBObject, bl ? new TemporaryObjectID.TemporaryIDPolicy() : new IDPolicy.DefaultIDPolicy());
    }

    @Override
    public final DBObject copyTo(DBObject dBObject, IDPolicy iDPolicy) {
        DBObject dBObject2 = null;
        if (dBObject instanceof ChildDBObject) {
            dBObject2 = dBObject.getParent();
        }
        if (dBObject2 == null && this instanceof ChildDBObject) {
            dBObject2 = this.getParent();
        }
        AbstractDBObject abstractDBObject = (AbstractDBObject)this.copyTo(dBObject, dBObject2, iDPolicy);
        abstractDBObject.replaceReferenceIDsDirectly(iDPolicy.getIDMap());
        return abstractDBObject;
    }

    boolean replaceReferenceIDsDirectly(Map<DBObjectID, DBObjectID> map) {
        boolean bl = false;
        if (map != null && !map.isEmpty()) {
            bl = this.replaceReferenceIDs(map);
            for (DBObject dBObject : this.getPropertySupport().getOwnedObjects(new String[0])) {
                bl = ((AbstractDBObject)dBObject).replaceReferenceIDsDirectly(map) || bl;
            }
        }
        return bl;
    }

    protected final DBObject copyTo(DBObject dBObject, final DBObject dBObject2, final IDPolicy iDPolicy) {
        if (dBObject == null) {
            try {
                dBObject = (DBObject)this.getClass().newInstance();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Could not instantiate new object for copy", exception);
            }
        }
        final AbstractDBObject abstractDBObject = (AbstractDBObject)dBObject;
        abstractDBObject.invokeCompoundChange(new Runnable(){

            @Override
            public void run() {
                AbstractDBObject.this.copyToImpl(abstractDBObject, dBObject2, iDPolicy);
            }
        }, true);
        return dBObject;
    }

    protected void copyToImpl(AbstractDBObject abstractDBObject, DBObject dBObject, IDPolicy iDPolicy) {
        if (this == abstractDBObject) {
            throw new IllegalStateException("cannot copy an object to itself");
        }
        abstractDBObject.m_schema = this.m_schema;
        abstractDBObject.m_parent = dBObject;
        if (iDPolicy != null) {
            iDPolicy.copyID(this, abstractDBObject);
        }
        this.m_properties.copyTo(abstractDBObject.m_properties, iDPolicy);
    }

    protected <T> T copyObject(T t, DBObject dBObject, IDPolicy iDPolicy) {
        return DBUtil.copyPropertyValue(t, this, dBObject, iDPolicy);
    }

    @Override
    public final boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass().isAssignableFrom(object.getClass())) {
            bl = this.equalsImpl((AbstractDBObject)object);
        }
        return bl;
    }

    protected boolean equalsImpl(AbstractDBObject abstractDBObject) {
        return ModelUtil.areEqual((Object)this.getType(), (Object)abstractDBObject.getType()) && ModelUtil.areEqual((Object)this.getName(), (Object)abstractDBObject.getName()) && DBUtil.areNamesAndTypesEqual(this.m_schema, abstractDBObject.m_schema) && ModelUtil.areEqual((Object)this.m_properties, (Object)abstractDBObject.m_properties);
    }

    protected int compareToImpl(AbstractDBObject abstractDBObject) {
        String string = abstractDBObject.getName();
        String string2 = this.getName();
        return string2 == null ? (string == null ? 0 : -1) : (string == null ? 1 : string2.compareTo(string));
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int hashCode() {
        return this.getType().hashCode();
    }

    @Override
    public void setName(String string) {
        this.setProperty("name", string);
    }

    @Override
    @TextProperty(internalName=true)
    public String getName() {
        return (String)this.getProperty("name");
    }

    @Override
    @Internal
    public final DBObject getParent() {
        return (DBObject)this.getProperty("parent");
    }

    public final <T extends DBObject> T findParent(Class<T> clazz) {
        for (DBObject dBObject = this.getParent(); dBObject != null; dBObject = dBObject.getParent()) {
            if (!clazz.isAssignableFrom(dBObject.getClass())) continue;
            return (T)((DBObject)clazz.cast(dBObject));
        }
        return null;
    }

    @Override
    public void setID(DBObjectID dBObjectID) {
        if (dBObjectID instanceof TemporaryObjectID) {
            DBObject dBObject = ((TemporaryObjectID)dBObjectID).getOriginalObject();
            if (dBObject == this) {
                throw new IllegalStateException("an object's TemporaryObjectID cannot point back to itself as the original object.");
            }
            DBObject dBObject2 = ((TemporaryObjectID)dBObjectID).getDBObject();
            if (dBObject2 != this) {
                throw new IllegalStateException("an object's TemporaryObjectID must resolve to itself.");
            }
        }
        this.m_id = dBObjectID;
    }

    @Override
    public final DBObjectID getID() {
        DBObjectID dBObjectID = this.m_id;
        if (this.m_id != null && !(this.m_id instanceof TemporaryObjectID)) {
            dBObjectID = (DBObjectID)this.m_id.copyTo(null);
        }
        return dBObjectID;
    }

    final DBObjectID obtainActualID() {
        return this.m_id;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.m_properties;
    }

    @Override
    public Object getProperty(String string) {
        Object object = "type".equals(string) ? this.getType() : ("ID".equals(string) ? this.m_id : ("schema".equals(string) ? this.m_schema : ("parent".equals(string) ? this.m_parent : ("properties".equals(string) ? this.getProperties() : this.getProperties().get(string)))));
        return object;
    }

    @Override
    public final Object getProperty(String string, Object object) {
        Object object2 = this.getProperty(string);
        return object2 == null ? object : object2;
    }

    @Override
    public final void setProperties(Map<String, Object> map) {
        if (map != this.m_properties) {
            Iterator iterator = this.m_properties.keySet().iterator();
            while (iterator.hasNext()) {
                Class<?> clazz = this.getClass();
                while (clazz.isAnnotationPresent(Deprecated.class)) {
                    clazz = clazz.getSuperclass();
                }
                String string = (String)iterator.next();
                if (map.containsKey(string) || Metadata.getInstance().isBeanProperty(clazz, string)) continue;
                iterator.remove();
            }
            this.m_properties.putAll(map);
        }
    }

    @Override
    public void setProperty(String string, Object object) {
        if ("ID".equals(string)) {
            this.m_id = (DBObjectID)object;
        } else if ("schema".equals(string)) {
            Schema schema = this.m_schema;
            this.m_schema = (Schema)object;
            this.firePropertyChanged(string, schema, object);
        } else if ("parent".equals(string)) {
            this.m_parent = (DBObject)object;
        } else if (!"type".equals(string)) {
            this.m_properties.put(string, object);
        }
    }

    protected final void firePropertyChanged(final String string, Object object, Object object2) {
        boolean bl = object == object2 ? false : ("schema".equals(string) && object instanceof Schema && object2 instanceof Schema ? !DBUtil.areNamesAndTypesEqual((Schema)object, (Schema)object2) : ModelUtil.areDifferent((Object)object, (Object)object2));
        if (bl) {
            final PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            oracle.javatools.db.event.DBObjectChange dBObjectChange = new oracle.javatools.db.event.DBObjectChange(this, null){

                @Override
                public Map<String, PropertyChangeEvent> getPropertiesChanged() {
                    return Collections.singletonMap(string, propertyChangeEvent);
                }
            };
            this.fireObjectUpdated(dBObjectChange);
        }
    }

    protected final void removeThisAsParent(ChildDBObject childDBObject) {
        if (childDBObject != null && childDBObject.getParent() == this) {
            childDBObject.setParent(null);
        }
    }

    protected final void changeParent(ChildDBObject childDBObject, ChildDBObject childDBObject2) {
        this.removeThisAsParent(childDBObject);
        if (childDBObject2 != null) {
            childDBObject2.setParent(this);
        }
    }

    @Override
    public final DBObject[] getOwnedObjects() {
        return this.getOwnedObjects(null);
    }

    @Override
    public final DBObject[] getOwnedObjects(String ... stringArray) {
        String[] stringArray2 = stringArray;
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!"UNSPECIFIED_TYPE".equals(string)) continue;
                stringArray2 = null;
                break;
            }
        }
        ArrayList arrayList = new ArrayList();
        this.getOwnedObjectsImpl(arrayList, stringArray2);
        return arrayList.toArray(new DBObject[arrayList.size()]);
    }

    @Override
    public final DBObject findOwnedObject(String string, String string2) {
        DBObject dBObject = null;
        DBObject[] dBObjectArray = this.getOwnedObjects(string);
        for (int i = 0; i < dBObjectArray.length; ++i) {
            if (!ModelUtil.areEqual((Object)string2, (Object)dBObjectArray[i].getName())) continue;
            dBObject = dBObjectArray[i];
            break;
        }
        return dBObject;
    }

    @Override
    public final DBObject findOwnedObject(DBObjectID dBObjectID) {
        return this.findOwnedObject(dBObjectID, true);
    }

    @Override
    public DBObject findOwnedObject(DBObjectID dBObjectID, boolean bl) {
        return this.findOwnedObject(dBObjectID, bl, false);
    }

    protected final DBObject findOwnedObject(DBObjectID dBObjectID, boolean bl, boolean bl2) {
        DBObject dBObject = null;
        if (dBObjectID instanceof TemporaryObjectID) {
            DBObject dBObject2 = ((TemporaryObjectID)dBObjectID).getDBObject();
            if (dBObject2.getParent() == this) {
                dBObject = dBObject2;
            }
        } else if (dBObjectID != null) {
            DBObject dBObject3;
            int n;
            DBObject[] dBObjectArray = this.getOwnedObjects(dBObjectID.getType());
            int n2 = dBObjectArray.length;
            for (n = 0; !(n >= n2 || dBObjectID.equals((dBObject3 = dBObjectArray[n]).getID(), bl) && (dBObject = dBObject3) != null); ++n) {
            }
            if (bl2 && dBObject == null) {
                dBObjectArray = this.getOwnedObjects();
                n2 = dBObjectArray.length;
                for (n = 0; !(n >= n2 || (dBObject3 = dBObjectArray[n]) instanceof AbstractDBObject && (dBObject = ((AbstractDBObject)dBObject3).findOwnedObject(dBObjectID, bl, true)) != null); ++n) {
                }
            }
        }
        return dBObject;
    }

    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        collection.addAll(this.m_properties.getOwnedObjects(stringArray));
    }

    protected final void includeOwnedObject(Collection<DBObject> collection, DBObject dBObject, String ... stringArray) {
        if (this.includesType(dBObject, stringArray)) {
            collection.add(dBObject);
        }
    }

    protected final boolean includesType(String string, String ... stringArray) {
        return this.includesType(string, (Class<? extends DBObject>)null, stringArray);
    }

    protected final boolean includesType(DBObject dBObject, String ... stringArray) {
        if (dBObject != null) {
            return this.includesType(dBObject.getType(), dBObject.getClass(), stringArray);
        }
        return false;
    }

    private final boolean includesType(String string, Class<? extends DBObject> clazz, String ... stringArray) {
        if (ModelUtil.hasNonNullElement((Object[])stringArray)) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                return true;
            }
            Metadata metadata = Metadata.getInstance();
            for (String string2 : stringArray) {
                Collection<String> collection;
                Class<? extends DBObject> clazz2 = metadata.getObjectClass(string2);
                if (clazz2 == null) continue;
                if (clazz != null && clazz2.isAssignableFrom(clazz)) {
                    return true;
                }
                if (Metadata.isRealBean(clazz2) || !(collection = metadata.getAllTypes(clazz2)).contains(string)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean removeOwnedObject(DBObject dBObject) {
        return this.m_properties.removeOwnedObject(dBObject);
    }

    @Override
    public final DBObjectID[] getReferenceIDs() {
        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
        this.getReferenceIDsImpl(arrayList);
        return arrayList.toArray(new DBObjectID[arrayList.size()]);
    }

    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
        this.m_properties.addAllReferenceIDs(collection);
    }

    @Override
    public boolean replaceReferenceIDs(Map<? extends DBObjectID, ? extends DBObjectID> map) {
        return this.m_properties.replaceReferenceIDs(map);
    }

    protected final ChildSupport getChildSupport(String string) {
        return this.m_properties.findOrCreateChildSupport(string);
    }

    private boolean isChildUnordered(String string) {
        return string.equals("constraints") || string.equals("indexes");
    }

    static final Logger getPropertyLogger() {
        return DBLog.getLogger(AbstractDBObject.class);
    }

    private static Executor createDefaultExecutor() {
        final ReentrantLock reentrantLock = new ReentrantLock();
        return new Executor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Runnable runnable) {
                if (!reentrantLock.tryLock()) {
                    String string = Thread.currentThread().getName();
                    Logger logger = AbstractDBObject.getPropertyLogger();
                    logger.fine("Waiting for property lock on " + string);
                    reentrantLock.lock();
                    logger.fine("Got property lock on " + string);
                }
                try {
                    runnable.run();
                }
                finally {
                    reentrantLock.unlock();
                }
            }
        };
    }

    protected static ChildSupport getChildSupport(AbstractDBObject abstractDBObject, String string) {
        return abstractDBObject.getChildSupport(string);
    }

    private class ListenerBridge
    extends oracle.javatools.db.event.DBObjectListener {
        private Object m_list;

        ListenerBridge(Object object) {
            this.m_list = object;
        }

        @Override
        public void objectUpdated(oracle.javatools.db.event.DBObjectChange dBObjectChange) {
            if (dBObjectChange instanceof DBObjectChange) {
                if (this.m_list instanceof SchemaObjectListener) {
                    ((SchemaObjectListener)this.m_list).schemaObjectUpdated((DBObjectChange)dBObjectChange);
                } else if (this.m_list instanceof oracle.javatools.db.event.DBObjectListener) {
                    ((oracle.javatools.db.event.DBObjectListener)this.m_list).objectUpdated((DBObjectChange)dBObjectChange);
                }
            }
        }

        public boolean equals(Object object) {
            return object instanceof ListenerBridge && ModelUtil.areEqual((Object)this.m_list, (Object)((ListenerBridge)object).m_list);
        }
    }

    protected final class ListenerSupport {
        private final Collection<oracle.javatools.db.event.DBObjectListener> m_listeners = new CopyOnWriteArraySet<oracle.javatools.db.event.DBObjectListener>();

        public void addBridgedListener(Object object) {
            if (object != null) {
                this.addObjectListener(new ListenerBridge(object));
            }
        }

        public void removeBridgedListener(Object object) {
            if (object != null) {
                this.removeObjectListener(new ListenerBridge(object));
            }
        }

        public void removeObjectListener(oracle.javatools.db.event.DBObjectListener dBObjectListener) {
            if (dBObjectListener != null) {
                this.m_listeners.remove(dBObjectListener);
            }
        }

        public void addObjectListener(oracle.javatools.db.event.DBObjectListener dBObjectListener) {
            if (dBObjectListener != null) {
                this.m_listeners.add(dBObjectListener);
            }
        }

        public void fireObjectUpdated(oracle.javatools.db.event.DBObjectChange dBObjectChange) {
            for (oracle.javatools.db.event.DBObjectListener dBObjectListener : this.m_listeners) {
                try {
                    dBObjectListener.objectUpdated(dBObjectChange);
                }
                catch (Exception exception) {
                    DBLog.logStackTrace(MessageFormat.format("listener {0} threw exception:", dBObjectListener.getClass()), exception);
                }
            }
        }
    }

    private abstract class ChildRunnable {
        private ChildRunnable() {
        }

        public abstract void run(List var1);
    }

    class PropertySupport
    extends AbstractMap<String, Object> {
        private final Map<String, Object> m_cache = new ConcurrentHashMap<String, Object>();
        private final Map<String, ChildSupport> m_childSupportCache = new HashMap<String, ChildSupport>();

        PropertySupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ChildSupport findOrCreateChildSupport(String string) {
            Map<String, ChildSupport> map = this.m_childSupportCache;
            synchronized (map) {
                ChildSupport childSupport = this.m_childSupportCache.get(string);
                if (childSupport == null) {
                    childSupport = new ChildSupport(string);
                    this.m_childSupportCache.put(string, childSupport);
                }
                return childSupport;
            }
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.m_cache.entrySet();
        }

        @Override
        public Object put(String string, Object object) {
            Object object2 = object == null ? this.m_cache.remove(string) : this.m_cache.put(string, object);
            if (object2 != object) {
                if (object2 instanceof Object[] || object instanceof Object[]) {
                    if (object instanceof DBObject[]) {
                        if (AbstractDBObject.this.isChildUnordered(string)) {
                            Arrays.sort((DBObject[])object, DBUtil.getTypeComparator());
                        }
                        for (Object object3 : (Object[])object) {
                            if (object3 != null) continue;
                            AbstractDBObject.getPropertyLogger().severe("null child");
                        }
                    }
                    this.findOrCreateChildSupport(string).ensureParentsAndFireEvents((Object[])object2, (Object[])object);
                } else {
                    this.removeCurrentParent(object2);
                    this.setCurrentParent(object);
                    AbstractDBObject.this.firePropertyChanged(string, object2, object);
                }
            }
            return object2;
        }

        private void removeCurrentParent(Object object) {
            if (object instanceof ChildDBObject) {
                AbstractDBObject.this.removeThisAsParent((ChildDBObject)object);
            } else if (object instanceof Object[]) {
                for (Object object2 : (Object[])object) {
                    if (!(object2 instanceof ChildDBObject)) continue;
                    AbstractDBObject.this.removeThisAsParent((ChildDBObject)object2);
                }
            }
        }

        private void setCurrentParent(Object object) {
            if (object instanceof ChildDBObject) {
                AbstractDBObject.this.changeParent(null, (ChildDBObject)object);
            } else if (object instanceof Object[]) {
                for (Object object2 : (Object[])object) {
                    if (!(object2 instanceof ChildDBObject)) continue;
                    AbstractDBObject.this.changeParent(null, (ChildDBObject)object2);
                }
            }
        }

        void addAllReferenceIDs(Collection<DBObjectID> collection) {
            for (Map.Entry<String, Object> entry : this.m_cache.entrySet()) {
                String string = entry.getKey();
                if (Metadata.getInstance().isStaticReferenceProperty(string)) continue;
                Object object = entry.getValue();
                if (object instanceof DBObjectID) {
                    collection.add((DBObjectID)object);
                    continue;
                }
                if (!(object instanceof Object[])) continue;
                for (Object object2 : (Object[])object) {
                    if (!(object2 instanceof DBObjectID)) continue;
                    collection.add((DBObjectID)object2);
                }
            }
        }

        public boolean replaceReferenceIDs(Map<? extends DBObjectID, ? extends DBObjectID> map) {
            boolean bl = false;
            for (Map.Entry<String, Object> entry : this.m_cache.entrySet()) {
                Object[] objectArray;
                String string = entry.getKey();
                if (Metadata.getInstance().isStaticReferenceProperty(string)) continue;
                Object object = entry.getValue();
                if (object instanceof DBObjectID) {
                    objectArray = map.get(object);
                    if (objectArray == null) continue;
                    entry.setValue(objectArray);
                    bl = true;
                    continue;
                }
                if (!(object instanceof Object[])) continue;
                objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2 = objectArray[i];
                    if (!(object2 instanceof DBObjectID) || !map.containsKey(object2)) continue;
                    objectArray[i] = map.get(object2);
                    bl = true;
                }
            }
            return bl;
        }

        public Collection<DBObject> getOwnedObjects(String ... stringArray) {
            ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
            for (Map.Entry<String, Object> entry : this.m_cache.entrySet()) {
                Object object = entry.getValue();
                if (object instanceof DBObject && ModelUtil.areDifferent((Object)"schema", (Object)entry.getKey())) {
                    AbstractDBObject.this.includeOwnedObject(arrayList, (DBObject)object, stringArray);
                    continue;
                }
                if (!(object instanceof Object[])) continue;
                for (Object object2 : (Object[])object) {
                    if (!(object2 instanceof DBObject)) continue;
                    AbstractDBObject.this.includeOwnedObject(arrayList, (DBObject)object2, stringArray);
                }
            }
            return arrayList;
        }

        public boolean removeOwnedObject(DBObject dBObject) {
            boolean bl = false;
            for (Map.Entry<String, Object> entry : this.m_cache.entrySet()) {
                ChildSupport childSupport;
                String string = entry.getKey();
                Object object = entry.getValue();
                if (object == dBObject) {
                    this.remove(string);
                    bl = true;
                    break;
                }
                if (!(object instanceof Object[]) || !(childSupport = AbstractDBObject.this.getChildSupport(string)).removeChild(dBObject)) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public void copyTo(PropertySupport propertySupport, IDPolicy iDPolicy) {
            this.copyTo(propertySupport, iDPolicy, null);
        }

        protected final void copyTo(PropertySupport propertySupport, IDPolicy iDPolicy, Collection<String> collection) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(this.m_cache.keySet());
            hashSet.addAll(propertySupport.m_cache.keySet());
            if (collection != null) {
                hashSet.removeAll(collection);
            }
            HashMap<String, PropertyChangeEvent> hashMap = new HashMap<String, PropertyChangeEvent>();
            AbstractDBObject abstractDBObject = propertySupport.getParentForChildren();
            for (String string : hashSet) {
                Object object;
                Object object2;
                Object object3;
                Object object4 = this.m_cache.get(string);
                AbstractDBObject abstractDBObject2 = propertySupport.getParentForChildren();
                if (object4 instanceof Object[]) {
                    if (propertySupport.containsKey(string)) {
                        object3 = new ChildSupport(string);
                        AbstractDBObject abstractDBObject3 = abstractDBObject2;
                        Objects.requireNonNull(abstractDBObject3);
                        ChildSupport childSupport = abstractDBObject3.new ChildSupport(string);
                        ((ChildSupport)object3).copyTo(childSupport, abstractDBObject2, iDPolicy);
                        object2 = childSupport;
                        object = null;
                    } else {
                        object2 = AbstractDBObject.this.copyObject(object4, abstractDBObject2, iDPolicy);
                        object = propertySupport.put(string, object2);
                    }
                } else if (object4 != null) {
                    object3 = propertySupport.get(string);
                    object2 = object4 instanceof AbstractDBObject && object3 != null && object4.getClass().equals(object3.getClass()) ? ((AbstractDBObject)object4).copyTo((AbstractDBObject)object3, abstractDBObject2, iDPolicy) : AbstractDBObject.this.copyObject(object4, abstractDBObject2, iDPolicy);
                    object = propertySupport.put(string, object2);
                } else {
                    object = propertySupport.remove(string);
                    object2 = null;
                }
                if (object != object2) continue;
                hashMap.put(string, new PropertyChangeEvent(abstractDBObject, string, object, object2));
            }
            Iterator iterator = abstractDBObject.m_compoundChange;
            if (iterator != null && iterator.get() != null && !hashMap.isEmpty()) {
                oracle.javatools.db.event.DBObjectChange.firePropertiesChanged(propertySupport.getParentForChildren(), hashMap);
            }
        }

        @Override
        public Object remove(Object object) {
            return this.put((String)object, (Object)null);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof PropertySupport && this.equalsImpl((PropertySupport)object);
        }

        private boolean equalsImpl(PropertySupport propertySupport) {
            return DBUtil.areEqualIgnoreNullValues(this.m_cache, propertySupport.m_cache);
        }

        public AbstractDBObject getParentForChildren() {
            return AbstractDBObject.this;
        }
    }

    protected class ChildSupport {
        private final String m_key;
        private final Lock m_lock = new ReentrantLock();
        private Class m_clz;

        private ChildSupport(String string) {
            this.m_key = string;
        }

        private void lock() {
            this.m_lock.lock();
        }

        private void unlock() {
            this.m_lock.unlock();
        }

        private Class getComponentType() {
            if (this.m_clz == null) {
                PropertyInfo propertyInfo = PropertyHelper.findPropertyInfo(AbstractDBObject.this.getClass(), this.m_key, (DBObjectProvider)null);
                if (propertyInfo == null) {
                    AbstractDBObject.getPropertyLogger().warning("unrecognized child property: " + this.m_key);
                } else {
                    Class<?> clazz = propertyInfo.getPropertyClass();
                    if (clazz.isArray()) {
                        this.m_clz = clazz.getComponentType();
                    } else {
                        AbstractDBObject.getPropertyLogger().warning("child property is not an array: " + this.m_key);
                    }
                }
            }
            return this.m_clz;
        }

        private boolean canAddChild(List list, Object object) {
            boolean bl = true;
            if (object instanceof ChildDBObject) {
                bl = this.indexOfChildDBObject(list, (ChildDBObject)object) < 0;
            }
            return bl;
        }

        private int indexOfChild(List list, Object object) {
            int n = -1;
            n = object instanceof ChildDBObject ? this.indexOfChildDBObject(list, (ChildDBObject)object) : list.indexOf(object);
            return n;
        }

        private int indexOfChildDBObject(List list, ChildDBObject childDBObject) {
            int n = -1;
            if (childDBObject != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (childDBObject != e) continue;
                    n = i;
                    break;
                }
            }
            return n;
        }

        public void addChild(Object object) {
            this.addChildImpl(null, object);
        }

        public void addChild(int n, Object object) {
            this.addChildImpl(n, object);
        }

        private void addChildImpl(final Integer n, final Object object) {
            if (object != null) {
                this.runUnderChildLock(new ChildRunnable(){

                    @Override
                    public void run(List list) {
                        if (ChildSupport.this.canAddChild(list, object)) {
                            if (n == null) {
                                list.add(object);
                            } else {
                                list.add(n, object);
                            }
                            ChildSupport.this.setChildren(list);
                        }
                    }
                });
            }
        }

        public boolean moveChild(final Object object, final int n) {
            final Holder holder = new Holder((Object)false);
            if (object != null) {
                this.runUnderChildLock(new ChildRunnable(){

                    @Override
                    public void run(List list) {
                        int n2;
                        if (list != null && (n2 = list.indexOf(object)) != n && ChildSupport.this.removeFromList(list, object)) {
                            list.add(n, object);
                            ChildSupport.this.setChildren(list);
                            holder.set((Object)true);
                        }
                    }
                });
            }
            return (Boolean)holder.get();
        }

        public int indexOfChild(final Object object) {
            final Holder holder = new Holder((Object)-1);
            if (object != null) {
                this.runUnderChildLock(new ChildRunnable(){

                    @Override
                    public void run(List list) {
                        if (list != null) {
                            holder.set((Object)ChildSupport.this.indexOfChild(list, object));
                        }
                    }
                });
            }
            return (Integer)holder.get();
        }

        @Deprecated
        public <T> T setChildAt(int n, T t) {
            return null;
        }

        public boolean removeChild(final Object object) {
            final Holder holder = new Holder((Object)false);
            this.runUnderChildLock(new ChildRunnable(){

                @Override
                public void run(List list) {
                    if (list != null && ChildSupport.this.removeFromList(list, object)) {
                        holder.set((Object)true);
                        ChildSupport.this.setChildren(list);
                    }
                }
            });
            return (Boolean)holder.get();
        }

        private boolean removeFromList(List list, Object object) {
            boolean bl = false;
            if (object instanceof ChildDBObject) {
                int n = this.indexOfChildDBObject(list, (ChildDBObject)object);
                if (n >= 0) {
                    list.remove(n);
                    bl = true;
                }
            } else {
                bl = list.remove(object);
            }
            return bl;
        }

        public Object findChild(String string) {
            return this.findChild(string, null);
        }

        private Object findChild(final String string, final Integer n) {
            final Holder holder = new Holder();
            if (string != null) {
                this.runUnderChildLock(new ChildRunnable(){

                    @Override
                    public void run(List list) {
                        for (int i = 0; i < list.size(); ++i) {
                            boolean bl = false;
                            Object e = list.get(i);
                            if (!(e instanceof DBObject) || !ModelUtil.areEqual((Object)string, (Object)((DBObject)e).getName())) continue;
                            holder.set(e);
                            if (n == null || i == n) break;
                            if (bl) {
                                holder.set(null);
                                break;
                            }
                            bl = true;
                        }
                    }
                });
            }
            return holder.get();
        }

        public void clearChildren() {
            AbstractDBObject.this.setProperty(this.m_key, null);
        }

        public <T> T[] getChildArray(Class<T> clazz) {
            Object[] objectArray = this.getArrayPropertyValue();
            Object[] objectArray2 = objectArray == null ? (Object[])Array.newInstance(clazz, 0) : objectArray;
            return objectArray2;
        }

        public void setChildArray(Object[] objectArray) {
            if (objectArray != null && objectArray.length == 0) {
                objectArray = null;
            }
            AbstractDBObject.this.setProperty(this.m_key, objectArray);
        }

        private void setChildren(List list) {
            this.setChildArray(this.toArray(list));
        }

        /*
         * WARNING - void declaration
         */
        private void ensureParentsAndFireEvents(final Object[] objectArray, final Object[] objectArray2) {
            Object object;
            final ArrayList<Object> arrayList = new ArrayList<Object>();
            final ArrayList<Object> arrayList2 = new ArrayList<Object>();
            if (objectArray != null) {
                void e;
                Object[] objectArray3 = objectArray;
                int n2 = objectArray3.length;
                boolean n = false;
                while (e < n2) {
                    object = objectArray3[e];
                    arrayList2.add(object);
                    ++e;
                }
            }
            boolean bl = true;
            if (objectArray2 != null) {
                void var7_14;
                List<Object> list = objectArray == null ? Collections.emptyList() : Arrays.asList(objectArray);
                boolean bl2 = false;
                while (var7_14 < objectArray2.length) {
                    object = objectArray2[var7_14];
                    if (object != null) {
                        int n = this.indexOfChild(list, object);
                        if (n != var7_14) {
                            bl = false;
                        }
                        if (n > -1) {
                            this.removeFromList(arrayList2, object);
                        } else {
                            arrayList.add(object);
                            AbstractDBObject.this.m_properties.setCurrentParent(object);
                        }
                    }
                    ++var7_14;
                }
            }
            for (Object e : arrayList2) {
                AbstractDBObject.this.m_properties.removeCurrentParent(e);
            }
            if (arrayList.size() > 0 || arrayList2.size() > 0 || !bl) {
                final boolean bl2 = objectArray instanceof DBObject[] || objectArray2 instanceof DBObject[];
                AbstractDBObject.this.fireObjectUpdated(new oracle.javatools.db.event.DBObjectChange(AbstractDBObject.this, null){

                    @Override
                    public List<DBObject> getOwnedObjectsAdded() {
                        return bl2 ? arrayList : super.getOwnedObjectsAdded();
                    }

                    @Override
                    public List<DBObject> getOwnedObjectsRemoved() {
                        return bl2 ? arrayList2 : super.getOwnedObjectsRemoved();
                    }

                    @Override
                    public Map<String, PropertyChangeEvent> getPropertiesChanged() {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(AbstractDBObject.this, ChildSupport.this.m_key, objectArray, objectArray2);
                        return Collections.singletonMap(ChildSupport.this.m_key, propertyChangeEvent);
                    }
                });
            }
        }

        private Object[] toArray(List list) {
            Object[] objectArray = null;
            if (list != null && list.size() > 0) {
                Class clazz = this.getComponentType();
                if (clazz == null) {
                    for (Object e : list) {
                        if (e == null) continue;
                        Class<?> clazz2 = e.getClass();
                        clazz = DBUtil.findCommonSuperclass(clazz2, clazz);
                    }
                }
                if (clazz != null) {
                    try {
                        objectArray = (Object[])Array.newInstance(clazz, list.size());
                        objectArray = list.toArray(objectArray);
                    }
                    catch (ArrayStoreException arrayStoreException) {
                        AbstractDBObject.getPropertyLogger().severe("Invalid property value for property " + this.m_key);
                    }
                }
            }
            return objectArray;
        }

        public int getChildCount() {
            Object[] objectArray = this.getArrayPropertyValue();
            return objectArray == null ? 0 : objectArray.length;
        }

        @Deprecated
        public List getChildList(boolean bl) {
            Object[] objectArray = this.getArrayPropertyValue();
            return objectArray == null ? Collections.emptyList() : Arrays.asList(objectArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runUnderChildLock(ChildRunnable childRunnable) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object[] objectArray = this.getArrayPropertyValue();
            this.lock();
            try {
                if (objectArray != null) {
                    for (Object object : objectArray) {
                        arrayList.add(object);
                    }
                }
                childRunnable.run(arrayList);
            }
            finally {
                this.unlock();
            }
        }

        private Object[] getArrayPropertyValue() {
            Object[] objectArray;
            Object object = AbstractDBObject.this.getProperty(this.m_key);
            if (object instanceof Object[]) {
                objectArray = (Object[])object;
            } else if (object == null) {
                objectArray = null;
            } else {
                throw new IllegalStateException("property is not a list: " + this.m_key);
            }
            return objectArray;
        }

        private void copyTo(ChildSupport childSupport, AbstractDBObject abstractDBObject, IDPolicy iDPolicy) {
            Object[] objectArray = this.getArrayPropertyValue();
            if (objectArray == null) {
                childSupport.clearChildren();
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object;
                    Object object2 = objectArray[i];
                    if (object2 instanceof AbstractDBObject) {
                        Object object3;
                        AbstractDBObject abstractDBObject2 = (AbstractDBObject)object2;
                        Object object4 = null;
                        if (iDPolicy instanceof TemporaryObjectID.CopyBackPolicy && abstractDBObject2.m_id instanceof TemporaryObjectID && (object3 = TemporaryObjectID.getOriginalObject(abstractDBObject2)).getParent() == childSupport.getParentForChildren()) {
                            object4 = object3;
                        }
                        if (object4 == null && (object3 = (String)abstractDBObject2.m_properties.get("name")) != null) {
                            object4 = (DBObject)childSupport.findChild((String)object3, i);
                        }
                        object = ((AbstractDBObject)object2).copyTo((DBObject)object4, abstractDBObject, iDPolicy);
                    } else {
                        object = AbstractDBObject.this.copyObject(object2, abstractDBObject, iDPolicy);
                    }
                    arrayList.add(object);
                }
                childSupport.setChildren(arrayList);
            }
        }

        private AbstractDBObject getParentForChildren() {
            return AbstractDBObject.this;
        }
    }
}

