/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.TemporaryObjectID;

@FunctionalInterface
public interface DBObjectFilter<T extends DBObject> {
    public boolean accept(T var1);

    public static class IDFilter<T extends DBObject>
    implements DBObjectFilter<T> {
        private DBObjectID m_id;
        private boolean m_strict;

        public IDFilter(DBObjectID dBObjectID, boolean bl) {
            if (dBObjectID == null) {
                throw new IllegalArgumentException("must initialise with a valid id");
            }
            this.m_id = dBObjectID;
            this.m_strict = bl;
        }

        @Override
        public boolean accept(T t) {
            DBObjectID dBObjectID = t.getID();
            if (dBObjectID instanceof TemporaryObjectID) {
                return dBObjectID.equals(this.m_id, this.m_strict);
            }
            return this.m_id.equals(dBObjectID, this.m_strict);
        }
    }
}

