/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav.cmd;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITAbstractOperation;
import oracle.jdevimpl.vcs.git.nav.GITRepositoryNavigator;
import oracle.jdevimpl.vcs.git.nav.GITStashFileNode;
import oracle.jdevimpl.vcs.git.nav.GITStashNode;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITStashApplyPanel;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITStashApplyCommand
extends GITAbstractOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.git.stash-apply";

    public GITStashApplyCommand() {
        super(COMMAND_ID);
    }

    protected int doitImpl() throws Exception {
        GITStashApplyPanel panel = new GITStashApplyPanel();
        panel.setStash(this.getContext().getNode().getShortLabel());
        panel.setWorkingTree(URLFileSystem.getPlatformPathName((URL)GITUtil.getClientRoot()));
        JEWTDialog dialog = this.createDialog(panel);
        if (VCSDialogRunner.runDialog((JDialog)dialog)) {
            return 0;
        }
        return 1;
    }

    private void applyStash(int stashIndex, String stashName, boolean drop) throws GITProcessException {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("applyStash");
        GitClient client = null;
        final IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)IdeUtil.getMainWindow(), Resource.get("STASH_APPLY_PROGRESS_TITLE"), (Object)Resource.get("STASH_APPLY_PROGRESS"), null);
        VCSCancellable cancellable = new VCSCancellable(){

            public boolean isCancelled() {
                return progress.isCanceled();
            }
        };
        try {
            progress.start();
            monitor.setLog(true);
            monitor.setCancellable(cancellable);
            URL root = GITUtil.getClientRoot();
            client = GITClientAdaptor.getClient(root);
            try {
                client.stashApply(stashIndex, drop, (ProgressMonitor)monitor);
            }
            catch (GitException e) {
                GITProfile.getQualifiedLogger(GITStashApplyCommand.class.getName()).log(Level.WARNING, e.getMessage());
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.get("STASH_APPLY_ERROR"), (String)Resource.get("STASH_APPLY_TITLE"), null);
            }
            if (monitor.getError() != null) {
                GITProfile.getQualifiedLogger(GITStashApplyCommand.class.getName()).log(Level.WARNING, monitor.getError());
                throw new GITProcessException(Resource.format("ERROR_APPLY_STASH", stashName), monitor.getError());
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITStashApplyCommand.class.getName()).log(Level.WARNING, e.getMessage());
            throw new GITProcessException(Resource.format("ERROR_APPLY_STASH", stashName), e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
            monitor.logCompleted();
            progress.finish();
        }
    }

    private JEWTDialog createDialog(final GITStashApplyPanel panel) {
        final JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)panel.getDefaultComp(), (String)this.getDialogTitle(), (int)7);
        dialog.setMinimumSize(400, 175);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("STASH_APPLY_HEADER"));
        dialog.setDialogHeader((Component)header);
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    return;
                }
                Thread applyStash = new Thread("GIT-Apply-Stash"){

                    @Override
                    public final void run() {
                        try {
                            Collection<URL> updated = this.getStashFiles();
                            GITStashApplyCommand.this.applyStash(((GITStashNode)GITStashApplyCommand.this.getContext().getNode()).getStashIndex(), GITStashApplyCommand.this.getContext().getNode().getShortLabel(), panel.isDropStash());
                            CommandState state = GITStashApplyCommand.this.getCommandState(updated);
                            state.setProperty("git.structure-changed", updated);
                            GITStashApplyCommand.this.postInvoke(VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git"), state);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public final void run() {
                                    dialog.setVisible(false);
                                    dialog.dispose();
                                    if (panel.isDropStash()) {
                                        GITRepositoryNavigator.getInstance().updateNavigator(GITUtil.getClientRoot(), true);
                                    }
                                }
                            });
                        }
                        catch (Exception ex) {
                            GITStashApplyCommand.this.getExceptionHandler().handleException(ex);
                        }
                    }

                    private Collection<URL> getStashFiles() {
                        ArrayList<URL> updated = new ArrayList<URL>();
                        Iterator it = ((GITStashNode)GITStashApplyCommand.this.getContext().getNode()).getChildren();
                        while (it.hasNext()) {
                            Node node = (Node)it.next();
                            if (!(node instanceof GITStashFileNode)) continue;
                            updated.add(URLFactory.newFileURL((File)((GITStashFileNode)node).getFile()));
                        }
                        return updated;
                    }
                };
                applyStash.start();
                throw new PropertyVetoException("", evt);
            }
        });
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, this.getHelpTopicId());
        return dialog;
    }

    @Override
    protected void postInvoke(VCSProfile profile, CommandState state) throws Exception {
        super.postInvoke(profile, state);
        Collection<URL> processed = this.getProcessedUrlsNotifier(state);
        this.fireSomeFilesCreated(processed.toArray(new URL[0]));
    }

    private CommandState getCommandState(Collection<URL> updated) {
        CommandState state = new CommandState();
        this.setProcessedUrls(state, updated.toArray(new URL[0]));
        Node[] affectedNodes = VCSModelUtils.findCachedNodes((URLFilter)VCSURLFilters.createBaseURLContentsFilter((URL[])updated.toArray(new URL[0])));
        Map timestamps = VCSBufferUtils.storeTimestamps(Arrays.asList(affectedNodes));
        state.setTimestampMap(timestamps);
        return state;
    }
}

