/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.patch;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.ide.util.MetaClass;
import oracle.ide.javaxide.Util;
import oracle.javatools.patch.PatchAssistance;
import oracle.jdeveloper.patch.DefaultPatchAssistance;
import oracle.jdeveloper.patch.PatchDialogExtender;

public class PatchAssistanceManager {
    private static Collection<AssistanceAdapter> _assist = new ArrayList<AssistanceAdapter>();
    private static Collection<DialogExtender> _extender = new ArrayList<DialogExtender>();

    static void registerAssistance(MetaClass mc) {
        AssistanceAdapter adapter = new AssistanceAdapter(mc);
        _assist.add(adapter);
    }

    static void registerDialogExtender(MetaClass mc) {
        DialogExtender dlgExtender = new DialogExtender(mc);
        _extender.add(dlgExtender);
    }

    public static PatchAssistance getAssistance(byte[] str) {
        for (AssistanceAdapter assist : _assist) {
            if (!assist.getPatchAssistance().isRecognised(str)) continue;
            return assist.getPatchAssistance();
        }
        return new DefaultPatchAssistance();
    }

    public static PatchDialogExtender getDialogExtender(URL url) {
        for (DialogExtender extender : _extender) {
            if (!extender.getDialogExtender().isRecognised(url)) continue;
            return extender.getDialogExtender();
        }
        return null;
    }

    private static class DialogExtender {
        private MetaClass _mc;
        private PatchDialogExtender _extender;

        private DialogExtender(MetaClass mc) {
            this._mc = mc;
        }

        private PatchDialogExtender getDialogExtender() {
            if (this._extender == null) {
                this._extender = (PatchDialogExtender)Util.createInstance((MetaClass)this._mc, PatchDialogExtender.class);
            }
            return this._extender;
        }
    }

    private static class AssistanceAdapter {
        private MetaClass _mc;
        private PatchAssistance _assist;

        private AssistanceAdapter(MetaClass mc) {
            this._mc = mc;
        }

        private PatchAssistance getPatchAssistance() {
            if (this._assist == null) {
                this._assist = (PatchAssistance)Util.createInstance((MetaClass)this._mc, PatchAssistance.class);
            }
            return this._assist;
        }
    }
}

