/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdConstraint
extends PersistableObject {
    public static final String TABLE_NAME = "MD_CONSTRAINTS";
    public static final String COLNAME_DELETE_CLAUSE = "DELETE_CLAUSE";
    public static final String COLNAME_NAME = "NAME";
    public static final String COLNAME_CONSTRAINT_TYPE = "CONSTRAINT_TYPE";
    public static final String COLNAME_TABLE_ID_FK = "TABLE_ID_FK";
    public static final String COLNAME_REFTABLE_ID_FK = "REFTABLE_ID_FK";
    public static final String COLNAME_CONSTRAINT_TEXT = "CONSTRAINT_TEXT";
    public static final String COLNAME_LANGUAGE = "LANGUAGE";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String COLNAME_COMMENTS = "COMMENTS";

    public MdConstraint(DBObjectId dBObjectId, String string) {
        this.setTableId(dBObjectId);
        this.setLanguage(string);
    }

    public static MdConstraint getExistingInstance(DBObjectId dBObjectId) {
        MdConstraint mdConstraint = new MdConstraint();
        mdConstraint.setKey(dBObjectId);
        return mdConstraint;
    }

    private MdConstraint() {
    }

    public static MdConstraint retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdConstraint mdConstraint = MdConstraint.getExistingInstance(dBObjectId);
        mdConstraint.retrieve(persistenceManager);
        return mdConstraint;
    }

    public void setDeleteClause(String string) {
        Field field = new Field(COLNAME_DELETE_CLAUSE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setName(String string) {
        Field field = new Field(COLNAME_NAME, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setConstraintType(String string) {
        Field field = new Field(COLNAME_CONSTRAINT_TYPE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    protected void setTableId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_TABLE_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setReftableId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_REFTABLE_ID_FK, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setConstraintText(String string) {
        Field field = new Field(COLNAME_CONSTRAINT_TEXT, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(string);
        field.setValue(clobHelper);
        this.setField(field);
    }

    public void setConstraintText(ClobHelper clobHelper) {
        Field field = new Field(COLNAME_CONSTRAINT_TEXT, "CLOBHELPER");
        field.setValue(clobHelper);
        this.setField(field);
    }

    public void setLanguage(String string) {
        Field field = new Field(COLNAME_LANGUAGE, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setComments(String string) {
        Field field = new Field(COLNAME_COMMENTS, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public String getDeleteClause() {
        Field field = this.getField(COLNAME_DELETE_CLAUSE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getName() {
        Field field = this.getField(COLNAME_NAME);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getConstraintType() {
        Field field = this.getField(COLNAME_CONSTRAINT_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getTableId() {
        Field field = this.getField(COLNAME_TABLE_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public DBObjectId getReftableId() {
        Field field = this.getField(COLNAME_REFTABLE_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public ClobHelper getConstraintText() {
        Field field = this.getField(COLNAME_CONSTRAINT_TEXT);
        if (field == null) {
            return null;
        }
        return field.getClobHelper();
    }

    public String getLanguage() {
        Field field = this.getField(COLNAME_LANGUAGE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getComments() {
        Field field = this.getField(COLNAME_COMMENTS);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            Object object = resultSet.getString(COLNAME_DELETE_CLAUSE);
            if (resultSet.wasNull()) {
                this.setDeleteClause(null);
            } else {
                this.setDeleteClause((String)object);
            }
            object = resultSet.getString(COLNAME_NAME);
            if (resultSet.wasNull()) {
                this.setName(null);
            } else {
                this.setName((String)object);
            }
            object = resultSet.getString(COLNAME_CONSTRAINT_TYPE);
            if (resultSet.wasNull()) {
                this.setConstraintType(null);
            } else {
                this.setConstraintType((String)object);
            }
            this.setTableId(new DBObjectId(resultSet.getLong(COLNAME_TABLE_ID_FK)));
            object = new DBObjectId(resultSet.getLong(COLNAME_REFTABLE_ID_FK));
            if (resultSet.wasNull()) {
                this.setReftableId(null);
            } else {
                this.setReftableId((DBObjectId)object);
            }
            object = new ClobHelper(resultSet.getClob(COLNAME_CONSTRAINT_TEXT));
            if (resultSet.wasNull()) {
                this.setConstraintText((ClobHelper)null);
            } else {
                this.setConstraintText((ClobHelper)object);
            }
            this.setLanguage(resultSet.getString(COLNAME_LANGUAGE));
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
            object = resultSet.getString(COLNAME_COMMENTS);
            if (resultSet.wasNull()) {
                this.setComments(null);
            } else {
                this.setComments((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    public String getObjectName() {
        return this.getName();
    }

    @Override
    public String getObjectNameFieldName() {
        return COLNAME_NAME;
    }

    public void rename(String string) {
        this.setName(string);
    }

    @Override
    public String getContainerFieldName() {
        return COLNAME_TABLE_ID_FK;
    }

    @Override
    public DBObjectId getContainerId() {
        return this.getTableId();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

