/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.util;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import javax.xml.soap.SOAPMessage;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.X509Data;

public class WSSignatureParams {
    private String c14nMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String signMethod;
    private String digestMethod = "http://www.w3.org/2000/09/xmldsig#sha1";
    private boolean usingDecryptTranform = false;
    private PrivateKey signingKey;
    private byte[] secretKey;
    private X509Certificate cert;
    private byte[] certId;
    private String keyName;
    private X509Data iasn;
    private boolean usingSTRTransform = false;
    private KeyInfoData keyInfoData;
    private String keyInfoId;
    private boolean attachmentContentOnly = true;
    private SOAPMessage msg;
    private XSAlgorithmIdentifier[] commonTrans;

    public WSSignatureParams(byte[] hmacKey, PrivateKey signingKey) {
        this.secretKey = hmacKey;
        if (hmacKey != null) {
            this.signMethod = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        } else {
            this.signingKey = signingKey;
            if (signingKey instanceof RSAPrivateKey || signingKey.getAlgorithm().equals("RSA")) {
                this.signMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else if (signingKey instanceof DSAPrivateKey || signingKey.getAlgorithm().equals("DSA")) {
                this.signMethod = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            }
        }
    }

    public WSSignatureParams(String signMethod, boolean usingDecryptTranform) {
        this.signMethod = signMethod;
        this.usingDecryptTranform = usingDecryptTranform;
    }

    public WSSignatureParams(String c14nMethod, String signMethod, String digestMethod, boolean usingDecryptTranform) {
        this.c14nMethod = c14nMethod;
        this.signMethod = signMethod;
        this.digestMethod = digestMethod;
        this.usingDecryptTranform = usingDecryptTranform;
    }

    public String getC14NMethod() {
        return this.c14nMethod;
    }

    public String getSignatureMethod() {
        return this.signMethod;
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public boolean usingDecryptionTransform() {
        return this.usingDecryptTranform;
    }

    public void setSecretKey(byte[] secretKey) {
        this.secretKey = (byte[])secretKey.clone();
    }

    public void setPrivateKey(PrivateKey signingKey) {
        this.signingKey = signingKey;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public PrivateKey getPrivateKey() {
        return this.signingKey;
    }

    public void setX509Certificate(X509Certificate cert) {
        this.cert = cert;
    }

    public void setCertId(byte[] certId) {
        this.certId = certId;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public void setX509IssuerAndSerialNumber(X509Data iasn) {
        this.iasn = iasn;
    }

    public X509Certificate getX509Certificate() {
        return this.cert;
    }

    public byte[] getCertId() {
        return this.certId;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public X509Data getX509IssuerAndSerialNumber() {
        return this.iasn;
    }

    public boolean isAttachmentContentOnly() {
        return this.attachmentContentOnly;
    }

    public void setAttachmentContentOnly(boolean attachmentContentOnly) {
        this.attachmentContentOnly = attachmentContentOnly;
    }

    public KeyInfoData getKeyInfoData() {
        return this.keyInfoData;
    }

    public void setKeyInfoData(KeyInfoData keyInfoData) {
        this.keyInfoData = keyInfoData;
    }

    public String getKeyInfoId() {
        return this.keyInfoId;
    }

    public void setKeyInfoId(String keyInfoId) {
        this.keyInfoId = keyInfoId;
    }

    public SOAPMessage getSOAPMessage() {
        return this.msg;
    }

    public void setSOAPMessage(SOAPMessage msg) {
        this.msg = msg;
    }

    public boolean isUsingDecryptTranform() {
        return this.usingDecryptTranform;
    }

    public void setUsingDecryptTranform(boolean usingDecryptTranform) {
        this.usingDecryptTranform = usingDecryptTranform;
    }

    public boolean isUsingSTRTransform() {
        return this.usingSTRTransform;
    }

    public void setUsingSTRTransform(boolean usingSTRTransform) {
        this.usingSTRTransform = usingSTRTransform;
    }

    public String getC14nMethod() {
        return this.c14nMethod;
    }

    public void setC14nMethod(String method) {
        this.c14nMethod = method;
    }

    public String getSignMethod() {
        return this.signMethod;
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public void setDigestMethod(String digestMethod) {
        this.digestMethod = digestMethod;
    }

    public XSAlgorithmIdentifier[] getCommonTrans() {
        return this.commonTrans;
    }

    public void setCommonTrans(XSAlgorithmIdentifier[] commonTrans) {
        this.commonTrans = commonTrans;
    }
}

